/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.tracker;

import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class UpdateInItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public UpdateInItem(String tableID) {
        super("updatein", 3, -2, 75, tableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    @Override
    public void refresh(TableCell cell) {
        int secs;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        boolean show_blank = false;
        if (ps == null) {
            secs = -1;
        } else {
            int state = ps.getStatus();
            if (state != 1 && !ps.isUpdating()) {
                secs = ps.getSecondsToUpdate();
                if (secs == Integer.MIN_VALUE) {
                    show_blank = true;
                }
            } else {
                secs = -1;
                show_blank = true;
            }
        }
        if (!cell.setSortValue(secs) && cell.isValid()) {
            return;
        }
        if (show_blank) {
            cell.setForeground(null);
            cell.setText("");
        } else if (secs >= -1) {
            cell.setForeground(null);
            cell.setText(TimeFormatter.formatColon(secs < 0 ? 0 : secs));
        } else {
            cell.setForeground(secs < -5 ? Utils.colorToIntArray(Colors.colorWarning) : null);
            cell.setText("-" + TimeFormatter.formatColon(-secs));
        }
    }
}

