/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class UpRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public UpRatioItem(String table_id) {
        super("UpRatio", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        float value = 0.0f;
        long lDivisor = 0L;
        long lDivident = 0L;
        if (peer != null) {
            lDivisor = peer.getStats().getTotalBytesDownloadedByPeer() - peer.getStats().getTotalDataBytesSent();
            lDivident = peer.getStats().getTotalDataBytesSent();
            if (lDivisor > 1024L) {
                value = (float)lDivident / (float)lDivisor;
                if (value == 0.0f) {
                    value = -1.0f;
                }
            } else if (lDivident > 0L) {
                value = Float.MAX_VALUE;
            }
        }
        if (!cell.setSortValue((long)((double)value * 1000.0)) && cell.isValid()) {
            return;
        }
        String s = lDivisor <= 0L ? "" : (value == Float.MAX_VALUE ? "\u221e:1" : (value == -1.0f ? "1:\u221e" : String.valueOf(DisplayFormatters.formatDecimal(value, 2)) + ":1"));
        cell.setText(s);
    }
}

