/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PercentItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PercentItem(String table_id) {
        super("%", 2, -2, 55, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
    }

    @Override
    public void refresh(TableCell cell) {
        int value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        int n = value = peer == null ? 0 : peer.getPercentDoneInThousandNotation();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setNumeric((double)value / 10.0);
        cell.setText(DisplayFormatters.formatPercentFromThousands(value));
    }
}

