/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.text.NumberFormat;

public class SizeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "size";

    public SizeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content", "bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        long size;
        long remaining;
        Object ds = cell.getDataSource();
        boolean simpleSort = cell.useSimpleSortValue();
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)ds;
            remaining = dm.getStats().getRemainingExcludingDND();
            size = dm.getStats().getSizeExcludingDND();
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            remaining = fileInfo2.getLength() - fileInfo2.getDownloaded();
            size = fileInfo2.getLength();
        } else {
            return;
        }
        boolean showSecondLine = cell.getMaxLines() > 1 && remaining > 0L && cell.getWidth() > 150;
        sizeitemsort value = new sizeitemsort(size, simpleSort ? 0L : remaining, showSecondLine);
        if (value.compareTo(cell.getSortValue()) == 0 && cell.isValid()) {
            return;
        }
        cell.setSortValue(value);
        String s = DisplayFormatters.formatCustomSize("column.size", value.size);
        if (s == null) {
            s = DisplayFormatters.formatByteCountToKiBEtc(value.size);
        }
        if (showSecondLine) {
            s = String.valueOf(s) + "\n" + DisplayFormatters.formatByteCountToKiBEtc(remaining, false, false, 0) + " " + MessageText.getString("TableColumn.header.remaining");
        }
        cell.setText(s);
        TableColumnSWTUtils.setSizeAlpha(cell, size);
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm;
        long fullSize;
        Object ds;
        Comparable sortValue = cell.getSortValue();
        if (!(sortValue instanceof sizeitemsort)) {
            return;
        }
        sizeitemsort value = (sizeitemsort)sortValue;
        String tooltip = String.valueOf(NumberFormat.getInstance().format(value.size)) + " " + MessageText.getString("DHTView.transport.bytes");
        if (value.remaining > 0L) {
            tooltip = String.valueOf(tooltip) + "\n" + DisplayFormatters.formatByteCountToKiBEtc(value.remaining, false, false) + " " + MessageText.getString("TableColumn.header.remaining");
        }
        if ((ds = cell.getDataSource()) instanceof DownloadManager && (fullSize = (dm = (DownloadManager)ds).getSize()) > value.size) {
            tooltip = String.valueOf(tooltip) + "\n" + DisplayFormatters.formatByteCountToKiBEtc(fullSize - value.size, false, false) + " " + MessageText.getString("FileView.BlockView.Skipped");
        }
        cell.setToolTip(tooltip);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    private static class sizeitemsort
    implements Comparable {
        private final long size;
        private final long remaining;
        private final boolean showSecondLine;

        public sizeitemsort(long size, long remaining, boolean showSecondLine) {
            this.size = size;
            this.remaining = remaining;
            this.showSecondLine = showSecondLine;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof sizeitemsort)) {
                return 1;
            }
            sizeitemsort otherObj = (sizeitemsort)arg0;
            if (this.size == otherObj.size) {
                if (this.remaining == otherObj.remaining) {
                    return this.showSecondLine == otherObj.showSecondLine ? 0 : (this.showSecondLine ? 1 : -1);
                }
                return this.remaining > otherObj.remaining ? 1 : -1;
            }
            return this.size > otherObj.size ? 1 : -1;
        }
    }
}

