/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedLimitItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "maxdownspeed";

    public DownSpeedLimitItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 35, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0 : dm.getStats().getDownloadRateLimitBytesPerSecond();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value == -1L) {
            cell.setText(MessageText.getString("MyTorrents.items.DownSpeedLimit.disabled"));
        } else if (value == 0L) {
            cell.setText("\u221e");
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
        }
    }
}

