/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class DownItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "down";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress", "bytes"});
    }

    public DownItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        TableContextMenuItem menuItem = this.addContextMenuItem("label.set.downloaded");
        menuItem.setStyle(1);
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                final Object[] dms = (Object[])target;
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("set.downloaded.win.title", "set.downloaded.win.msg");
                entryWindow.setPreenteredText("-1", false);
                entryWindow.selectPreenteredText(true);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver receiver) {
                        if (!receiver.hasSubmittedInput()) {
                            return;
                        }
                        try {
                            String str = receiver.getSubmittedInput().trim();
                            if (str.startsWith("-")) {
                                double copies = Double.parseDouble(str.substring(1));
                                Object[] objectArray = dms;
                                int n = dms.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object object = objectArray[n2];
                                    if (object instanceof TableRowCore) {
                                        object = ((TableRowCore)object).getDataSource(true);
                                    }
                                    DownloadManager dm = (DownloadManager)object;
                                    DiskManagerFileInfo[] files = dm.getDiskManagerFileInfoSet().getFiles();
                                    long total_size = 0L;
                                    DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                                    int n3 = files.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        DiskManagerFileInfo file = diskManagerFileInfoArray[n4];
                                        if (!file.isSkipped()) {
                                            total_size += file.getLength();
                                        }
                                        ++n4;
                                    }
                                    dm.getStats().resetTotalBytesSentReceived(-1L, (long)((double)total_size * copies));
                                    ++n2;
                                }
                            } else {
                                long bytes = Long.parseLong(str);
                                Object[] objectArray = dms;
                                int n = dms.length;
                                int n5 = 0;
                                while (n5 < n) {
                                    Object object = objectArray[n5];
                                    if (object instanceof TableRowCore) {
                                        object = ((TableRowCore)object).getDataSource(true);
                                    }
                                    DownloadManager dm = (DownloadManager)object;
                                    dm.getStats().resetTotalBytesSentReceived(-1L, bytes);
                                    ++n5;
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        long value = 0L;
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            value = dm.getStats().getTotalGoodDataBytesReceived();
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            value = fileInfo2.getDownloaded();
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(value));
        cell.setToolTip(String.valueOf(value));
    }
}

