/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.util.Locale;

public class BadAvailTimeItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "bad_avail_time";
    private static String now_string;

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                now_string = MessageText.getString("SpeedView.stats.now");
            }
        });
    }

    public BadAvailTimeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm", "time"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? -1L : dm.getStats().getAvailWentBadTime();
        int seeds = 0;
        if (value == 0L) {
            PEPeerManager pm = dm.getPeerManager();
            if (pm == null || (double)pm.getMinAvailability() < 1.0) {
                long stopped = dm.getDownloadState().getLongAttribute("timestopped");
                value = stopped > 0L ? stopped : -1L;
            } else {
                seeds = pm.getNbSeeds();
                value = -2L;
            }
        }
        if (value > 0L) {
            super.refresh(cell, value);
        } else {
            String text;
            if (value == -2L) {
                if (dm.isDownloadComplete(false)) {
                    text = now_string;
                    value = Long.MAX_VALUE;
                } else {
                    text = String.valueOf(now_string) + " " + seeds;
                    value = 9223372036853775807L + (long)seeds;
                }
            } else {
                text = "";
            }
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            cell.setText(text);
        }
    }
}

