/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.text.NumberFormat;

public class SizeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    public SizeItem() {
        super("size", 2, -2, 70, "Files");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        long value;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        boolean internal = fileInfo2 instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf();
        long l = value = fileInfo2 == null ? 0L : fileInfo2.getLength();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value < 0L) {
            text = "";
            cell.setNumeric(Double.NaN);
        } else {
            text = DisplayFormatters.formatByteCountToKiBEtc(value);
            cell.setNumeric(value);
        }
        cell.setText(text);
        TableColumnSWTUtils.setSizeAlpha(cell, value);
    }

    @Override
    public void cellHover(TableCell cell) {
        long downloaded;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        if (fileInfo2 == null) {
            return;
        }
        long size = fileInfo2.getLength();
        String tooltip = String.valueOf(NumberFormat.getInstance().format(size)) + " " + MessageText.getString("DHTView.transport.bytes");
        if (!fileInfo2.isSkipped() && size != (downloaded = fileInfo2.getDownloaded())) {
            tooltip = String.valueOf(tooltip) + "\n" + DisplayFormatters.formatByteCountToKiBEtc(size - downloaded, false, false) + " " + MessageText.getString("TableColumn.header.remaining");
        }
        cell.setToolTip(tooltip);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

