/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class ColumnDateSizer
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    private static int PADDING = 10;
    private ParameterListener configDateFormatListener;
    int curFormat = 0;
    int[] maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
    Date[] maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
    private boolean showTime = true;
    private boolean multiline = true;
    private String tableFormatOverride = "";
    private ViewUtils.CustomDateFormat cdf;
    private boolean sortInvalidToBottom = false;
    private int sortChanging;
    private boolean recalculatingWidths;

    public ColumnDateSizer(String sName, int iAlignment, int iPosition, int iWidth, String sTableID) {
        super(sName, iAlignment, iPosition, iWidth, sTableID);
        this.init();
    }

    public ColumnDateSizer(Class forDataSourceType, String columnID, int width, String tableID) {
        super(forDataSourceType, columnID, 2, width, tableID);
        this.init();
    }

    private void init() {
        final TableContextMenuItem menuShowTime = this.addContextMenuItem("TableColumn.menu.date_added.time", 1);
        menuShowTime.setStyle(2);
        menuShowTime.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnDateSizer.this.showTime);
            }
        });
        menuShowTime.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ColumnDateSizer.this.showTime = !ColumnDateSizer.this.showTime;
                ColumnDateSizer.this.setUserData("showTime", new Long(ColumnDateSizer.this.showTime ? 1 : 0));
                ColumnDateSizer.this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.curFormat = -1;
                ColumnDateSizer.this.recalcWidth(new Date(), null);
                if (ColumnDateSizer.this.curFormat < 0) {
                    ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                }
            }
        });
        this.configDateFormatListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                ColumnDateSizer.this.tableFormatOverride = COConfigurationManager.getStringParameter("Table.column.dateformat", "");
                if (ColumnDateSizer.this.tableFormatOverride == null) {
                    ColumnDateSizer.this.tableFormatOverride = "";
                }
                ColumnDateSizer.this.curFormat = -1;
                if (ColumnDateSizer.this.tableFormatOverride.length() == 0) {
                    ColumnDateSizer.this.recalcWidth(new Date(), null);
                    if (ColumnDateSizer.this.curFormat < 0) {
                        ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                    }
                    menuShowTime.setVisible(true);
                } else {
                    ColumnDateSizer.this.invalidateCells();
                    menuShowTime.setVisible(false);
                }
            }
        };
        COConfigurationManager.addAndFireParameterListener("Table.column.dateformat", this.configDateFormatListener);
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    @Override
    public void remove() {
        COConfigurationManager.removeParameterListener("Table.column.dateformat", this.configDateFormatListener);
        super.remove();
    }

    @Override
    public void postConfigLoad() {
        int userMode;
        Number nShowTime;
        boolean oldShowTime = this.showTime;
        Object oShowTime = this.getUserData("showTime");
        this.showTime = oShowTime instanceof Number ? (nShowTime = (Number)oShowTime).byteValue() == 1 : (userMode = COConfigurationManager.getIntParameter("User Mode")) > 1;
        this.cdf.update();
        if (oldShowTime != this.showTime) {
            this.recalcWidth(new Date(), null);
        }
        super.postConfigLoad();
    }

    @Override
    public final void refresh(TableCell cell) {
        this.refresh(cell, 0L);
    }

    public void refresh(TableCell cell, long timestamp) {
        this.refresh(cell, timestamp, timestamp, null);
    }

    public void refresh(TableCell cell, long timestamp, String prefix) {
        this.refresh(cell, timestamp, timestamp, prefix);
    }

    public void refresh(final TableCell cell, final long timestamp, long sort_order, final String prefix) {
        if (!this.setSortValue(cell, sort_order) && cell.isValid()) {
            return;
        }
        if (timestamp <= 0L || timestamp == Long.MAX_VALUE) {
            cell.setText(prefix);
            return;
        }
        String cdf_str = this.cdf.formatDate(timestamp);
        if (cdf_str != null) {
            if (prefix != null) {
                cdf_str = String.valueOf(prefix) + cdf_str;
            }
            cell.setText(cdf_str);
            return;
        }
        if (this.tableFormatOverride.length() > 0) {
            Date date = new Date(timestamp);
            try {
                SimpleDateFormat temp = new SimpleDateFormat(this.tableFormatOverride);
                String date_str = temp.format(date);
                if (prefix != null) {
                    date_str = String.valueOf(prefix) + date_str;
                }
                cell.setText(date_str);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Date date = new Date(timestamp);
                if (ColumnDateSizer.this.curFormat >= 0) {
                    int newWidth;
                    String suffix;
                    if (ColumnDateSizer.this.multiline && cell.getHeight() < 20) {
                        ColumnDateSizer.this.multiline = false;
                    }
                    String string = suffix = ColumnDateSizer.this.showTime && !ColumnDateSizer.this.multiline ? " hh:mm a" : "";
                    if (ColumnDateSizer.this.sortChanging == 0 && (newWidth = ColumnDateSizer.this.calcWidth(date, String.valueOf(TimeFormatter.DATEFORMATS_DESC[ColumnDateSizer.this.curFormat]) + suffix, prefix)) > cell.getWidth() - PADDING) {
                        if (newWidth > ColumnDateSizer.this.maxWidthUsed[ColumnDateSizer.this.curFormat]) {
                            ColumnDateSizer.this.maxWidthUsed[ColumnDateSizer.this.curFormat] = newWidth;
                            ColumnDateSizer.this.maxWidthDate[ColumnDateSizer.this.curFormat] = date;
                        }
                        ColumnDateSizer.this.recalcWidth(date, prefix);
                    }
                    String s = String.valueOf(TimeFormatter.DATEFORMATS_DESC[ColumnDateSizer.this.curFormat]) + suffix;
                    SimpleDateFormat temp = new SimpleDateFormat(String.valueOf(s) + (ColumnDateSizer.this.showTime && ColumnDateSizer.this.multiline ? "\nh:mm a" : ""));
                    String date_str = temp.format(date);
                    if (prefix != null) {
                        date_str = String.valueOf(prefix) + date_str;
                    }
                    cell.setText(date_str);
                }
            }
        });
    }

    @Override
    public void setWidthPX(int width) {
        int oldWidth = this.getWidth();
        super.setWidthPX(width);
        if (oldWidth == width) {
            return;
        }
        if (this.maxWidthDate != null && this.curFormat >= 0) {
            if (this.maxWidthDate[this.curFormat] == null) {
                this.maxWidthDate[this.curFormat] = new Date();
            }
            this.recalcWidth(this.maxWidthDate[this.curFormat], null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recalcWidth(Date date, String prefix) {
        try {
            if (this.recalculatingWidths) {
                return;
            }
            this.recalculatingWidths = true;
            String suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
            int width = this.getWidth();
            if (this.maxWidthDate == null) {
                this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
            }
            int idxFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
            GC gc = new GC((Drawable)Display.getDefault());
            gc.setFont(FontUtils.getAnyFontBold(gc));
            try {
                try {
                    Point minSize = new Point(99999, 0);
                    int i = 0;
                    while (true) {
                        if (i >= TimeFormatter.DATEFORMATS_DESC.length) {
                        }
                        if (this.maxWidthUsed[i] <= width - PADDING) {
                            SimpleDateFormat temp = new SimpleDateFormat(String.valueOf(TimeFormatter.DATEFORMATS_DESC[i]) + suffix);
                            String date_str = temp.format(date);
                            if (prefix != null) {
                                date_str = String.valueOf(prefix) + date_str;
                            }
                            Point newSize = gc.stringExtent(date_str);
                            if (newSize.x < width - PADDING) {
                                idxFormat = i;
                                if (this.maxWidthUsed[i] < newSize.x) {
                                    this.maxWidthUsed[i] = newSize.x;
                                    this.maxWidthDate[i] = date;
                                }
                                break;
                            }
                            if (newSize.x < minSize.x) {
                                minSize = newSize;
                                idxFormat = i;
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    gc.dispose();
                    this.recalculatingWidths = false;
                    return;
                }
            }
            finally {
                gc.dispose();
            }
        }
        finally {
            this.recalculatingWidths = false;
        }
    }

    private int calcWidth(Date date, String format, String prefix) {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(FontUtils.getAnyFontBold(gc));
        SimpleDateFormat temp = new SimpleDateFormat(format);
        String date_str = temp.format(date);
        if (prefix != null) {
            date_str = String.valueOf(prefix) + date_str;
        }
        Point newSize = gc.stringExtent(date_str);
        gc.dispose();
        return newSize.x;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public void cellHover(TableCell cell) {
        long eta;
        long timestamp;
        Comparable ds = cell.getSortValue();
        if (ds instanceof Number && (timestamp = ((Number)((Object)ds)).longValue()) > 0L && (eta = (SystemTime.getCurrentTime() - timestamp) / 1000L) > 0L) {
            cell.setToolTip(String.valueOf(DisplayFormatters.formatETA(eta, false)) + " " + MessageText.getString("label.ago"));
        }
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    public void setSortInvalidToBottom(boolean b) {
        this.sortInvalidToBottom = b;
    }

    private boolean setSortValue(TableCell cell, long value) {
        if (this.sortInvalidToBottom && value <= 0L) {
            value = this.isSortAscending() ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return cell.setSortValue(value);
    }

    @Override
    public void setSortAscending(boolean bAscending) {
        super.setSortAscending(bAscending);
        Utils.execSWTThread(() -> {
            ++this.sortChanging;
            try {
                this.invalidateCells();
            }
            finally {
                --this.sortChanging;
            }
        });
    }
}

