/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCellClipboardListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableCellMenuEvent;
import com.biglybt.pif.ui.tables.TableCellMenuListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableColumnSortObject;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableColumnSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.impl.TableColumnSWTBase;
import com.biglybt.ui.swt.views.table.impl.TableRowSWTBase;
import com.biglybt.ui.swt.views.table.impl.TableTooltips;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class TableCellSWTBase
implements TableCellSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static AEMonitor this_mon = new AEMonitor("TableCell");
    protected static final int FLAG_VALID = 1;
    protected static final int FLAG_SORTVALUEISTEXT = 2;
    protected static final int FLAG_TOOLTIPISAUTO = 4;
    protected static final int FLAG_UPTODATE = 8;
    protected static final int FLAG_DISPOSED = 16;
    protected static final int FLAG_MUSTREFRESH = 32;
    public static final int FLAG_VISUALLY_CHANGED_SINCE_REFRESH = 64;
    private static final boolean DEBUGONLYZERO = false;
    private static final boolean DEBUG_FLAGS = false;
    private int flags = 2;
    protected TableRowSWTBase tableRowSWT;
    protected TableColumnSWTBase tableColumnSWT;
    protected TableColumnCore tableColumnCore;
    private byte tooltipErrLoopCount;
    public boolean bDebug = false;
    protected ArrayList<TableCellRefreshListener> refreshListeners;
    private ArrayList<TableCellDisposeListener> disposeListeners;
    private ArrayList<TableCellToolTipListener> tooltipListeners;
    private ArrayList<TableCellMouseListener> cellMouseListeners;
    private ArrayList<TableCellMenuListener> cellMenuListeners;
    private ArrayList<TableCellMouseMoveListener> cellMouseMoveListeners;
    private ArrayList<TableCellVisibilityListener> cellVisibilityListeners;
    protected ArrayList<TableCellSWTPaintListener> cellSWTPaintListeners;
    private ArrayList<TableCellClipboardListener> cellClipboardListeners;
    protected Comparable sortValue;
    private String textEquiv;
    private double numericValue = Double.NaN;
    private byte restartRefresh = 0;
    private boolean bInRefreshAsync = false;
    private byte refreshErrLoopCount;
    private byte loopFactor;
    protected static int MAX_REFRESHES = 10;
    private static int MAX_REFRESHES_WITHIN_MS = 100;
    private boolean bInRefresh = false;
    private long lastRefresh;
    protected int numFastRefreshes;
    private Object oToolTip;
    private Object defaultToolTip;
    private int textAlpha = 255;
    private boolean doFillCell = false;
    private int iCursorID = 0;
    private boolean mouseOver;
    private Image icon;
    private Graphic graphic = null;
    private Map<Object, Object> userData;

    public TableCellSWTBase(TableRowSWTBase row, TableColumnSWTBase column) {
        this.tableRowSWT = row;
        this.tableColumnSWT = column;
        this.tableColumnCore = column.getColumnCore();
        this.tooltipErrLoopCount = 0;
        this.refreshErrLoopCount = 0;
        this.loopFactor = 0;
    }

    protected void constructionComplete() {
        if (this.tableColumnCore != null && this.tableColumnCore.getType() == 2) {
            this.setMarginHeight(1);
            this.setMarginWidth(1);
        }
    }

    protected abstract void constructionCompleter();

    @Override
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            if (this.bDebug) {
                this.debug("addRefreshListener; count=" + this.refreshListeners.size());
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void addMenuListener(TableCellMenuListener listener) {
        try {
            this_mon.enter();
            if (this.cellMenuListeners == null) {
                this.cellMenuListeners = new ArrayList(1);
            }
            this.cellMenuListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public void removeMenuListener(TableCellMenuListener listener) {
        try {
            this_mon.enter();
            if (this.cellMenuListeners == null) {
                return;
            }
            this.cellMenuListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void addMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void removeMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    private void addSWTPaintListener(TableCellSWTPaintListener listener) {
        try {
            this_mon.enter();
            if (this.cellSWTPaintListeners == null) {
                this.cellSWTPaintListeners = new ArrayList(1);
            }
            this.cellSWTPaintListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void invokeSWTPaintListeners(GC gc) {
        Object[] swtPaintListeners;
        if (this.tableColumnCore != null && (swtPaintListeners = this.tableColumnCore.getCellOtherListeners("SWTPaint")) != null) {
            int i = 0;
            while (i < swtPaintListeners.length) {
                try {
                    TableCellSWTPaintListener l = (TableCellSWTPaintListener)swtPaintListeners[i];
                    l.cellPaint(gc, this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        if (this.cellSWTPaintListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellSWTPaintListeners.size()) {
            try {
                TableCellSWTPaintListener l = this.cellSWTPaintListeners.get(i);
                l.cellPaint(gc, this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    private void addCellClipboardListener(TableCellClipboardListener listener) {
        try {
            this_mon.enter();
            if (this.cellClipboardListeners == null) {
                this.cellClipboardListeners = new ArrayList(1);
            }
            this.cellClipboardListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    @Override
    public String getClipboardText() {
        String text;
        block9: {
            if (this.isDisposed()) {
                return "";
            }
            text = this.tableColumnCore.getClipboardText(this);
            if (text != null) {
                return text;
            }
            try {
                this_mon.enter();
                if (this.cellClipboardListeners == null) break block9;
                for (TableCellClipboardListener l : this.cellClipboardListeners) {
                    try {
                        text = l.getClipboardText(this);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    if (text == null) continue;
                    break;
                }
            }
            finally {
                this_mon.exit();
            }
        }
        if (text == null) {
            text = this.getText();
        }
        return text;
    }

    @Override
    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMenuListener) {
            this.addMenuListener((TableCellMenuListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableCellSWTPaintListener) {
            this.addSWTPaintListener((TableCellSWTPaintListener)listenerObject);
        }
        if (listenerObject instanceof TableCellClipboardListener) {
            this.addCellClipboardListener((TableCellClipboardListener)listenerObject);
        }
    }

    @Override
    public void invokeToolTipListeners(int type) {
        block9: {
            if (this.tableColumnCore == null) {
                return;
            }
            this.tableColumnCore.invokeCellToolTipListeners(this, type);
            if (this.tooltipListeners == null || this.tooltipErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumnCore.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                if (type == 0) {
                    int i = 0;
                    while (i < this.tooltipListeners.size()) {
                        this.tooltipListeners.get(i).cellHover(this);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.tooltipListeners.size()) {
                        this.tooltipListeners.get(i).cellHoverComplete(this);
                        ++i;
                    }
                }
                this.tooltipErrLoopCount = 0;
            }
            catch (Throwable e) {
                this.tooltipErrLoopCount = (byte)(this.tooltipErrLoopCount + 1);
                this.tableColumnCore.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.tooltipErrLoopCount <= 2) break block9;
                Logger.log(new LogEvent(LOGID, 3, "TableCell's tooltip will not be refreshed anymore this session."));
            }
        }
    }

    @Override
    public void invokeMouseListeners(TableCellMouseEvent event2) {
        ArrayList<TableCellMouseListener> listeners;
        ArrayList<TableCellMouseListener> arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        if (event2.cell != null && event2.row == null) {
            event2.row = event2.cell.getTableRow();
        }
        int i = 0;
        while (i < listeners.size()) {
            try {
                TableCellMouseListener l = listeners.get(i);
                l.cellMouseTrigger(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void invokeMenuListeners(TableCellMenuEvent event2) {
        ArrayList<TableCellMenuListener> listeners = this.cellMenuListeners;
        if (listeners == null) {
            return;
        }
        for (TableCellMenuListener listener : listeners) {
            if (event2.skipCoreFunctionality) break;
            try {
                listener.menuEventOccurred(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void invokeVisibilityListeners(int visibility, boolean invokeColumnListeners) {
        TableColumnCore tc = this.tableColumnCore;
        if (invokeColumnListeners && tc != null) {
            tc.invokeCellVisibilityListeners(this, visibility);
        }
        if (this.cellVisibilityListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellVisibilityListeners.size()) {
            try {
                TableCellVisibilityListener l = this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            Debug.out("Double disposal!");
            return;
        }
        this.setFlag(16);
        TableColumnCore tc = this.tableColumnCore;
        if (tc != null) {
            tc.invokeCellDisposeListeners(this);
        }
        if (this.disposeListeners != null) {
            try {
                for (TableCellDisposeListener listener : this.disposeListeners) {
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        this.refreshListeners = null;
        this.tableColumnCore = null;
        this.tableColumnSWT = null;
        this.tableRowSWT = null;
        this.sortValue = null;
    }

    public void debug(final String s) {
        Utils.execSWTThread((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (TableCellSWTBase.this.tableRowSWT == null) {
                    System.out.println(String.valueOf(SystemTime.getCurrentTime()) + ": c" + (TableCellSWTBase.this.tableColumnCore == null ? null : Integer.valueOf(TableCellSWTBase.this.tableColumnCore.getPosition())) + ";F=" + TableCellSWTBase.this.flagToText(TableCellSWTBase.this.flags, false) + ";" + s);
                } else {
                    System.out.println(String.valueOf(SystemTime.getCurrentTime()) + ": r" + TableCellSWTBase.this.tableRowSWT.getIndex() + "c" + (TableCellSWTBase.this.tableColumnCore == null ? null : Integer.valueOf(TableCellSWTBase.this.tableColumnCore.getPosition())) + ";r.v?" + (TableCellSWTBase.this.tableRowSWT.isVisible() ? "Y" : "N") + "F=" + TableCellSWTBase.this.flagToText(TableCellSWTBase.this.flags, false) + ";" + s);
                }
            }
        }, true);
    }

    protected void pluginError(Throwable e) {
        if (this.tableColumnCore != null) {
            String sTitleLanguageKey = this.tableColumnCore.getTitleLanguageKey();
            String sPosition = String.valueOf(this.tableColumnCore.getPosition()) + " (" + MessageText.getString(sTitleLanguageKey) + ")";
            Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
        } else {
            Logger.log(new LogEvent(LOGID, "Table Cell Plugin generated an exception ", e));
        }
    }

    protected void pluginError(String s) {
        String sPosition = "r" + this.tableRowSWT.getIndex() + "c" + this.tableColumnCore.getPosition();
        Logger.log(new LogEvent(LOGID, 3, "Table Cell Plugin for Column #" + sPosition + ":" + s + "\n  " + Debug.getStackTrace(true, true)));
    }

    @Override
    public boolean refresh() {
        return this.refresh(true);
    }

    @Override
    public boolean refresh(boolean bDoGraphics) {
        boolean isRowShown;
        if (this.tableRowSWT != null) {
            TableView view = this.tableRowSWT.getView();
            isRowShown = view.isRowVisible(this.tableRowSWT);
        } else {
            isRowShown = true;
        }
        boolean isCellShown = isRowShown && this.isShown();
        return this.refresh(bDoGraphics, isRowShown, isCellShown);
    }

    @Override
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible) {
        boolean isCellShown = bRowVisible && this.isShown();
        return this.refresh(bDoGraphics, bRowVisible, isCellShown);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible, boolean bCellVisible) {
        tc = this.tableColumnCore;
        if (tc == null) {
            return false;
        }
        ret = this.getVisuallyChangedSinceRefresh();
        iErrCount = 0;
        if (this.refreshErrLoopCount > 2) {
            return ret;
        }
        iErrCount = tc.getConsecutiveErrCount();
        if (iErrCount > 10) {
            this.refreshErrLoopCount = (byte)3;
            return ret;
        }
        if (this.bInRefresh) {
            if (this.bDebug) {
                this.debug("Calling Refresh from Refresh :) Skipping.");
            }
            return ret;
        }
        try {
            block38: {
                this.bInRefresh = true;
                if (!ret) ** GOTO lbl32
                now = SystemTime.getCurrentTime();
                if (now - this.lastRefresh >= (long)TableCellSWTBase.MAX_REFRESHES_WITHIN_MS) break block38;
                ++this.numFastRefreshes;
                if (this.numFastRefreshes >= TableCellSWTBase.MAX_REFRESHES) {
                    if (this.numFastRefreshes % TableCellSWTBase.MAX_REFRESHES == 0) {
                        this.pluginError("this plugin is crazy. tried to refresh " + this.numFastRefreshes + " times in " + (now - this.lastRefresh) + "ms");
                    }
                    var14_10 = ret;
                    return var14_10;
                }
                ** GOTO lbl32
            }
            try {
                this.numFastRefreshes = 0;
                this.lastRefresh = now;
lbl32:
                // 3 sources

                if (bCellVisible && !this.isUpToDate()) {
                    if (this.bDebug) {
                        this.debug("Setting Invalid because visible & not up to date");
                    }
                    this.clearFlag(1);
                    this.setFlag(8);
                } else if (!bCellVisible && this.isUpToDate()) {
                    if (this.bDebug) {
                        this.debug("Setting not up to date because cell not visible " + Debug.getCompressedStackTrace());
                    }
                    this.clearFlag(8);
                }
                if (this.bDebug) {
                    this.debug("Cell Valid?" + this.hasFlag(1) + "; Visible?" + this.tableRowSWT.isVisible() + "/" + this.isShown());
                }
                if ((iInterval = tc.getRefreshInterval()) == -3 && !this.hasFlag(33) && this.hasFlag(2) && this.sortValue != null && tc.getType() == 3) {
                    if (bCellVisible) {
                        if (this.bDebug) {
                            this.debug("fast refresh: setText");
                        }
                        ret = this.setText((String)this.sortValue);
                        this.setFlag(1);
                    }
                } else if (iInterval == -2 || iInterval == -1 && bDoGraphics != false || iInterval > 0 && this.loopFactor % iInterval == 0 || this.hasFlag(1) == false || this.hasFlag(32)) {
                    bWasValid = this.isValid();
                    ret = this.hasFlag(32);
                    if (ret) {
                        this.clearFlag(32);
                    }
                    if (this.bDebug) {
                        this.debug("invoke refresh; wasValid? " + bWasValid);
                    }
                    lTimeStart = Constants.isCVSVersion() != false ? SystemTime.getMonotonousTime() : 0L;
                    tc.invokeCellRefreshListeners(this, bCellVisible == false);
                    if (this.refreshListeners != null) {
                        for (TableCellRefreshListener l : this.refreshListeners) {
                            if (l instanceof TableCellLightRefreshListener) {
                                ((TableCellLightRefreshListener)l).refresh(this, bCellVisible == false);
                                continue;
                            }
                            l.refresh(this);
                        }
                    }
                    if (Constants.isCVSVersion()) {
                        lTimeEnd = SystemTime.getMonotonousTime();
                        tc.addRefreshTime(lTimeEnd - lTimeStart);
                    }
                    if (!bWasValid && !this.hasFlag(32)) {
                        this.setFlag(1);
                    }
                } else if (bCellVisible && this.bDebug) {
                    this.debug("Skipped refresh; Interval=" + iInterval);
                }
                this.loopFactor = (byte)(this.loopFactor + 1);
                this.refreshErrLoopCount = 0;
                if (iErrCount > 0) {
                    tc.setConsecutiveErrCount(0);
                }
                ret |= this.getVisuallyChangedSinceRefresh();
                if (this.bDebug) {
                    this.debug("refresh done; visual change? " + ret + ";" + Debug.getCompressedStackTrace());
                }
            }
            catch (Throwable e) {
                this.refreshErrLoopCount = (byte)(this.refreshErrLoopCount + 1);
                if (tc != null) {
                    tc.setConsecutiveErrCount(++iErrCount);
                }
                this.pluginError(e);
                if (this.refreshErrLoopCount > 2) {
                    Logger.log(new LogEvent(TableCellSWTBase.LOGID, 3, "TableCell will not be refreshed anymore this session."));
                }
            }
        }
        finally {
            this.bInRefresh = false;
        }
        return ret;
    }

    @Override
    public boolean setSortValue(Comparable valueToSort) {
        if (this.tableColumnCore == null) {
            return false;
        }
        if (!(this.tableColumnCore.isSortValueLive() || valueToSort instanceof Number || valueToSort instanceof String || valueToSort instanceof TableColumnSortObject)) {
            this.tableColumnCore.setSortValueLive(true);
        }
        return this._setSortValue(valueToSort);
    }

    private boolean _setSortValue(Comparable valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (this.hasFlag(2)) {
            this.clearFlag(2);
            if (this.sortValue instanceof String) {
                this.setText((String)((Object)this.sortValue));
            }
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (valueToSort instanceof Number && this.sortValue instanceof Number && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (this.bDebug) {
            this.debug("Setting SortValue to " + (valueToSort == null ? "null" : valueToSort.getClass().getName()));
        }
        this.tableColumnCore.setLastSortValueChange(SystemTime.getCurrentTime());
        this.sortValue = valueToSort;
        if (this.cellSWTPaintListeners != null || this.tableColumnCore.hasCellOtherListeners("SWTPaint")) {
            this.setFlag(64);
        }
        return true;
    }

    @Override
    public boolean setSortValue(long valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(Long.valueOf(valueToSort));
    }

    @Override
    public boolean setSortValue(float valueToSort) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        return this._setSortValue(new Float(valueToSort));
    }

    @Override
    public Comparable getSortValue() {
        return this.sortValue;
    }

    @Override
    public String getTextEquivalent() {
        return this.textEquiv;
    }

    @Override
    public void setTextEquivalent(String str) {
        this.textEquiv = str;
    }

    @Override
    public double getNumeric() {
        return this.numericValue;
    }

    @Override
    public void setNumeric(double d) {
        this.numericValue = d;
    }

    @Override
    public boolean isValid() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDisposed() {
        return (this.flags & 0x10) != 0;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    @Override
    public void invalidate() {
        if (this.isDisposed()) {
            return;
        }
        this.invalidate(true);
    }

    @Override
    public void invalidate(boolean bMustRefresh) {
        if ((this.flags & 0x41) == 64) {
            if (bMustRefresh) {
                if ((this.flags & 0x20) != 0) {
                    return;
                }
            } else {
                return;
            }
        }
        this.clearFlag(1);
        if (this.bDebug) {
            this.debug("Invalidate Cell;" + bMustRefresh);
        }
        if (bMustRefresh) {
            this.setFlag(96);
        } else {
            this.setFlag(64);
        }
    }

    @Override
    public void refreshAsync() {
        if (this.bInRefreshAsync) {
            if (this.restartRefresh < 127) {
                this.restartRefresh = (byte)(this.restartRefresh + 1);
            }
            return;
        }
        this.bInRefreshAsync = true;
        AERunnable runnable = new AERunnable(){

            @Override
            public void runSupport() {
                TableCellSWTBase.this.restartRefresh = (byte)0;
                TableCellSWTBase.this.refresh(true);
                TableCellSWTBase.this.bInRefreshAsync = false;
                if (TableCellSWTBase.this.restartRefresh > 0) {
                    TableCellSWTBase.this.refreshAsync();
                }
            }
        };
        Utils.execSWTThreadLater(25, runnable);
    }

    @Override
    public void setUpToDate(boolean upToDate) {
        if (this.bDebug) {
            this.debug("set up to date to " + upToDate);
        }
        if (upToDate) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
    }

    @Override
    public boolean isUpToDate() {
        return this.hasFlag(8);
    }

    @Override
    public boolean getVisuallyChangedSinceRefresh() {
        return this.hasFlag(64);
    }

    public void clearVisuallyChangedSinceRefresh() {
        this.clearFlag(64);
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellSWTBase)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException classCastException) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    @Override
    public boolean needsPainting() {
        if (this.isDisposed()) {
            return false;
        }
        if (this.cellSWTPaintListeners != null || this.tableColumnCore.hasCellOtherListeners("SWTPaint")) {
            return true;
        }
        return this.getGraphic() != null;
    }

    @Override
    public boolean setText(String text) {
        boolean do_auto;
        if (this.isDisposed()) {
            return false;
        }
        if (text == null) {
            text = "";
        }
        boolean bChanged = false;
        if (this.hasFlag(2) && !text.equals(this.sortValue)) {
            bChanged = true;
            this.sortValue = text;
            this.tableColumnCore.setLastSortValueChange(SystemTime.getCurrentTime());
            if (this.bDebug) {
                this.debug("Setting SortValue to text;");
            }
        }
        if (this.uiSetText(text) && !this.hasFlag(2)) {
            bChanged = true;
        }
        if (this.bDebug) {
            this.debug("setText (" + bChanged + ") : " + text);
        }
        if (bChanged) {
            this.setFlag(64);
        }
        boolean bl = do_auto = this.tableColumnCore == null ? false : this.tableColumnCore.doesAutoTooltip();
        if (!do_auto) {
            if (this.hasFlag(4)) {
                this.oToolTip = null;
                this.clearFlag(4);
            }
        } else {
            this.oToolTip = text;
            this.setFlag(4);
        }
        return bChanged;
    }

    @Override
    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
        if (tooltip == null) {
            this.setFlag(4);
        } else {
            this.clearFlag(4);
        }
    }

    @Override
    public Object getToolTip() {
        return TableTooltips.tooltips_disabled && !this.tableColumnCore.doesAutoTooltip() ? null : this.oToolTip;
    }

    @Override
    public Object getDefaultToolTip() {
        return TableTooltips.tooltips_disabled && !this.tableColumnCore.doesAutoTooltip() ? null : this.defaultToolTip;
    }

    @Override
    public void setDefaultToolTip(Object tt) {
        this.defaultToolTip = tt;
    }

    public abstract boolean uiSetText(String var1);

    @Override
    public void doPaint(GC gc) {
        if (this.bDebug) {
            this.debug("doPaint up2date:" + this.hasFlag(8) + ";v:" + this.hasFlag(1) + ";rl=" + this.refreshListeners);
        }
        this.invokeSWTPaintListeners(gc);
    }

    @Override
    public int getTextAlpha() {
        return this.textAlpha;
    }

    @Override
    public void setTextAlpha(int textOpacity) {
        this.textAlpha = textOpacity;
    }

    @Override
    public TableRowSWT getTableRowSWT() {
        if (this.tableRowSWT instanceof TableRowSWT) {
            return this.tableRowSWT;
        }
        return null;
    }

    @Override
    public TableRowCore getTableRowCore() {
        return this.tableRowSWT;
    }

    public TableColumnSWT getTableColumnSWT() {
        return this.tableColumnSWT;
    }

    private String flagToText(int flag, boolean onlySet) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)((flag & 0x10) > 0 ? 68 : (onlySet ? 32 : 100)));
        sb.append((char)((flag & 0x20) > 0 ? 77 : (onlySet ? 32 : 109)));
        sb.append((char)((flag & 2) > 0 ? 83 : (onlySet ? 32 : 115)));
        sb.append((char)((flag & 4) > 0 ? 84 : (onlySet ? 32 : 116)));
        sb.append((char)((flag & 8) > 0 ? 85 : (onlySet ? 32 : 117)));
        sb.append((char)((flag & 1) > 0 ? 86 : (onlySet ? 32 : 118)));
        sb.append((flag & 0x40) > 0 ? "VC" : (onlySet ? " " : "vc"));
        return sb.toString();
    }

    public abstract int getWidthRaw();

    @Override
    public void setFillCell(boolean doFillCell) {
        this.doFillCell = doFillCell;
    }

    public boolean getFillCell() {
        return this.doFillCell;
    }

    @Override
    public TableColumnCore getTableColumnCore() {
        return this.tableColumnCore;
    }

    @Override
    public boolean setCursorID(int cursorID) {
        if (this.iCursorID == cursorID) {
            return false;
        }
        this.iCursorID = cursorID;
        return true;
    }

    @Override
    public int getCursorID() {
        return this.iCursorID;
    }

    @Override
    public void setMouseOver(boolean b) {
        this.mouseOver = b;
    }

    @Override
    public boolean isMouseOver() {
        if (this.tableRowSWT != null && !this.tableRowSWT.isVisible()) {
            return false;
        }
        return this.mouseOver;
    }

    @Override
    public boolean setIcon(Image img) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        this.icon = img;
        this.graphic = null;
        this.setFlag(64);
        return true;
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public boolean setGraphic(Image img) {
        return this.setGraphic(new UISWTGraphicImpl(img));
    }

    @Override
    public boolean setGraphic(Graphic img) {
        if (img != null && this.isDisposed()) {
            return false;
        }
        if (this.tableColumnCore == null || this.tableColumnCore.getType() != 2) {
            return false;
        }
        if (img == this.graphic && this.numFastRefreshes >= MAX_REFRESHES) {
            this.pluginError("TableCellImpl::setGraphic to same Graphic object. Forcing refresh.");
        }
        boolean changed = img == this.graphic || img != null && !img.equals(this.graphic) || this.graphic != null && !this.graphic.equals(img);
        this.graphic = img;
        if (changed) {
            this.setFlag(64);
            if ((this.tableRowSWT == null || this.tableRowSWT.isVisible()) && !this.tableRowSWT.isInPaintItem()) {
                this.redraw();
            }
        }
        return changed;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public Image getGraphicSWT() {
        return this.graphic instanceof UISWTGraphic ? ((UISWTGraphic)this.graphic).getImage() : null;
    }

    public boolean isInvisibleAndCanRefresh() {
        return !this.isDisposed() && !this.isShown() && (this.refreshListeners != null || this.tableColumnCore.hasCellRefreshListener());
    }

    @Override
    public int[] getBackground() {
        Color color = this.getBackgroundSWT();
        if (color == null) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    public int[] getForeground() {
        Color color = this.getForegroundSWT();
        if (color == null) {
            return new int[3];
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    public boolean setForeground(int red, int green, int blue) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        if (red < 0 || green < 0 || blue < 0) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(new RGB(red, green, blue));
    }

    private boolean setForeground(final RGB rgb) {
        boolean changed;
        Color colorFG = this.getForegroundSWT();
        boolean bl = changed = colorFG == null || colorFG.isDisposed() || !colorFG.getRGB().equals((Object)rgb);
        if (changed) {
            Utils.execSWTThread(new SWTRunnable(){

                @Override
                public void runWithDisplay(Display display) {
                    TableCellSWTBase.this.setForeground(ColorCache.getColor((Device)Display.getCurrent(), rgb));
                }
            });
        }
        return changed;
    }

    @Override
    public boolean setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public boolean setForegroundToErrorColor() {
        return this.setForeground(Colors.colorError);
    }

    @Override
    public int[] getMouseOffset() {
        int[] nArray;
        Point ofs = this.tableRowSWT.getView().getTableCellMouseOffset(this);
        if (ofs == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = ofs.x;
            nArray = nArray2;
            nArray2[1] = ofs.y;
        }
        return nArray;
    }

    @Override
    public String getObfuscatedText() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.tableColumnCore.isObfuscated()) {
            if (this.tableColumnCore instanceof ObfuscateCellText) {
                return ((ObfuscateCellText)((Object)this.tableColumnCore)).getObfuscatedText(this);
            }
            return "";
        }
        return null;
    }

    @Override
    public boolean useSimpleSortValue() {
        if (this.tableRowSWT == null) {
            return false;
        }
        TableView view = this.tableRowSWT.getView();
        if (view == null) {
            return false;
        }
        return view.getSortColumnCount() > 1 && view.hasSortColumn(this.tableColumnCore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(Object key) {
        TableCellSWTBase tableCellSWTBase = this;
        synchronized (tableCellSWTBase) {
            block4: {
                if (this.userData != null) break block4;
                return null;
            }
            return this.userData.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(Object key, Object data) {
        TableCellSWTBase tableCellSWTBase = this;
        synchronized (tableCellSWTBase) {
            if (this.userData == null) {
                if (data == null) {
                    return;
                }
                this.userData = new HashMap<Object, Object>();
            }
            if (data == null) {
                this.userData.remove(key);
                if (this.userData.isEmpty()) {
                    this.userData = null;
                }
            } else {
                this.userData.put(key, data);
            }
        }
    }
}

