/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.dht.DHT;
import com.biglybt.core.dht.DHTStorageAdapter;
import com.biglybt.core.dht.control.DHTControlActivity;
import com.biglybt.core.dht.control.DHTControlListener;
import com.biglybt.core.dht.control.DHTControlStats;
import com.biglybt.core.dht.db.DHTDBStats;
import com.biglybt.core.dht.nat.DHTNATPuncher;
import com.biglybt.core.dht.router.DHTRouterStats;
import com.biglybt.core.dht.transport.DHTTransport;
import com.biglybt.core.dht.transport.DHTTransportFullStats;
import com.biglybt.core.dht.transport.DHTTransportStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.plugin.dht.DHTPlugin;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.PingGraphic;
import com.biglybt.ui.swt.components.graphics.SpeedGraphic;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.views.IViewRequiresPeriodicUpdates;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class DHTView
implements UISWTViewEventListener,
IViewRequiresPeriodicUpdates {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    public static final int DHT_TYPE_BIGLYBT = 4;
    public static final String MSGID_PREFIX = "DHTView";
    public static Color[] rttColours = new Color[]{Colors.grey, Colors.fadedGreen, Colors.fadedRed};
    private static Map<String, int[]> table_col_map = new HashMap<String, int[]>();
    private boolean auto_dht;
    DHT dht;
    Composite panel;
    String yes_str;
    String no_str;
    Label lblUpTime;
    Label lblNumberOfUsers;
    Label lblNodes;
    Label lblLeaves;
    Label lblContacts;
    Label lblReplacements;
    Label lblLive;
    Label lblUnknown;
    Label lblDying;
    Label lblSkew;
    Label lblRendezvous;
    Label lblReachable;
    Label lblKeys;
    Label lblValues;
    Label lblSize;
    Label lblLocal;
    Label lblDirect;
    Label lblIndirect;
    Label lblDivFreq;
    Label lblDivSize;
    BufferedLabel lblTransportAddress;
    Label lblReceivedPackets;
    Label lblReceivedBytes;
    Label lblSentPackets;
    Label lblSentBytes;
    Label[] lblPings = new Label[4];
    Label[] lblFindNodes = new Label[4];
    Label[] lblFindValues = new Label[4];
    Label[] lblStores = new Label[4];
    Label[] lblData = new Label[4];
    Canvas in;
    Canvas out;
    Canvas rtt;
    SpeedGraphic inGraph;
    SpeedGraphic outGraph;
    PingGraphic rttGraph;
    boolean activityChanged;
    DHTControlListener controlListener;
    Table activityTable;
    DHTControlActivity[] activities;
    private String id;
    private int dht_type;
    protected Core core;
    private int refreshIter = 0;
    private UISWTView swtView;

    public DHTView() {
        this(true);
    }

    public DHTView(boolean _auto_dht) {
        this.auto_dht = _auto_dht;
        this.inGraph = SpeedGraphic.getInstance();
        this.outGraph = SpeedGraphic.getInstance();
        this.rttGraph = PingGraphic.getInstance();
        this.rttGraph.setColors(rttColours);
        this.rttGraph.setExternalAverage(true);
    }

    private void init(Core core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            int i = 0;
            while (i < dhts.length) {
                if (dhts[i].getTransport().getNetwork() == this.dht_type) {
                    this.dht = dhts[i];
                    break;
                }
                ++i;
            }
            if (this.dht == null) {
                return;
            }
            this.controlListener = new DHTControlListener(){

                @Override
                public void activityChanged(DHTControlActivity activity, int type) {
                    DHTView.this.activityChanged = true;
                }
            };
            this.dht.getControl().addListener(this.controlListener);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void setDHT(DHT _dht) {
        if (this.dht == null) {
            this.dht = _dht;
            this.controlListener = new DHTControlListener(){

                @Override
                public void activityChanged(DHTControlActivity activity, int type) {
                    DHTView.this.activityChanged = true;
                }
            };
            this.dht.getControl().addListener(this.controlListener);
        } else if (this.dht != _dht) {
            Debug.out("Not Supported ");
        }
    }

    public void initialize(Composite composite) {
        if (this.auto_dht) {
            CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    DHTView.this.core = core;
                    DHTView.this.init(core);
                }
            });
        }
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.panel.setLayout((Layout)layout);
        this.yes_str = MessageText.getString("Button.yes").replaceAll("&", "");
        this.no_str = MessageText.getString("Button.no").replaceAll("&", "");
        this.initialiseGeneralGroup();
        this.initialiseDBGroup();
        this.initialiseTransportDetailsGroup();
        this.initialiseOperationDetailsGroup();
        this.initialiseActivityGroup();
    }

    private void initialiseGeneralGroup() {
        Group gGeneral = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gGeneral, "DHTView.general.title");
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.widthHint = 360;
        gGeneral.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        gGeneral.setLayout((Layout)layout);
        Label label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.uptime");
        this.lblUpTime = new Label((Composite)gGeneral, 0);
        this.lblUpTime.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.users");
        this.lblNumberOfUsers = new Label((Composite)gGeneral, 0);
        this.lblNumberOfUsers.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.reachable");
        this.lblReachable = new Label((Composite)gGeneral, 0);
        this.lblReachable.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.nodes");
        this.lblNodes = new Label((Composite)gGeneral, 0);
        this.lblNodes.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.leaves");
        this.lblLeaves = new Label((Composite)gGeneral, 0);
        this.lblLeaves.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.rendezvous");
        this.lblRendezvous = new Label((Composite)gGeneral, 0);
        this.lblRendezvous.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.contacts");
        this.lblContacts = new Label((Composite)gGeneral, 0);
        this.lblContacts.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.replacements");
        this.lblReplacements = new Label((Composite)gGeneral, 0);
        this.lblReplacements.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.live");
        this.lblLive = new Label((Composite)gGeneral, 0);
        this.lblLive.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.skew");
        this.lblSkew = new Label((Composite)gGeneral, 0);
        this.lblSkew.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.unknown");
        this.lblUnknown = new Label((Composite)gGeneral, 0);
        this.lblUnknown.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.dying");
        this.lblDying = new Label((Composite)gGeneral, 0);
        this.lblDying.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void initialiseDBGroup() {
        Group gDB = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gDB, "DHTView.db.title");
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        gDB.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        gDB.setLayout((Layout)layout);
        Label label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.keys");
        this.lblKeys = new Label((Composite)gDB, 0);
        this.lblKeys.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.values");
        this.lblValues = new Label((Composite)gDB, 0);
        this.lblValues.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "TableColumn.header.size");
        this.lblSize = new Label((Composite)gDB, 0);
        this.lblSize.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.local");
        this.lblLocal = new Label((Composite)gDB, 0);
        this.lblLocal.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.direct");
        this.lblDirect = new Label((Composite)gDB, 0);
        this.lblDirect.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.indirect");
        this.lblIndirect = new Label((Composite)gDB, 0);
        this.lblIndirect.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.divfreq");
        this.lblDivFreq = new Label((Composite)gDB, 0);
        this.lblDivFreq.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.divsize");
        this.lblDivSize = new Label((Composite)gDB, 0);
        this.lblDivSize.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void initialiseTransportDetailsGroup() {
        Group gTransport = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gTransport, "DHTView.transport.title");
        GridData data = new GridData(1040);
        data.widthHint = 360;
        data.verticalSpan = 2;
        gTransport.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        gTransport.setLayout((Layout)layout);
        this.lblTransportAddress = new BufferedLabel((Composite)gTransport, 0x20000000);
        data = new GridData(4, 128, true, false);
        data.horizontalSpan = 3;
        this.lblTransportAddress.setLayoutData(data);
        Label label = new Label((Composite)gTransport, 0);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.packets");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.bytes");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.received");
        this.lblReceivedPackets = new Label((Composite)gTransport, 0);
        this.lblReceivedPackets.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblReceivedBytes = new Label((Composite)gTransport, 0);
        this.lblReceivedBytes.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.sent");
        this.lblSentPackets = new Label((Composite)gTransport, 0);
        this.lblSentPackets.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblSentBytes = new Label((Composite)gTransport, 0);
        this.lblSentBytes.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.in");
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.in = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.in.setLayoutData((Object)data);
        this.inGraph.initialize(this.in);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.out");
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.out = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.out.setLayoutData((Object)data);
        this.outGraph.initialize(this.out);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.rtt");
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.rtt = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.rtt.setLayoutData((Object)data);
        this.rttGraph.initialize(this.rtt);
        data = new GridData(768);
        data.horizontalSpan = 3;
        Legend.createLegendComposite((Composite)gTransport, rttColours, new String[]{"DHTView.rtt.legend.average", "DHTView.rtt.legend.best", "DHTView.rtt.legend.worst"}, data);
    }

    private void initialiseOperationDetailsGroup() {
        Group gOperations = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gOperations, "DHTView.operations.title");
        gOperations.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        gOperations.setLayout((Layout)layout);
        Label label = new Label((Composite)gOperations, 0);
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.sent");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.ok");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.failed");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.received");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.ping");
        int i = 0;
        while (i < 4) {
            this.lblPings[i] = new Label((Composite)gOperations, 0);
            this.lblPings[i].setLayoutData((Object)new GridData(4, 128, true, false));
            ++i;
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.findNode");
        i = 0;
        while (i < 4) {
            this.lblFindNodes[i] = new Label((Composite)gOperations, 0);
            this.lblFindNodes[i].setLayoutData((Object)new GridData(4, 128, true, false));
            ++i;
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.findValue");
        i = 0;
        while (i < 4) {
            this.lblFindValues[i] = new Label((Composite)gOperations, 0);
            this.lblFindValues[i].setLayoutData((Object)new GridData(4, 128, true, false));
            ++i;
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.store");
        i = 0;
        while (i < 4) {
            this.lblStores[i] = new Label((Composite)gOperations, 0);
            this.lblStores[i].setLayoutData((Object)new GridData(4, 128, true, false));
            ++i;
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.data");
        i = 0;
        while (i < 4) {
            this.lblData[i] = new Label((Composite)gOperations, 0);
            this.lblData[i].setLayoutData((Object)new GridData(4, 128, true, false));
            ++i;
        }
    }

    private void initialiseActivityGroup() {
        int[] widths;
        Group gActivity = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gActivity, "DHTView.activity.title");
        gActivity.setLayoutData((Object)new GridData(4, 4, true, true));
        gActivity.setLayout((Layout)new GridLayout());
        this.activityTable = new Table((Composite)gActivity, 268503044);
        this.activityTable.setLayoutData((Object)new GridData(1808));
        TableColumn colStatus = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colStatus, "DHTView.activity.status");
        TableColumn colType = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colType, "DHTView.activity.type");
        TableColumn colName = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colName, "DHTView.activity.target");
        TableColumn colDetails = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colDetails, "label.details");
        colDetails.setResizable(false);
        final TableColumn[] columns = new TableColumn[]{colStatus, colType, colName, colDetails};
        int[] col_widths = new int[]{80, 80, 80, 300};
        if (this.id != null && (widths = table_col_map.get(this.id)) != null) {
            col_widths = widths;
        }
        int i = 0;
        while (i < columns.length) {
            columns[i].setWidth(col_widths[i]);
            ++i;
        }
        this.activityTable.setHeaderVisible(true);
        Listener computeLastRowWidthListener = new Listener(){
            boolean inUse = false;

            public void handleEvent(Event event2) {
                if (this.inUse) {
                    return;
                }
                this.inUse = true;
                try {
                    if (DHTView.this.activityTable == null || DHTView.this.activityTable.isDisposed()) {
                        return;
                    }
                    int totalWidth = DHTView.this.activityTable.getClientArea().width;
                    int[] widths = new int[columns.length];
                    int remainingWidth = totalWidth;
                    int i = 0;
                    while (i < widths.length - 1) {
                        widths[i] = columns[i].getWidth();
                        remainingWidth -= widths[i];
                        ++i;
                    }
                    TableColumn lastCol = columns[columns.length - 1];
                    if (remainingWidth > 0) {
                        lastCol.setWidth(remainingWidth);
                    }
                    widths[columns.length - 1] = lastCol.getWidth();
                    if (DHTView.this.id != null) {
                        table_col_map.put(DHTView.this.id, widths);
                    }
                }
                finally {
                    this.inUse = false;
                }
            }
        };
        this.activityTable.addListener(11, computeLastRowWidthListener);
        colStatus.addListener(11, computeLastRowWidthListener);
        colType.addListener(11, computeLastRowWidthListener);
        colName.addListener(11, computeLastRowWidthListener);
        this.activityTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = DHTView.this.activityTable.indexOf(item);
                item.setText(0, MessageText.getString("DHTView.activity.status." + DHTView.this.activities[index].isQueued()));
                item.setText(1, MessageText.getString("DHTView.activity.type." + DHTView.this.activities[index].getType()));
                item.setText(2, ByteFormatter.nicePrint(DHTView.this.activities[index].getTarget()));
                item.setText(3, DHTView.this.activities[index].getDescription());
            }
        });
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        if (this.dht != null) {
            this.dht.getControl().removeListener(this.controlListener);
        }
        this.outGraph.dispose();
        this.inGraph.dispose();
        this.rttGraph.dispose();
    }

    private String getTitleID() {
        if (this.dht_type == 0) {
            return "DHTView.title.full";
        }
        if (this.dht_type == 1) {
            return "DHTView.title.fullcvs";
        }
        if (this.dht_type == 4) {
            return "DHTView.title.biglybt";
        }
        return "DHTView.title.full_v6";
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        if (this.panel == null || this.panel.isDisposed()) {
            return;
        }
        this.inGraph.refresh(false);
        this.outGraph.refresh(false);
        this.rttGraph.refresh();
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            }
            return;
        }
        this.refreshGeneral();
        this.refreshDB();
        this.refreshTransportDetails();
        this.refreshOperationDetails();
        this.refreshActivity();
    }

    private void refreshGeneral() {
        DHTControlStats controlStats = this.dht.getControl().getStats();
        DHTRouterStats routerStats = this.dht.getRouter().getStats();
        DHTTransport transport = this.dht.getTransport();
        DHTTransportStats transportStats = transport.getStats();
        this.lblUpTime.setText(TimeFormatter.format(controlStats.getRouterUptime() / 1000L));
        this.lblNumberOfUsers.setText("" + controlStats.getEstimatedDHTSize());
        int percent = transportStats.getRouteablePercentage();
        this.lblReachable.setText(String.valueOf(transport.isReachable() ? this.yes_str : this.no_str) + (percent == -1 ? "" : " " + percent + "%"));
        DHTNATPuncher puncher = this.dht.getNATPuncher();
        String puncher_str = puncher == null ? "" : (puncher.operational() ? this.yes_str : this.no_str);
        this.lblRendezvous.setText(transport.isReachable() ? "" : puncher_str);
        long[] stats2 = routerStats.getStats();
        this.lblNodes.setText("" + stats2[0]);
        this.lblLeaves.setText("" + stats2[1]);
        this.lblContacts.setText("" + stats2[2]);
        this.lblReplacements.setText("" + stats2[3]);
        this.lblLive.setText("" + stats2[4]);
        this.lblUnknown.setText("" + stats2[5]);
        this.lblDying.setText("" + stats2[6]);
        long skew_average = transportStats.getSkewAverage();
        this.lblSkew.setText(skew_average == 0L ? "" : String.valueOf(skew_average < 0L ? "-" : "") + TimeFormatter.format100ths(Math.abs(skew_average)));
    }

    private void refreshDB() {
        if (this.refreshIter == 0) {
            String rem_size;
            String rem_freq;
            DHTDBStats dbStats = this.dht.getDataBase().getStats();
            this.lblKeys.setText(dbStats.getKeyCount() + " (" + dbStats.getLocalKeyCount() + ")");
            int[] stats2 = dbStats.getValueDetails();
            this.lblValues.setText("" + stats2[0]);
            this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(dbStats.getSize()));
            this.lblDirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[2]));
            this.lblIndirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[3]));
            this.lblLocal.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[1]));
            DHTStorageAdapter sa = this.dht.getStorageAdapter();
            if (sa == null) {
                rem_freq = "-";
                rem_size = "-";
            } else {
                rem_freq = "" + sa.getRemoteFreqDivCount();
                rem_size = "" + sa.getRemoteSizeDivCount();
            }
            this.lblDivFreq.setText(stats2[4] + " (" + rem_freq + ")");
            this.lblDivSize.setText(stats2[5] + " (" + rem_size + ")");
        } else {
            ++this.refreshIter;
            if (this.refreshIter == 100) {
                this.refreshIter = 0;
            }
        }
    }

    private void refreshTransportDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        this.lblTransportAddress.setText(AddressUtils.getHostAddress(this.dht.getTransport().getLocalContact().getExternalAddress()));
        this.lblReceivedBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesReceived()));
        this.lblSentBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesSent()));
        this.lblReceivedPackets.setText("" + transportStats.getPacketsReceived());
        this.lblSentPackets.setText("" + transportStats.getPacketsSent());
    }

    private void refreshOperationDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        long[] pings = transportStats.getPings();
        int i = 0;
        while (i < 4) {
            this.lblPings[i].setText("" + pings[i]);
            ++i;
        }
        long[] findNodes = transportStats.getFindNodes();
        int i2 = 0;
        while (i2 < 4) {
            this.lblFindNodes[i2].setText("" + findNodes[i2]);
            ++i2;
        }
        long[] findValues = transportStats.getFindValues();
        int i3 = 0;
        while (i3 < 4) {
            this.lblFindValues[i3].setText("" + findValues[i3]);
            ++i3;
        }
        long[] stores = transportStats.getStores();
        long[] qstores = transportStats.getQueryStores();
        int i4 = 0;
        while (i4 < 4) {
            this.lblStores[i4].setText(stores[i4] + " (" + qstores[i4] + ")");
            ++i4;
        }
        long[] data = transportStats.getData();
        int i5 = 0;
        while (i5 < 4) {
            this.lblData[i5].setText("" + data[i5]);
            ++i5;
        }
    }

    private void refreshActivity() {
        if (this.activityChanged) {
            this.activityChanged = false;
            this.activities = this.dht.getControl().getActivities();
            this.activityTable.setItemCount(this.activities.length);
            this.activityTable.clearAll();
            this.activityTable.redraw();
        }
    }

    public void periodicUpdate() {
        if (this.dht == null) {
            return;
        }
        DHTTransportFullStats fullStats = this.dht.getTransport().getLocalContact().getStats();
        if (fullStats != null) {
            this.inGraph.addIntValue((int)fullStats.getAverageBytesReceived());
            this.outGraph.addIntValue((int)fullStats.getAverageBytesSent());
        }
        DHTTransportStats stats2 = this.dht.getTransport().getStats();
        int[] rtts = (int[])stats2.getRTTHistory().clone();
        Arrays.sort(rtts);
        int rtt_total = 0;
        int rtt_num = 0;
        int start = 0;
        int[] nArray = rtts;
        int n = rtts.length;
        int n2 = 0;
        while (n2 < n) {
            int rtt = nArray[n2];
            if (rtt > 0) {
                rtt_total += rtt;
                ++rtt_num;
            } else {
                ++start;
            }
            ++n2;
        }
        int average = 0;
        int best = 0;
        int worst = 0;
        if (rtt_num > 0) {
            average = rtt_total / rtt_num;
        }
        int chunk = rtt_num / 3;
        int max_best = start + chunk;
        int min_worst = rtts.length - 1 - chunk;
        int worst_total = 0;
        int worst_num = 0;
        int best_total = 0;
        int best_num = 0;
        int i = start;
        while (i < rtts.length) {
            if (i < max_best) {
                best_total += rtts[i];
                ++best_num;
            } else if (i > min_worst) {
                worst_total += rtts[i];
                ++worst_num;
            }
            ++i;
        }
        if (best_num > 0) {
            best = best_total / best_num;
        }
        if (worst_num > 0) {
            worst = worst_total / worst_num;
        }
        this.rttGraph.addIntsValue(new int[]{average, best, worst});
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                if (this.swtView.getInitialDataSource() instanceof Number) {
                    this.dht_type = ((Number)this.swtView.getInitialDataSource()).intValue();
                    this.id = String.valueOf(this.dht_type);
                }
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                if (!(event2.getData() instanceof Number)) break;
                this.dht_type = ((Number)event2.getData()).intValue();
                this.id = String.valueOf(this.dht_type);
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

