/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class BasePanel {
    static float def_minX = -1000.0f;
    static float def_maxX = 1000.0f;
    static float def_minY = -1000.0f;
    static float def_maxY = 1000.0f;
    static double def_rotation = 0.0;

    static class Scale
    implements Cloneable {
        private float width;
        private float height;
        private float minX;
        private float maxX;
        private float minY;
        private float maxY;
        private double rotation;
        private float saveMinX;
        private float saveMaxX;
        private float saveMinY;
        private float saveMaxY;
        private double saveRotation;
        boolean disableAutoScale = false;
        long lastAutoScale = 0L;
        boolean mouseLeftDown = false;
        boolean mouseRightDown = false;
        private int xDown;
        private int yDown;

        Scale() {
            this.reset();
        }

        public Scale clone() {
            try {
                Scale result = (Scale)super.clone();
                result.mouseLeftDown = false;
                result.mouseRightDown = false;
                return result;
            }
            catch (CloneNotSupportedException e) {
                return this;
            }
        }

        public void setSize(Rectangle size) {
            this.width = size.width;
            this.height = size.height;
        }

        public void setScale(float min_x, float max_x, float min_y, float max_y) {
            this.minX = min_x;
            this.maxX = max_x;
            this.minY = min_y;
            this.maxY = max_y;
        }

        public void setScaleAndRotation(float min_x, float max_x, float min_y, float max_y, double rot) {
            this.minX = min_x;
            this.maxX = max_x;
            this.minY = min_y;
            this.maxY = max_y;
            this.rotation = rot;
        }

        public float getMinX() {
            return this.minX;
        }

        public float getMaxX() {
            return this.maxX;
        }

        public float getMinY() {
            return this.minY;
        }

        public float getMaxY() {
            return this.maxY;
        }

        public void reset() {
            this.minX = def_minX;
            this.maxX = def_maxX;
            this.minY = def_minY;
            this.maxY = def_maxY;
            this.rotation = def_rotation;
            this.saveMinX = 0.0f;
            this.saveMaxX = 0.0f;
            this.saveMinY = 0.0f;
            this.saveMaxY = 0.0f;
            this.saveRotation = 0.0;
            this.disableAutoScale = false;
            this.lastAutoScale = 0L;
        }

        public int getX(float x, float y) {
            return (int)(((double)x * Math.cos(this.rotation) + (double)y * Math.sin(this.rotation) - (double)this.minX) / (double)(this.maxX - this.minX) * (double)this.width);
        }

        public int getY(float x, float y) {
            return (int)(((double)y * Math.cos(this.rotation) - (double)x * Math.sin(this.rotation) - (double)this.minY) / (double)(this.maxY - this.minY) * (double)this.height);
        }

        public int[] getXY(float x, float y) {
            return new int[]{this.getX(x, y), this.getY(x, y)};
        }

        public int getReverseWidth(float w) {
            return (int)(w / this.width * (this.maxX - this.minX));
        }

        public int getReverseHeight(float h) {
            return (int)(h / this.height * (this.maxY - this.minY));
        }

        public void mouseDown(MouseEvent event2) {
            if (event2.button == 1) {
                this.mouseLeftDown = true;
            }
            if (event2.button == 3) {
                this.mouseRightDown = true;
            }
            this.xDown = event2.x;
            this.yDown = event2.y;
            this.saveMinX = this.minX;
            this.saveMaxX = this.maxX;
            this.saveMinY = this.minY;
            this.saveMaxY = this.maxY;
            this.saveRotation = this.rotation;
        }

        public void mouseUp(MouseEvent event2) {
            if (event2.button == 1) {
                this.mouseLeftDown = false;
            }
            if (event2.button == 3) {
                this.mouseRightDown = false;
            }
        }

        public void mouseWheel(Event event2) {
            this.saveMinX = this.minX;
            this.saveMaxX = this.maxX;
            this.saveMinY = this.minY;
            this.saveMaxY = this.maxY;
            int deltaY = event2.count * -5;
            float scaleFactor = 1.0f - (float)deltaY / 300.0f;
            if (scaleFactor <= 0.0f) {
                scaleFactor = 0.01f;
            }
            float moveFactor = 1.0f - 1.0f / scaleFactor;
            Control control = (Control)event2.widget;
            Point controlSize = control.getSize();
            float mouseXpct = (float)(event2.x + 1) / (float)controlSize.x;
            float mouseYpct = (float)(event2.y + 1) / (float)controlSize.y;
            float xOfs = (mouseXpct - 0.5f) * (this.saveMaxX - this.saveMinX);
            float yOfs = (mouseYpct - 0.5f) * (this.saveMaxY - this.saveMinY);
            float centerX = (this.saveMinX + this.saveMaxX) / 2.0f + xOfs;
            this.minX = this.saveMinX + moveFactor * (centerX - this.saveMinX);
            this.maxX = this.saveMaxX - moveFactor * (this.saveMaxX - centerX);
            float centerY = (this.saveMinY + this.saveMaxY) / 2.0f + yOfs;
            this.minY = this.saveMinY + moveFactor * (centerY - this.saveMinY);
            this.maxY = this.saveMaxY - moveFactor * (this.saveMaxY - centerY);
            this.disableAutoScale = true;
        }

        public boolean mouseMove(MouseEvent event2) {
            if (this.mouseLeftDown && (event2.stateMask & SWT.MOD4) == 0) {
                int deltaX = event2.x - this.xDown;
                int deltaY = event2.y - this.yDown;
                float ratioX = (this.saveMaxX - this.saveMinX) / this.width;
                float ratioY = (this.saveMaxY - this.saveMinY) / this.height;
                float realDeltaX = (float)deltaX * ratioX;
                float realDeltaY = (float)deltaY * ratioY;
                this.minX = this.saveMinX - realDeltaX;
                this.maxX = this.saveMaxX - realDeltaX;
                this.minY = this.saveMinY - realDeltaY;
                this.maxY = this.saveMaxY - realDeltaY;
                this.disableAutoScale = true;
                return true;
            }
            if (this.mouseRightDown || this.mouseLeftDown && (event2.stateMask & SWT.MOD4) > 0) {
                int deltaX = event2.x - this.xDown;
                int deltaY = event2.y - this.yDown;
                int diffX = Math.abs(deltaX);
                int diffY = Math.abs(deltaY);
                if (diffY > diffX && diffX <= 3) {
                    deltaX = 0;
                }
                if (diffY > diffX && diffY <= 3) {
                    deltaY = 0;
                }
                this.rotation = this.saveRotation - (double)((float)deltaX / 100.0f);
                float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                if (scaleFactor <= 0.0f) {
                    scaleFactor = 0.01f;
                }
                float moveFactor = 1.0f - 1.0f / scaleFactor;
                Control control = (Control)event2.widget;
                Point controlSize = control.getSize();
                float mouseXpct = (float)(this.xDown + 1) / (float)controlSize.x;
                float mouseYpct = (float)(this.yDown + 1) / (float)controlSize.y;
                float xOfs = (mouseXpct - 0.5f) * (this.saveMaxX - this.saveMinX);
                float yOfs = (mouseYpct - 0.5f) * (this.saveMaxY - this.saveMinY);
                float centerX = (this.saveMinX + this.saveMaxX) / 2.0f + xOfs;
                this.minX = this.saveMinX + moveFactor * (centerX - this.saveMinX);
                this.maxX = this.saveMaxX - moveFactor * (this.saveMaxX - centerX);
                float centerY = (this.saveMinY + this.saveMaxY) / 2.0f + yOfs;
                this.minY = this.saveMinY + moveFactor * (centerY - this.saveMinY);
                this.maxY = this.saveMaxY - moveFactor * (this.saveMaxY - centerY);
                this.disableAutoScale = true;
                return true;
            }
            return false;
        }
    }
}

