/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.history.DownloadHistoryEvent;
import com.biglybt.core.history.DownloadHistoryListener;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableColumnCoreCreationListener;
import com.biglybt.ui.common.table.TableCountChangeListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryAddDate;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryCompleteDate;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryHash;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryName;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryRemoveDate;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistorySaveLocation;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistorySize;
import com.biglybt.ui.swt.columns.dlhistory.ColumnDLHistoryTags;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_DownloadHistoryView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<DownloadHistory>,
TableViewSWTMenuFillListener,
TableSelectionListener,
DownloadHistoryListener {
    private static final String TABLE_NAME = "DownloadHistory";
    private static final DownloadHistoryManager dh_manager = (DownloadHistoryManager)CoreFactory.getSingleton().getGlobalManager().getDownloadHistoryManager();
    private TableViewSWT<DownloadHistory> tv;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean dh_listener_added;
    private Object datasource;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_DownloadHistoryView> clazz = SBC_DownloadHistoryView.class;
        synchronized (SBC_DownloadHistoryView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryName(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryAddDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryAddDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryCompleteDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryCompleteDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryRemoveDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadHistory.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryRemoveDate(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryHash.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryHash(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistorySize.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistorySize(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistorySaveLocation.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistorySaveLocation(column);
                }
            });
            tableManager.registerColumn(DownloadHistory.class, ColumnDLHistoryTags.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnDLHistoryTags(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_NAME, new String[]{ColumnDLHistoryName.COLUMN_ID, ColumnDLHistoryAddDate.COLUMN_ID, ColumnDLHistoryCompleteDate.COLUMN_ID, ColumnDLHistoryRemoveDate.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_NAME, ColumnDLHistoryName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(this.table_parent);
        if (this.dh_listener_added) {
            dh_manager.removeListener(this);
            this.dh_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("dl-history-list");
        if (so_list == null) {
            System.out.println("NO dl-history-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        if (dh_manager != null) {
            dh_manager.addListener(this, true);
            this.dh_listener_added = true;
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.dh_listener_added) {
            dh_manager.removeListener(this);
            this.dh_listener_added = false;
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(DownloadHistory.class, TABLE_NAME, TABLE_NAME, new TableColumnCore[0], ColumnDLHistoryName.COLUMN_ID, 0x10010002);
            SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
            if (soFilter != null) {
                this.tv.enableFilterCheck(soFilter.getBubbleTextBox(), (TableViewFilterCheck<DownloadHistory>)this);
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.table_parent = Utils.createSkinnedComposite(control, 2048, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                @Override
                public void rowRemoved(TableRowCore row) {
                }

                @Override
                public void rowAdded(TableRowCore row) {
                    if (SBC_DownloadHistoryView.this.datasource == row.getDataSource()) {
                        SBC_DownloadHistoryView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
            if (dh_manager == null) {
                control.setEnabled(false);
            }
        }
        control.layout(true);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.tv == null || !this.tv.isVisible() || dh_manager == null) {
            return false;
        }
        List<Object> datasources = this.tv.getSelectedDataSources();
        if (datasources.size() > 0) {
            ArrayList<DownloadHistory> dms = new ArrayList<DownloadHistory>(datasources.size());
            for (Object o : datasources) {
                dms.add((DownloadHistory)o);
            }
            String id = item.getID();
            if (id.equals("remove")) {
                dh_manager.removeHistory(dms);
            } else if (id.equals("startstop")) {
                for (DownloadHistory download : dms) {
                    download.setRedownloading();
                    String magnet = UrlUtils.getMagnetURI(download.getTorrentHash(), download.getName(), null);
                    TorrentOpener.openTorrent(magnet);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible() || dh_manager == null) {
            return;
        }
        boolean canEnable = false;
        boolean canStart = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            canEnable = true;
            canStart = true;
        }
        list.put("remove", canEnable ? 1L : 0L);
        list.put("start", canStart ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_NAME;
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menu) {
        if (dh_manager != null) {
            new MenuItem(menu, 2);
            if (dh_manager.isEnabled()) {
                MenuItem itemReset = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemReset, "label.reset.history");
                itemReset.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        SBC_DownloadHistoryView.this.resetHistory();
                    }
                });
                MenuItem itemDisable = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemDisable, "label.disable.history");
                itemDisable.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        dh_manager.setEnabled(false);
                    }
                });
            } else {
                MenuItem itemEnable = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemEnable, "label.enable.history");
                itemEnable.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        dh_manager.setEnabled(true);
                    }
                });
            }
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        if (dh_manager != null && dh_manager.isEnabled()) {
            List<Object> ds = this.tv.getSelectedDataSources();
            final ArrayList<DownloadHistory> dms = new ArrayList<DownloadHistory>(ds.size());
            for (Object o : ds) {
                dms.add((DownloadHistory)o);
            }
            boolean hasSelection = dms.size() > 0;
            final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            MenuItem itemExplore = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
            itemExplore.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    for (DownloadHistory download : dms) {
                        ManagerUtils.open(new File(download.getSaveLocation()), use_open_containing_folder);
                    }
                }
            });
            itemExplore.setEnabled(hasSelection);
            MenuItem itemRedownload = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemRedownload, "label.redownload");
            itemRedownload.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    for (DownloadHistory download : dms) {
                        download.setRedownloading();
                        String magnet = UrlUtils.getMagnetURI(download.getTorrentHash(), download.getTorrentV2Hash(), download.getName(), null);
                        TorrentOpener.openTorrent(magnet);
                    }
                }
            });
            itemExplore.setEnabled(hasSelection);
            MenuItem itemRemove = new MenuItem(menu, 8);
            Utils.setMenuItemImage(itemRemove, "delete");
            Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
            itemRemove.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    dh_manager.removeHistory(dms);
                }
            });
            itemRemove.setEnabled(hasSelection);
            new MenuItem(menu, 2);
            MenuItem itemReset = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemReset, "label.reset.history");
            itemReset.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SBC_DownloadHistoryView.this.resetHistory();
                }
            });
            MenuItem itemDisable = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDisable, "label.disable.history");
            itemDisable.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    dh_manager.setEnabled(false);
                }
            });
            new MenuItem(menu, 2);
        }
    }

    private void resetHistory() {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("downloadhistoryview.reset.title"), MessageText.getString("downloadhistoryview.reset.text"));
        mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                if (result == 0) {
                    dh_manager.resetHistory();
                }
            }
        });
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (rows.length == 1) {
            DownloadHistory dh = (DownloadHistory)rows[0].getDataSource();
            byte[] hash = dh.getTorrentHash();
            DownloadManager dm = CoreFactory.getSingleton().getGlobalManager().getDownloadManager(new HashWrapper(hash));
            if (dm != null) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT().showEntryByID("Library");
                dm.fireGlobalManagerEvent(1);
            }
        }
    }

    @Override
    public void downloadHistoryEventOccurred(DownloadHistoryEvent event2) {
        int type = event2.getEventType();
        List<DownloadHistory> dls = event2.getHistory();
        if (type == 1) {
            this.tv.addDataSources((DownloadHistory[])dls.toArray(new DownloadHistory[dls.size()]));
        } else if (type == 2) {
            this.tv.removeDataSources((DownloadHistory[])dls.toArray(new DownloadHistory[dls.size()]));
        } else {
            for (DownloadHistory d : dls) {
                TableRowCore row = this.tv.getRow(d);
                if (row == null) continue;
                row.invalidate(true);
            }
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean filterCheck(DownloadHistory ds, String filter2, boolean regex, boolean confusable) {
        boolean bOurs;
        String expr;
        Object o_name;
        if (confusable) {
            filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
        }
        if (filter2.startsWith("t:")) {
            filter2 = filter2.substring(2);
            byte[] hash = ds.getTorrentHash();
            ArrayList<String> names = new ArrayList<String>();
            names.add(ByteFormatter.encodeString(hash));
            names.add(Base32.encode(hash));
            o_name = names;
        } else if (filter2.startsWith("f:")) {
            filter2 = filter2.substring(2);
            o_name = ds.getSaveLocation();
        } else {
            o_name = ds.getName();
        }
        boolean match_result = true;
        if (regex) {
            expr = filter2;
            if (expr.startsWith("!")) {
                expr = expr.substring(1);
                match_result = false;
            }
        } else {
            expr = RegExUtil.convertAndOrToExpr(filter2);
        }
        Pattern pattern = RegExUtil.getCachedPattern("downloadhistoryview:search", expr, 66);
        if (o_name instanceof String) {
            String name = (String)o_name;
            if (confusable) {
                name = GeneralUtils.getConfusableEquivalent(name, false);
            }
            bOurs = pattern.matcher(name).find() == match_result;
        } else {
            List names = (List)o_name;
            bOurs = !match_result;
            for (String name : names) {
                if (confusable) {
                    name = GeneralUtils.getConfusableEquivalent(name, false);
                }
                if (!pattern.matcher(name).find()) continue;
                bOurs = match_result;
                break;
            }
        }
        return bOurs;
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof DownloadHistory && this.tv != null && (row = this.tv.getRow((DownloadHistory)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }
}

