/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.activities.ActivitiesListener;
import com.biglybt.activities.ActivitiesManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionAdapter;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.utils.TableColumnCreatorV3;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SBC_ActivityTableView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
ActivitiesListener {
    private static int[] COLOR_UNVIEWED_ENTRIES = new int[]{132, 16, 58};
    private static ActivitiesListener activitiesListener;
    private static MdiEntry mdi_entry;
    private TableViewSWT<ActivitiesEntry> view;
    private String tableID;
    private Composite viewComposite;
    private int viewMode = 0;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        skinObject.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, SBC_ActivityTableView.this.getCurrentlySelectedContent(), SBC_ActivityTableView.this.view);
                } else if (eventType == 1) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, null, SBC_ActivityTableView.this.view);
                }
                return null;
            }
        });
        SWTSkinObject soParent = skinObject.getParent();
        Object data = soParent.getControl().getData("ViewMode");
        if (data instanceof Long) {
            this.viewMode = (int)((Long)data).longValue();
        }
        boolean big = this.viewMode == -1;
        this.tableID = big ? "Activity.big" : "Activity";
        TableColumnCore[] columns = big ? TableColumnCreatorV3.createActivityBig(this.tableID) : TableColumnCreatorV3.createActivitySmall(this.tableID);
        this.view = TableViewFactory.createTableViewSWT(ActivitiesEntry.class, this.tableID, this.tableID, columns, "name", 0x10010002);
        this.view.setRowDefaultHeightEM(big ? 3 : 2);
        this.view.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    SBC_ActivityTableView.this.removeSelected();
                } else if (e.keyCode == 0x100000E) {
                    if ((e.stateMask & 0x20000) != 0) {
                        ActivitiesManager.resetRemovedEntries();
                    }
                    if ((e.stateMask & 0x40000) != 0) {
                        System.out.println("pull all vuze news entries");
                        ActivitiesManager.clearLastPullTimes();
                        ActivitiesManager.pullActivitiesNow(0L, "^F5", true);
                    } else {
                        System.out.println("pull latest vuze news entries");
                        ActivitiesManager.pullActivitiesNow(0L, "F5", true);
                    }
                }
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void selected(TableRowCore[] rows) {
                this.selectionChanged();
                int i = 0;
                while (i < rows.length) {
                    ActivitiesEntry entry = (ActivitiesEntry)rows[i].getDataSource(true);
                    if (entry != null && !entry.isRead() && entry.canFlipRead()) {
                        entry.setRead(true);
                    }
                    ++i;
                }
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    ActivitiesEntry ds = (ActivitiesEntry)rows[0].getDataSource();
                    if (ds.getTypeID().equals("LOCAL_NEWS_ITEM")) {
                        String[] actions = ds.getActions();
                        if (actions.length == 1) {
                            ds.invokeCallback(actions[0]);
                        }
                    } else {
                        TorrentListViewsUtils.playOrStreamDataSource(ds, false);
                    }
                }
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                this.selectionChanged();
            }

            public void selectionChanged() {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        ISelectedContent[] contents = SBC_ActivityTableView.this.getCurrentlySelectedContent();
                        if ((this).SBC_ActivityTableView.this.soMain.isVisible()) {
                            SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, contents, SBC_ActivityTableView.this.view);
                        }
                    }
                });
            }
        }, false);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
                switch (eventType) {
                    case 0: {
                        SBC_ActivityTableView.this.view.addDataSources(ActivitiesManager.getAllEntries().toArray(new ActivitiesEntry[0]));
                        ActivitiesManager.addListener(SBC_ActivityTableView.this);
                        break;
                    }
                    case 1: {
                        ActivitiesManager.removeListener(SBC_ActivityTableView.this);
                    }
                }
            }
        });
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setBackground(Colors.getSystemColor((Device)this.viewComposite.getDisplay(), 22));
        this.viewComposite.setForeground(Colors.getSystemColor((Device)this.viewComposite.getDisplay(), 21));
        this.viewComposite.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout((Layout)gridLayout);
        this.view.initialize(this.viewComposite);
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.delete();
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public String getUpdateUIName() {
        return this.tableID;
    }

    @Override
    public void updateUI() {
        if (this.view != null) {
            this.view.refreshTable(false);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        list.put("remove", this.isVisible() && this.view != null && this.view.getSelectedRowsSize() > 0 ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            this.removeSelected();
            return true;
        }
        return false;
    }

    public ISelectedContent[] getCurrentlySelectedContent() {
        if (this.view == null) {
            return null;
        }
        ArrayList<SelectedContent> listContent = new ArrayList<SelectedContent>();
        Object[] selectedDataSources = this.view.getSelectedDataSources(true);
        int i = 0;
        while (i < selectedDataSources.length) {
            ActivitiesEntry ds = (ActivitiesEntry)selectedDataSources[i];
            if (ds != null) {
                try {
                    SelectedContent currentContent = ds.createSelectedContentObject();
                    if (currentContent != null) {
                        listContent.add(currentContent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return listContent.toArray(new ISelectedContent[listContent.size()]);
    }

    @Override
    public void vuzeNewsEntriesAdded(ActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.addDataSources((ActivitiesEntry[])entries);
        }
    }

    @Override
    public void vuzeNewsEntriesRemoved(ActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.removeDataSources((ActivitiesEntry[])entries);
            this.view.processDataSourceQueue();
        }
    }

    @Override
    public void vuzeNewsEntryChanged(ActivitiesEntry entry) {
        if (this.view == null) {
            return;
        }
        TableRowCore row = this.view.getRow(entry);
        if (row != null) {
            row.invalidate();
        }
    }

    private void removeEntries(final ActivitiesEntry[] toRemove, final int startIndex) {
        final ActivitiesEntry entry = toRemove[startIndex];
        if (entry == null || "Header".equals(entry.getTypeID())) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.removeEntries(toRemove, nextIndex);
            }
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("v3.activity.remove.title"), MessageText.getString("v3.activity.remove.text", new String[]{entry.getText()}));
        mb.setRemember(String.valueOf(this.tableID) + "-Remove", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        if (startIndex == toRemove.length - 1) {
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
            mb.setRememberOnlyIfButton(0);
        } else {
            mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
            mb.setRememberOnlyIfButton(1);
        }
        mb.setHandleHTML(false);
        mb.open(new UserPrompterResultListener(){

            @Override
            public void prompterClosed(int result) {
                int nextIndex;
                if (result == 2) {
                    int numToRemove = toRemove.length - startIndex;
                    ActivitiesEntry[] toGroupRemove = new ActivitiesEntry[numToRemove];
                    System.arraycopy(toRemove, startIndex, toGroupRemove, 0, numToRemove);
                    ActivitiesManager.removeEntries(toGroupRemove);
                    return;
                }
                if (result == 0) {
                    ActivitiesManager.removeEntries(new ActivitiesEntry[]{entry});
                }
                if ((nextIndex = startIndex + 1) < toRemove.length) {
                    SBC_ActivityTableView.this.removeEntries(toRemove, nextIndex);
                }
            }
        });
    }

    protected void removeSelected() {
        if (this.view == null) {
            return;
        }
        ActivitiesEntry[] selectedEntries = this.view.getSelectedDataSources().toArray(new ActivitiesEntry[0]);
        if (selectedEntries.length > 0) {
            this.removeEntries(selectedEntries, 0);
        }
    }

    public TableViewSWT getView() {
        return this.view;
    }

    public static void setupSidebarEntry(final MultipleDocumentInterface mdi) {
        final ViewTitleInfo titleInfoActivityView = new ViewTitleInfo(){
            boolean had_unviewed = false;

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    boolean has_unviewed;
                    int num_unread = 0;
                    int num_unviewed = 0;
                    List<ActivitiesEntry> allEntries = ActivitiesManager.getAllEntries();
                    for (ActivitiesEntry entry : allEntries) {
                        if (!entry.isRead()) {
                            ++num_unread;
                        }
                        if (entry.getViewed()) continue;
                        ++num_unviewed;
                    }
                    if (num_unread == 0) {
                        num_unviewed = 0;
                    }
                    boolean bl = has_unviewed = num_unviewed > 0;
                    if (has_unviewed != this.had_unviewed) {
                        MdiEntry parent;
                        if (has_unviewed && (parent = mdi.getEntry("header.vuze")) != null && !parent.isExpanded()) {
                            parent.setExpanded(true);
                        }
                        this.had_unviewed = has_unviewed;
                    }
                    if (num_unviewed > 0) {
                        return String.valueOf(String.valueOf(num_unviewed)) + (num_unread == 0 ? "" : ":" + num_unread);
                    }
                    if (num_unread > 0) {
                        return String.valueOf(num_unread);
                    }
                    return null;
                }
                if (propertyID == 2) {
                    return "image.sidebar.activity";
                }
                if (propertyID == 8) {
                    boolean has_unread = false;
                    boolean has_unviewed = false;
                    List<ActivitiesEntry> allEntries = ActivitiesManager.getAllEntries();
                    for (ActivitiesEntry entry : allEntries) {
                        if (!entry.isRead()) {
                            has_unread = true;
                        }
                        if (entry.getViewed()) continue;
                        has_unviewed = true;
                    }
                    if (has_unread && has_unviewed) {
                        return COLOR_UNVIEWED_ENTRIES;
                    }
                }
                return null;
            }
        };
        activitiesListener = new ActivitiesListener(){

            @Override
            public void vuzeNewsEntryChanged(ActivitiesEntry entry) {
                this.refresh();
            }

            @Override
            public void vuzeNewsEntriesRemoved(ActivitiesEntry[] entries) {
                this.refresh();
            }

            @Override
            public void vuzeNewsEntriesAdded(ActivitiesEntry[] entries) {
                this.refresh();
            }

            private void refresh() {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
                if (mdi_entry != null) {
                    mdi_entry.redraw();
                }
            }
        };
        ActivitiesManager.addListener(activitiesListener);
        MdiEntryCreationListener creationListener = new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                mdi_entry = mdi.createEntryFromSkinRef("header.vuze", "Activity", "activity", "{sidebar.Activity}", titleInfoActivityView, null, false, null);
                return mdi_entry;
            }
        };
        mdi.registerEntry("Activity", creationListener);
        mdi.registerEntry("activities", creationListener);
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        final MenuItem menuItem = menuManager.addMenuItem("sidebar.Activity", "v3.activity.button.readall");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                List<ActivitiesEntry> allEntries = ActivitiesManager.getAllEntries();
                for (ActivitiesEntry entry : allEntries) {
                    entry.setRead(true);
                }
            }
        });
        mdi.addListener(new MdiListener(){

            @Override
            public void mdiEntrySelected(MdiEntry newEntry, MdiEntry oldEntry) {
            }

            @Override
            public void mdiDisposed(MultipleDocumentInterface mdi) {
                if (activitiesListener != null) {
                    ActivitiesManager.removeListener(activitiesListener);
                    SBC_ActivityTableView.activitiesListener = null;
                }
                menuItem.remove();
            }
        });
    }
}

