/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.backup.BackupManager;
import com.biglybt.core.backup.BackupManagerFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.config.InfoParameter;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.config.ConfigSectionBackupRestore;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.views.configsections.BaseConfigSectionSWT;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ConfigSectionBackupRestoreSWT
extends ConfigSectionBackupRestore
implements BaseConfigSectionSWT {
    private Shell shell;

    public ConfigSectionBackupRestoreSWT() {
        BackupManager backup_manager = BackupManagerFactory.getManager(CoreFactory.getSingleton());
        this.init(mapParams -> this.doManualBackup(backup_manager, () -> ConfigSectionBackupRestoreSWT.updateInfoParams(backup_manager, mapParams)), mapParams -> ConfigSectionBackupRestoreSWT.runBackup(backup_manager, null, () -> ConfigSectionBackupRestoreSWT.updateInfoParams(backup_manager, mapParams)), mapParams -> this.restoreBackup());
    }

    @Override
    public void configSectionCreate(Composite parent, Map<ParameterImpl, BaseSwtParameter> mapParamToSwtParam) {
        this.shell = parent.getShell();
    }

    private void doManualBackup(BackupManager backup_manager, Runnable stats_updater) {
        if (Utils.runIfNotSWTThread(() -> this.doManualBackup(backup_manager, stats_updater))) {
            return;
        }
        if (this.shell == null) {
            this.shell = Utils.findAnyShell();
        }
        String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
        DirectoryDialog dialog = new DirectoryDialog(this.shell, 65536);
        if (!def_dir.isEmpty()) {
            dialog.setFilterPath(def_dir);
        }
        dialog.setMessage(MessageText.getString("br.backup.folder.info"));
        dialog.setText(MessageText.getString("br.backup.folder.title"));
        String path = dialog.open();
        if (path != null) {
            COConfigurationManager.setParameter("br.backup.folder.default", path);
            ConfigSectionBackupRestoreSWT.runBackup(backup_manager, path, stats_updater);
        }
    }

    private void restoreBackup() {
        if (Utils.runIfNotSWTThread(this::restoreBackup)) {
            return;
        }
        String def_dir = COConfigurationManager.getStringParameter("br.backup.folder.default");
        DirectoryDialog dialog = new DirectoryDialog(this.shell, 65536);
        if (!def_dir.isEmpty()) {
            dialog.setFilterPath(def_dir);
        }
        dialog.setMessage(MessageText.getString("br.restore.folder.info"));
        dialog.setText(MessageText.getString("br.restore.folder.title"));
        String path = dialog.open();
        if (path != null) {
            MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("br.restore.warning.title"), MessageText.getString("br.restore.warning.info"));
            mb.setDefaultButtonUsingStyle(256);
            mb.setParent(this.shell);
            mb.open(returnVal -> {
                if (returnVal != 32) {
                    return;
                }
                final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("br.backup.progress"), null, "", true, true);
                viewer.setEditable(false);
                viewer.setOKEnabled(false);
                BackupManager backup_manager = BackupManagerFactory.getManager(CoreFactory.getSingleton());
                backup_manager.restore(new File(path), new BackupManager.BackupListener(){

                    @Override
                    public boolean reportProgress(String str) {
                        return this.append(str, false);
                    }

                    @Override
                    public void reportComplete() {
                        this.append("Restore Complete!", true);
                        Utils.execSWTThread(() -> {
                            MessageBoxShell mb1 = new MessageBoxShell(34, MessageText.getString("ConfigView.section.security.restart.title"), MessageText.getString("ConfigView.section.security.restart.msg"));
                            mb1.setParent(ConfigSectionBackupRestoreSWT.this.shell);
                            mb1.open(returnVal1 -> {
                                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                                if (uiFunctions != null) {
                                    uiFunctions.dispose(true);
                                }
                            });
                        });
                    }

                    @Override
                    public void reportError(Throwable error) {
                        this.append("Restore Failed: " + Debug.getNestedExceptionMessage(error), true);
                    }

                    private boolean append(String str, boolean complete) {
                        if (viewer.isDisposed() || str == null) {
                            return false;
                        }
                        Utils.execSWTThread(() -> {
                            if (!viewer.isDisposed()) {
                                if (str.endsWith("...")) {
                                    viewer.append(str);
                                } else {
                                    viewer.append(String.valueOf(str) + "\r\n");
                                }
                                if (complete) {
                                    viewer.setOKEnabled(true);
                                }
                            }
                        });
                        return true;
                    }
                });
                viewer.goModal();
            });
        }
    }

    private static void updateInfoParams(BackupManager backup_manager, Map<String, ParameterImpl> mapParams) {
        InfoParameter paramInfoLastTime = (InfoParameter)((Object)mapParams.get("lasttime"));
        InfoParameter paramInfoLastErr = (InfoParameter)((Object)mapParams.get("lasterr"));
        if (paramInfoLastErr != null && paramInfoLastTime != null) {
            long backup_time = backup_manager.getLastBackupTime();
            paramInfoLastTime.setValue(backup_time == 0L ? "" : String.valueOf(new Date(backup_time)));
            paramInfoLastErr.setValue(backup_manager.getLastBackupError());
        }
    }

    private static void runBackup(BackupManager backup_manager, String path, final Runnable stats_updater) {
        boolean modal = false;
        if (Utils.runIfNotSWTThread(() -> ConfigSectionBackupRestoreSWT.runBackup(backup_manager, path, stats_updater))) {
            return;
        }
        final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("br.backup.progress"), null, "", modal, modal);
        viewer.setEditable(false);
        viewer.setOKEnabled(false);
        BackupManager.BackupListener listener = new BackupManager.BackupListener(){

            @Override
            public boolean reportProgress(String str) {
                return this.append(str, false);
            }

            @Override
            public void reportComplete() {
                this.append("Backup Complete!", true);
            }

            @Override
            public void reportError(Throwable error) {
                this.append("Backup Failed: " + Debug.getNestedExceptionMessage(error), true);
            }

            private boolean append(String str, boolean complete) {
                if (viewer.isDisposed() || str == null) {
                    return false;
                }
                Utils.execSWTThread(() -> {
                    if (str.endsWith("...")) {
                        viewer.append(str);
                    } else {
                        viewer.append(String.valueOf(str) + "\r\n");
                    }
                    if (complete) {
                        viewer.setOKEnabled(true);
                        stats_updater.run();
                    }
                });
                return true;
            }
        };
        if (path == null) {
            backup_manager.runAutoBackup(listener);
        } else {
            backup_manager.backup(new File(path), listener);
        }
        if (modal) {
            viewer.goModal();
        }
    }
}

