/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.columnsetup;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionAdapter;
import com.biglybt.ui.common.table.TableStructureModificationListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TableColumnSetupWindow
implements UIUpdatable {
    private static final String TABLEID_AVAIL = "ColumnSetupAvail";
    private static final String TABLEID_CHOSEN = "ColumnSetupChosen";
    private static final boolean CAT_BUTTONS = true;
    private Shell shell;
    private TableViewSWT<TableColumn> tvAvail;
    private final String forTableID;
    private final Class<?> forDataSourceType;
    private Composite cTableAvail;
    private Composite cCategories;
    private TableViewSWT<TableColumnCore> tvChosen;
    private Composite cTableChosen;
    private final TableColumnCore[] columnsCurrentOrder;
    private final TableColumnCore[] columnsOriginalOrder;
    private final TableRow sampleRow;
    private DragSourceListener dragSourceListener;
    private final TableStructureModificationListener<?> listener;
    protected boolean apply = false;
    private Button[] radProficiency = new Button[3];
    private Map<TableColumnCore, Boolean> mapNewVisibility = new HashMap<TableColumnCore, Boolean>();
    private ArrayList<TableColumnCore> listColumnsNoCat;
    private ArrayList<String> listCats;
    private Combo comboFilter;
    private Group cPickArea;
    private Button btnApply;
    private Button btnExport;

    public TableColumnSetupWindow(final Class<?> forDataSourceType, String _tableID, TableColumnCore selectedColumn, TableRow sampleRow, TableStructureModificationListener<?> _listener) {
        TableRowCore row;
        this.sampleRow = sampleRow;
        this.listener = _listener;
        this.forDataSourceType = forDataSourceType;
        this.forTableID = _tableID;
        this.dragSourceListener = new DragSourceListener(){
            private TableColumnCore tableColumn;

            public void dragStart(DragSourceEvent event2) {
                event2.doit = true;
                if (!(event2.widget instanceof DragSource)) {
                    event2.doit = false;
                    return;
                }
                TableView tv = (TableView)((DragSource)event2.widget).getData("tv");
                TableRowCore row = tv.getFocusedRow();
                if (row == null) {
                    event2.doit = false;
                    return;
                }
                this.tableColumn = (TableColumnCore)row.getDataSource();
                if (event2.image != null && !Constants.isLinux) {
                    try {
                        GC gc = new GC((Drawable)event2.image);
                        try {
                            Rectangle bounds = event2.image.getBounds();
                            gc.fillRectangle(bounds);
                            String title = MessageText.getString(this.tableColumn.getTitleLanguageKey(), this.tableColumn.getName());
                            String s = String.valueOf(title) + " Column will be placed at the location you drop it, shifting other columns down";
                            GCStringPrinter sp = new GCStringPrinter(gc, s, bounds, false, false, 0x1000040);
                            sp.calculateMetrics();
                            if (sp.isCutoff()) {
                                GCStringPrinter.printString(gc, title, bounds, false, false, 0x1000040);
                            } else {
                                sp.printString();
                            }
                        }
                        finally {
                            gc.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }

            public void dragSetData(DragSourceEvent event2) {
                if (!(event2.widget instanceof DragSource)) {
                    return;
                }
                TableView tv = (TableView)((DragSource)event2.widget).getData("tv");
                event2.data = tv == TableColumnSetupWindow.this.tvChosen ? "c" : "a";
            }

            public void dragFinished(DragSourceEvent event2) {
            }
        };
        String baseID = Utils.getBaseViewID(_tableID);
        String tableName = MessageText.getString(String.valueOf(baseID) + "View.header", null);
        if (tableName == null && (tableName = MessageText.getString(String.valueOf(baseID) + "View.title.full", null)) == null) {
            tableName = baseID;
        }
        final TableColumnManager tcm = TableColumnManager.getInstance();
        this.columnsCurrentOrder = tcm.getAllTableColumnCoreAsArray(forDataSourceType, this.forTableID);
        Arrays.sort(this.columnsCurrentOrder, TableColumnManager.getTableColumnOrderComparator());
        this.columnsOriginalOrder = new TableColumnCore[this.columnsCurrentOrder.length];
        System.arraycopy(this.columnsCurrentOrder, 0, this.columnsOriginalOrder, 0, this.columnsCurrentOrder.length);
        int i = 0;
        while (i < this.columnsCurrentOrder.length) {
            boolean visible = this.columnsCurrentOrder[i].isVisible();
            this.mapNewVisibility.put(this.columnsCurrentOrder[i], visible);
            ++i;
        }
        this.shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        Utils.setShellIcon(this.shell);
        FormLayout formLayout = new FormLayout();
        this.shell.setText(MessageText.getString("ColumnSetup.title", new String[]{tableName}));
        this.shell.setLayout((Layout)formLayout);
        this.shell.setSize(780, 550);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TableColumnSetupWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableColumnSetupWindow.this.close();
            }
        });
        Label topInfo = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)topInfo, "ColumnSetup.explain");
        FormData fd = Utils.getFilledFormData();
        fd.left.offset = 5;
        fd.top.offset = 5;
        fd.bottom = null;
        topInfo.setLayoutData((Object)fd);
        Button btnOk = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.apply = true;
                TableColumnSetupWindow.this.shell.dispose();
            }
        });
        this.cPickArea = Utils.createSkinnedGroup((Composite)this.shell, 0);
        this.cPickArea.setLayout((Layout)new FormLayout());
        final ExpandBar expandFilters = new ExpandBar((Composite)this.cPickArea, 0);
        expandFilters.setSpacing(1);
        final Composite cFilterArea = new Composite((Composite)expandFilters, 0);
        cFilterArea.setLayout((Layout)new FormLayout());
        Group cResultArea = Utils.createSkinnedGroup((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)cResultArea, "ColumnSetup.chosencolumns");
        cResultArea.setLayout((Layout)new FormLayout());
        Composite cResultButtonArea = new Composite((Composite)cResultArea, 0);
        cResultButtonArea.setLayout((Layout)new FormLayout());
        Composite cColumnButtonArea = new Composite((Composite)cResultArea, 0);
        cColumnButtonArea.setLayout((Layout)new FormLayout());
        this.tvAvail = this.createTVAvail();
        this.cTableAvail = new Composite((Composite)this.cPickArea, 524288);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.cTableAvail.setLayout((Layout)gridLayout);
        BubbleTextBox bubbleTextBox = new BubbleTextBox(this.cTableAvail, 2948);
        GridData gd = new GridData(131072, 0x1000000, true, false);
        gd.widthHint = 150;
        bubbleTextBox.setMessageAndLayout(MessageText.getString("column.setup.search"), gd);
        this.tvAvail.enableFilterCheck(bubbleTextBox, new TableViewFilterCheck<TableColumn>(){

            @Override
            public boolean filterCheck(TableColumn ds, String filter2, boolean regex, boolean confusable) {
                String[] names;
                String rename;
                if (confusable) {
                    return false;
                }
                TableColumnCore core = (TableColumnCore)ds;
                String raw_key = core.getTitleLanguageKey(false);
                String current_key = core.getTitleLanguageKey(true);
                String name1 = MessageText.getString(raw_key, core.getName());
                String name2 = core.getNameOverride();
                String name3 = null;
                if (!raw_key.equals(current_key) && (rename = MessageText.getString(current_key, "")).length() > 0) {
                    name3 = rename;
                }
                String[] stringArray = names = new String[]{name1, name2, name3, MessageText.getString(String.valueOf(core.getTitleLanguageKey()) + ".info")};
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (name != null) {
                        Pattern pattern;
                        String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
                        boolean match_result = true;
                        if (regex && s.startsWith("!")) {
                            s = s.substring(1);
                            match_result = false;
                        }
                        if ((pattern = RegExUtil.getCachedPattern("tcs:search", s, 66)).matcher(name).find() == match_result) {
                            return true;
                        }
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public void filterSet(String filter2) {
            }
        });
        this.tvAvail.initialize(this.cTableAvail);
        TableColumnCore[] datasources = tcm.getAllTableColumnCoreAsArray(forDataSourceType, this.forTableID);
        this.listColumnsNoCat = new ArrayList<TableColumnCore>(Arrays.asList(datasources));
        this.listCats = new ArrayList();
        int i2 = 0;
        while (i2 < datasources.length) {
            String[] categories;
            TableColumnCore column = datasources[i2];
            TableColumnInfo info = tcm.getColumnInfo(forDataSourceType, this.forTableID, column.getName());
            if (info != null && (categories = info.getCategories()) != null && categories.length > 0) {
                int j = 0;
                while (j < categories.length) {
                    String cat = categories[j];
                    if (!this.listCats.contains(cat)) {
                        this.listCats.add(cat);
                    }
                    ++j;
                }
                this.listColumnsNoCat.remove(column);
            }
            ++i2;
        }
        Listener radListener = new Listener(){

            public void handleEvent(Event event2) {
                TableColumnSetupWindow.this.fillAvail();
            }
        };
        Composite cProficiency = new Composite(cFilterArea, 0);
        cProficiency.setLayout((Layout)new FormLayout());
        Label lblProficiency = new Label(cProficiency, 0);
        Messages.setLanguageText((Widget)lblProficiency, "ColumnSetup.proficiency");
        this.radProficiency[0] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[0], "ConfigView.section.mode.beginner");
        fd = new FormData();
        fd.left = new FormAttachment((Control)lblProficiency, 5);
        this.radProficiency[0].setLayoutData((Object)fd);
        this.radProficiency[0].addListener(13, radListener);
        this.radProficiency[1] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[1], "ConfigView.section.mode.intermediate");
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.radProficiency[0], 5);
        this.radProficiency[1].setLayoutData((Object)fd);
        this.radProficiency[1].addListener(13, radListener);
        this.radProficiency[2] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[2], "ConfigView.section.mode.advanced");
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.radProficiency[1], 5);
        this.radProficiency[2].setLayoutData((Object)fd);
        this.radProficiency[2].addListener(13, radListener);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 0) {
            userMode = 0;
        } else if (userMode >= this.radProficiency.length) {
            userMode = this.radProficiency.length - 1;
        }
        this.radProficiency[userMode].setSelection(true);
        Listener buttonListener = new Listener(){

            public void handleEvent(Event event2) {
                Control[] children = TableColumnSetupWindow.this.cCategories.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (child != event2.widget && child instanceof Button) {
                        Button btn = (Button)child;
                        btn.setSelection(false);
                    }
                    ++i;
                }
                TableColumnSetupWindow.this.fillAvail();
            }
        };
        Label lblCat = new Label(cFilterArea, 0);
        Messages.setLanguageText((Widget)lblCat, "ColumnSetup.categories");
        this.cCategories = new Composite(cFilterArea, 0);
        this.cCategories.setLayout((Layout)new RowLayout());
        Button button = new Button(this.cCategories, 2);
        Messages.setLanguageText((Widget)button, "Categories.all");
        button.addListener(13, buttonListener);
        button.setSelection(true);
        for (String cat : this.listCats) {
            button = new Button(this.cCategories, 2);
            button.setData("cat", (Object)cat);
            if (MessageText.keyExists("ColumnCategory." + cat)) {
                button.setText(MessageText.getString("ColumnCategory." + cat));
            } else {
                button.setText(cat);
            }
            button.addListener(13, buttonListener);
        }
        if (this.listColumnsNoCat.size() > 0) {
            button = new Button(this.cCategories, 2);
            if (MessageText.keyExists("ColumnCategory.uncat")) {
                button.setText(MessageText.getString("ColumnCategory.uncat"));
            } else {
                button.setText("?");
            }
            button.setText("?");
            button.setData("cat", (Object)"uncat");
            button.addListener(13, buttonListener);
        }
        final ExpandItem expandItemFilters = new ExpandItem(expandFilters, 0);
        expandItemFilters.setText(MessageText.getString("ColumnSetup.filters"));
        expandItemFilters.setControl((Control)cFilterArea);
        expandFilters.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                expandItemFilters.setHeight(cFilterArea.computeSize((int)expandFilters.getSize().x, (int)-1).y + 3);
            }
        });
        expandFilters.addListener(17, new Listener(){

            public void handleEvent(Event event2) {
                Utils.execSWTThreadLater(Constants.isLinux ? 250 : 0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        TableColumnSetupWindow.this.shell.layout(true, true);
                    }
                });
            }
        });
        expandFilters.addListener(18, new Listener(){

            public void handleEvent(Event event2) {
                Utils.execSWTThreadLater(Constants.isLinux ? 250 : 0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        TableColumnSetupWindow.this.shell.layout(true, true);
                    }
                });
            }
        });
        ImageLoader imageLoader = ImageLoader.getInstance();
        Button[] alignButtons = new Button[3];
        final Consumer<Integer> updateAlignButtons = align -> {
            alignButtons[0].setBackground((Color)(align == 1 ? Colors.fadedBlue : null));
            alignButtons[1].setBackground((Color)(align == 3 ? Colors.fadedBlue : null));
            alignButtons[2].setBackground((Color)(align == 2 ? Colors.fadedBlue : null));
        };
        final Button btnLeft = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnLeft, "alignleft");
        Messages.setLanguageTooltip((Widget)btnLeft, "MyTracker.column.left");
        btnLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(1);
                updateAlignButtons.accept(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button btnCentre = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnCentre, "aligncentre");
        Messages.setLanguageTooltip((Widget)btnCentre, "label.center");
        btnCentre.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(3);
                updateAlignButtons.accept(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button btnRight = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnRight, "alignright");
        Messages.setLanguageTooltip((Widget)btnRight, "label.right");
        btnRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(2);
                updateAlignButtons.accept(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        alignButtons[0] = btnLeft;
        alignButtons[1] = btnCentre;
        alignButtons[2] = btnRight;
        final Utils.ColorButton colorForeground = Utils.createColorButton(cColumnButtonArea, new Point(16, 16), true, null, null, rgb -> this.setChosenColor((int[])rgb, true));
        final Button btnForeground = colorForeground.getButton();
        final Utils.ColorButton colorBackground = Utils.createColorButton(cColumnButtonArea, new Point(16, 16), false, null, null, rgb -> this.setChosenColor((int[])rgb, false));
        final Button btnBackground = colorBackground.getButton();
        final Button btnUp = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnUp, "up");
        Messages.setLanguageTooltip((Widget)btnUp, "label.move.up");
        btnUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.moveChosenUp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button btnDown = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnDown, "down");
        Messages.setLanguageTooltip((Widget)btnDown, "label.move.down");
        btnDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.moveChosenDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button btnDel = new Button(cColumnButtonArea, 8);
        imageLoader.setButtonImage(btnDel, "delete2");
        Messages.setLanguageTooltip((Widget)btnDel, "MySharesView.menu.remove");
        btnDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.removeSelectedChosen();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnImport = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnImport, "import");
        Messages.setLanguageTooltip((Widget)btnImport, "label.import.config.from.clip");
        this.btnExport = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(this.btnExport, "export");
        Messages.setLanguageTooltip((Widget)this.btnExport, "label.export.config.to.clip");
        this.btnExport.addListener(13, e -> {
            tcm.saveTableColumns(forDataSourceType, this.forTableID);
            Map config = tcm.getTableConfigMap(this.forTableID);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("table-id", Utils.getBaseViewID(this.forTableID));
            map.put("config", config);
            String json = BEncoder.encodeToJSON(map);
            ClipboardCopy.copyToClipBoard(json);
        });
        this.tvChosen = this.createTVChosen();
        this.tvChosen.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void selectionChanged(TableRowCore[] selected_rows, TableRowCore[] deselected_rows) {
                Utils.execSWTThread(() -> {
                    List<Object> ds = TableColumnSetupWindow.this.tvChosen.getSelectedDataSources();
                    boolean hasSelection = ds.size() > 0;
                    btnLeft.setEnabled(hasSelection);
                    btnCentre.setEnabled(hasSelection);
                    btnRight.setEnabled(hasSelection);
                    btnForeground.setEnabled(hasSelection);
                    btnBackground.setEnabled(hasSelection);
                    btnUp.setEnabled(hasSelection);
                    btnDown.setEnabled(hasSelection);
                    btnDel.setEnabled(hasSelection);
                    if (hasSelection && ds.size() == 1) {
                        TableColumnCore tc = (TableColumnCore)ds.get(0);
                        colorForeground.setColor(tc.getForegroundColor());
                        colorBackground.setColor(tc.getBackgroundColor());
                        int align = tc.getAlignment();
                        updateAlignButtons.accept(align);
                    } else {
                        colorForeground.setColor(null);
                        colorBackground.setColor(null);
                        updateAlignButtons.accept(-1);
                    }
                });
            }
        }, true);
        this.cTableChosen = new Composite((Composite)cResultArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.cTableChosen.setLayout((Layout)gridLayout);
        this.tvChosen.initialize(this.cTableChosen);
        int i3 = 0;
        while (i3 < this.columnsCurrentOrder.length) {
            boolean visible = this.columnsCurrentOrder[i3].isVisible();
            if (visible) {
                this.tvChosen.addDataSource(this.columnsCurrentOrder[i3]);
            }
            ++i3;
        }
        this.tvChosen.processDataSourceQueueSync();
        if (selectedColumn != null && (row = this.tvChosen.getRow(selectedColumn)) != null) {
            this.tvChosen.setSelectedRows(new TableRowCore[]{row});
            Utils.execSWTThreadLater(100, () -> this.tvChosen.showRow(row));
        }
        Button btnReset = new Button(cResultButtonArea, 8);
        Messages.setLanguageText((Widget)btnReset, "Button.reset");
        String[] defaultColumnNames = tcm.getDefaultColumnNames(this.forTableID);
        btnReset.setEnabled(defaultColumnNames != null);
        final Button btnCancel = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.shell.dispose();
            }
        });
        this.btnApply = new Button(cResultButtonArea, 8);
        Messages.setLanguageText((Widget)this.btnApply, "Button.apply");
        this.btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.apply();
                btnCancel.setEnabled(false);
            }
        });
        btnImport.addListener(13, ev -> {
            String json = ClipboardCopy.copyFromClipboard();
            try {
                Map map = BDecoder.decodeFromJSON(json);
                map = BDecoder.decodeStrings(map);
                String tableID = (String)map.get("table-id");
                Map config = (Map)map.get("config");
                if (tableID.equals(Utils.getBaseViewID(this.forTableID))) {
                    tcm.setTableConfigMap(this.forTableID, config);
                    tcm.loadTableColumnSettings(forDataSourceType, this.forTableID);
                    this.listener.tableStructureChanged(true, forDataSourceType);
                    this.listener.sortOrderChanged();
                    Arrays.sort(this.columnsCurrentOrder, TableColumnManager.getTableColumnOrderComparator());
                    int i = 0;
                    while (i < this.columnsCurrentOrder.length) {
                        boolean visible = this.columnsCurrentOrder[i].isVisible();
                        this.mapNewVisibility.put(this.columnsCurrentOrder[i], visible);
                        ++i;
                    }
                    this.fillChosen();
                    this.fillAvail();
                    this.setHasChanges(false);
                    btnCancel.setEnabled(false);
                } else {
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("table.columns.incorrect.table", new String[]{String.valueOf(Utils.getBaseViewID(this.forTableID)) + "/" + tableID}));
                    mb.setParent(this.shell);
                    mb.open(null);
                }
            }
            catch (Throwable e) {
                MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("label.invalid.configuration"));
                mb.setParent(this.shell);
                mb.open(null);
            }
        });
        if (defaultColumnNames != null) {
            btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageBoxShell mb = new MessageBoxShell(MessageText.getString("table.columns.reset.dialog.title"), MessageText.getString("table.columns.reset.dialog.text"), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                    mb.open(new UserPrompterResultListener(){

                        @Override
                        public void prompterClosed(int result) {
                            if (result == 0) {
                                tcm.resetColumns(forDataSourceType, TableColumnSetupWindow.this.forTableID);
                                Arrays.sort(TableColumnSetupWindow.this.columnsCurrentOrder, TableColumnManager.getTableColumnOrderComparator());
                                int i = 0;
                                while (i < TableColumnSetupWindow.this.columnsCurrentOrder.length) {
                                    boolean visible = TableColumnSetupWindow.this.columnsCurrentOrder[i].isVisible();
                                    TableColumnSetupWindow.this.mapNewVisibility.put(TableColumnSetupWindow.this.columnsCurrentOrder[i], visible);
                                    ++i;
                                }
                                TableColumnSetupWindow.this.fillChosen();
                                TableColumnSetupWindow.this.fillAvail();
                                TableColumnSetupWindow.this.setHasChanges(false);
                                btnCancel.setEnabled(false);
                                updateAlignButtons.accept(-1);
                                colorForeground.setColor(null);
                                colorBackground.setColor(null);
                            }
                        }
                    });
                }
            });
        }
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd = new FormData();
        fd.top = new FormAttachment((Control)topInfo, 5);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)btnOk, -5);
        fd.width = Constants.isWindows ? 200 : 230;
        cResultArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)cColumnButtonArea, -3);
        this.cTableChosen.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)cResultButtonArea, -3);
        fd.left = new FormAttachment((Control)this.cTableChosen, 0, 0x1000000);
        fd.right = new FormAttachment(100, 0);
        cColumnButtonArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        cResultButtonArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cColumnButtonArea, 3);
        fd.left = new FormAttachment(0, 3);
        btnLeft.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnLeft, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnCentre.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnCentre, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnRight.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnRight, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnForeground.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnForeground, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnBackground.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnCentre, 0, 16384);
        fd.top = new FormAttachment((Control)btnLeft, 2);
        btnUp.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnUp, 3);
        fd.top = new FormAttachment((Control)btnUp, 0, 128);
        btnDown.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnDown, 3);
        fd.top = new FormAttachment((Control)btnUp, 0, 128);
        btnDel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment((Control)this.btnExport, 0, 1024);
        btnImport.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnImport, 3);
        fd.bottom = new FormAttachment((Control)btnReset, 0, 1024);
        this.btnExport.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)this.btnApply, -3);
        fd.bottom = new FormAttachment((Control)this.btnApply, 0, 1024);
        btnReset.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -5);
        fd.top = new FormAttachment((Control)btnUp, 3, 1024);
        this.btnApply.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -8);
        fd.bottom = new FormAttachment(100, -3);
        btnCancel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)btnCancel, -3);
        fd.bottom = new FormAttachment((Control)btnCancel, 0, 1024);
        btnOk.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)topInfo, 5);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment((Control)cResultArea, -3);
        fd.bottom = new FormAttachment(100, -3);
        this.cPickArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        expandFilters.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.cCategories, 0, 0x1000000);
        fd.left = new FormAttachment(0, 5);
        lblCat.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.radProficiency[0], 0, 0x1000000);
        fd.left = new FormAttachment(0, 0);
        lblProficiency.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cProficiency, 5);
        fd.left = new FormAttachment((Control)lblCat, 5);
        fd.right = new FormAttachment(100, 0);
        this.cCategories.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        cProficiency.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)expandFilters, -3);
        this.cTableAvail.setLayoutData((Object)fd);
        this.setHasChanges(false);
        this.shell.setTabList(new Control[]{this.cPickArea, cResultArea, btnOk, btnCancel});
        this.cPickArea.setTabList(new Control[]{this.cTableAvail});
        this.fillAvail();
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    private void setHasChanges(boolean hasChanges) {
        this.btnApply.setEnabled(hasChanges);
        this.btnExport.setEnabled(!hasChanges);
    }

    private void fillChosen() {
        this.tvChosen.removeAllTableRows();
        int i = 0;
        while (i < this.columnsCurrentOrder.length) {
            boolean visible = this.mapNewVisibility.get(this.columnsCurrentOrder[i]);
            if (visible) {
                this.tvChosen.addDataSource(this.columnsCurrentOrder[i]);
            }
            ++i;
        }
        this.tvChosen.processDataSourceQueue();
    }

    protected void fillAvail() {
        String selectedCat = null;
        Control[] children = this.cCategories.getChildren();
        int i = 0;
        while (i < children.length) {
            Button btn;
            Control child = children[i];
            if (child instanceof Button && (btn = (Button)child).getSelection()) {
                selectedCat = (String)btn.getData("cat");
                break;
            }
            ++i;
        }
        if (selectedCat != null && selectedCat.equals("all")) {
            selectedCat = null;
        }
        int selectedProf = 0;
        i = 0;
        while (i < this.radProficiency.length) {
            Button btn = this.radProficiency[i];
            if (btn.getSelection()) {
                selectedProf = i;
                break;
            }
            i = (byte)(i + 1);
        }
        String s = selectedCat != null ? MessageText.getString("ColumnSetup.availcolumns.filteredby", new String[]{this.radProficiency[selectedProf].getText(), selectedCat}) : MessageText.getString("ColumnSetup.availcolumns", new String[]{this.radProficiency[selectedProf].getText()});
        this.cPickArea.setText(s);
        this.tvAvail.removeAllTableRows();
        TableColumnManager tcm = TableColumnManager.getInstance();
        TableColumnCore[] datasources = tcm.getAllTableColumnCoreAsArray(this.forDataSourceType, this.forTableID);
        if (selectedCat == "uncat") {
            datasources = this.listColumnsNoCat.toArray(new TableColumnCore[this.listColumnsNoCat.size()]);
        }
        int i2 = 0;
        while (i2 < datasources.length) {
            String[] cats;
            TableColumnCore column = datasources[i2];
            TableColumnInfo info = tcm.getColumnInfo(this.forDataSourceType, this.forTableID, column.getName());
            String[] stringArray = cats = info == null ? null : info.getCategories();
            if (cats == null) {
                if (selectedCat == null || selectedCat.equals("uncat")) {
                    this.tvAvail.addDataSource(column);
                }
            } else {
                int j = 0;
                while (j < cats.length) {
                    String cat = cats[j];
                    if ((selectedCat == null || selectedCat.equalsIgnoreCase(cat)) && info.getProficiency() <= selectedProf) {
                        this.tvAvail.addDataSource(column);
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        this.tvAvail.processDataSourceQueue();
    }

    protected void removeSelectedChosen() {
        Object[] datasources = this.tvChosen.getSelectedDataSources().toArray();
        TableColumnCore[] cols = new TableColumnCore[datasources.length];
        int i = 0;
        while (i < datasources.length) {
            TableColumnCore column;
            cols[i] = column = (TableColumnCore)datasources[i];
            this.mapNewVisibility.put(column, Boolean.FALSE);
            ++i;
        }
        this.tvChosen.removeDataSources((TableColumnCore[])cols);
        this.tvChosen.processDataSourceQueue();
        i = 0;
        while (i < datasources.length) {
            TableRowSWT row = (TableRowSWT)this.tvAvail.getRow((TableColumn)datasources[i]);
            if (row != null) {
                row.redraw();
            }
            ++i;
        }
        this.setHasChanges(true);
    }

    protected void moveChosenDown() {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        TableRowCore[] rows = this.tvChosen.getRows();
        int i = selectedRows.length - 1;
        while (i >= 0) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column != null) {
                int oldColumnPos = column.getPosition();
                int oldRowPos = row.getIndex();
                if (oldRowPos < rows.length - 1) {
                    TableRowCore displacedRow = rows[oldRowPos + 1];
                    ((TableColumnCore)displacedRow.getDataSource()).setPositionNoShift(oldColumnPos);
                    rows[oldRowPos + 1] = rows[oldRowPos];
                    rows[oldRowPos] = displacedRow;
                    column.setPositionNoShift(oldColumnPos + 1);
                }
            }
            --i;
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
        this.setHasChanges(true);
    }

    protected void moveChosenUp() {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        TableRowCore[] rows = this.tvChosen.getRows();
        int i = 0;
        while (i < selectedRows.length) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column != null) {
                int oldColumnPos = column.getPosition();
                int oldRowPos = row.getIndex();
                if (oldRowPos > 0) {
                    TableRowCore displacedRow = rows[oldRowPos - 1];
                    ((TableColumnCore)displacedRow.getDataSource()).setPositionNoShift(oldColumnPos);
                    rows[oldRowPos - 1] = rows[oldRowPos];
                    rows[oldRowPos] = displacedRow;
                    column.setPositionNoShift(oldColumnPos - 1);
                    column.setAlignment(3);
                }
            }
            ++i;
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
        this.setHasChanges(true);
    }

    protected void alignChosen(int align) {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column != null) {
                column.setAlignment(align);
            }
            ++i;
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
        this.setHasChanges(true);
    }

    protected void setChosenColor(int[] rgb, boolean fg) {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column != null) {
                if (fg) {
                    column.setForegroundColor(rgb);
                } else {
                    column.setBackgroundColor(rgb);
                }
            }
            ++i;
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
        this.setHasChanges(true);
    }

    protected void apply() {
        TableColumnManager tcm = TableColumnManager.getInstance();
        for (TableColumnCore tc : this.mapNewVisibility.keySet()) {
            boolean visible = this.mapNewVisibility.get(tc);
            tc.setVisible(visible);
        }
        tcm.saveTableColumns(this.forDataSourceType, this.forTableID);
        this.listener.tableStructureChanged(true, this.forDataSourceType);
        this.setHasChanges(false);
    }

    private TableViewSWT<TableColumnCore> createTVChosen() {
        TableColumnManager tcm = TableColumnManager.getInstance();
        TableColumnCore[] columnTVChosen = tcm.getAllTableColumnCoreAsArray(TableColumn.class, TABLEID_CHOSEN);
        int i = 0;
        while (i < columnTVChosen.length) {
            TableColumnCore column = columnTVChosen[i];
            if (column.getName().equals("TableColumnChosenColumn")) {
                column.setVisible(true);
                column.setWidth(175);
                column.setSortAscending(true);
            } else {
                column.setVisible(false);
            }
            ++i;
        }
        final TableViewSWT<TableColumnCore> tvChosen = TableViewFactory.createTableViewSWT(TableColumn.class, TABLEID_CHOSEN, TABLEID_CHOSEN, columnTVChosen, "TableColumnChosenColumn", 0x10010002);
        this.tvAvail.setParentDataSource(this);
        tvChosen.setMenuEnabled(false);
        tvChosen.setHeaderVisible(false);
        tvChosen.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
                if (eventType == 0) {
                    this.tableViewInitialized();
                }
            }

            private void tableViewInitialized() {
                DragSource dragSource = tvChosen.createDragSource(7);
                dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dragSource.setData("tv", (Object)tvChosen);
                dragSource.addDragListener(TableColumnSetupWindow.this.dragSourceListener);
                DropTarget dropTarget = tvChosen.createDropTarget(31);
                dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void drop(DropTargetEvent event2) {
                        Object[] dataSources;
                        String id = (String)event2.data;
                        TableRowCore destRow = tvChosen.getRow(event2);
                        TableViewSWT tv = id.equals("c") ? tvChosen : TableColumnSetupWindow.this.tvAvail;
                        Object[] objectArray = dataSources = tv.getSelectedDataSources().toArray();
                        int n = dataSources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object dataSource = objectArray[n2];
                            if (dataSource instanceof TableColumnCore) {
                                TableColumnCore column = (TableColumnCore)dataSource;
                                TableColumnSetupWindow.this.chooseColumn(column, destRow, true);
                                TableRowCore row = TableColumnSetupWindow.this.tvAvail.getRow(column);
                                if (row != null) {
                                    row.redraw();
                                }
                            }
                            ++n2;
                        }
                    }
                });
            }
        });
        tvChosen.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && (e.keyCode == 0x1000003 || e.keyCode == 127)) {
                    TableColumnSetupWindow.this.removeSelectedChosen();
                    e.doit = false;
                }
                if (e.stateMask == 262144) {
                    if (e.keyCode == 0x1000001) {
                        TableColumnSetupWindow.this.moveChosenUp();
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002) {
                        TableColumnSetupWindow.this.moveChosenDown();
                        e.doit = false;
                    }
                }
            }
        });
        return tvChosen;
    }

    private TableViewSWT<TableColumn> createTVAvail() {
        TableColumnCore[] columns;
        TableColumnManager tcm = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapColumns = tcm.getTableColumnsAsMap(TableColumn.class, TABLEID_AVAIL);
        int[] widths = new int[]{405, 105};
        if (this.sampleRow == null) {
            columns = new TableColumnCore[]{mapColumns.get("TableColumnNameInfo")};
            widths = new int[]{510};
        } else {
            columns = new TableColumnCore[]{mapColumns.get("TableColumnNameInfo"), mapColumns.get("TableColumnSample")};
        }
        int i = 0;
        while (i < columns.length) {
            TableColumnCore column = columns[i];
            if (column != null) {
                column.setVisible(true);
                column.setPositionNoShift(i);
                column.setWidth(widths[i]);
            }
            ++i;
        }
        final TableViewSWT<TableColumn> tvAvail = TableViewFactory.createTableViewSWT(TableColumn.class, TABLEID_AVAIL, TABLEID_AVAIL, columns, "TableColumnNameInfo", 0x10010004);
        tvAvail.setParentDataSource(this);
        tvAvail.setMenuEnabled(false);
        tvAvail.setRowDefaultHeightEM(5.0f);
        tvAvail.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
                if (eventType == 0) {
                    this.tableViewInitialized();
                }
            }

            private void tableViewInitialized() {
                DragSource dragSource = tvAvail.createDragSource(7);
                dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dragSource.setData("tv", (Object)tvAvail);
                dragSource.addDragListener(TableColumnSetupWindow.this.dragSourceListener);
                DropTarget dropTarget = tvAvail.createDropTarget(31);
                dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void drop(DropTargetEvent event2) {
                        String id = (String)event2.data;
                        if (!id.equals("c")) {
                            return;
                        }
                        TableColumnSetupWindow.this.removeSelectedChosen();
                    }
                });
            }
        });
        tvAvail.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                int i = 0;
                while (i < rows.length) {
                    TableRowCore row = rows[i];
                    TableColumnCore column = (TableColumnCore)row.getDataSource();
                    TableColumnSetupWindow.this.chooseColumn(column, null, false);
                    ++i;
                }
            }
        }, false);
        tvAvail.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0) {
                    if (e.keyCode == 0x1000004) {
                        TableRowCore[] selectedRows = tvAvail.getSelectedRows();
                        int i = 0;
                        while (i < selectedRows.length) {
                            TableRowCore row = selectedRows[i];
                            TableColumnCore column = (TableColumnCore)row.getDataSource();
                            TableColumnSetupWindow.this.chooseColumn(column, null, false);
                            TableColumnSetupWindow.this.tvChosen.processDataSourceQueue();
                            row.redraw();
                            ++i;
                        }
                        e.doit = false;
                    } else if (e.keyCode == 0x1000003) {
                        TableRowCore[] selectedRows = tvAvail.getSelectedRows();
                        int i = 0;
                        while (i < selectedRows.length) {
                            TableRowCore row = selectedRows[i];
                            TableColumnCore column = (TableColumnCore)row.getDataSource();
                            TableColumnSetupWindow.this.mapNewVisibility.put(column, Boolean.FALSE);
                            TableColumnSetupWindow.this.tvChosen.removeDataSource(column);
                            TableColumnSetupWindow.this.tvChosen.processDataSourceQueue();
                            row.redraw();
                            ++i;
                        }
                        e.doit = false;
                    }
                }
            }
        });
        return tvAvail;
    }

    public void open() {
        this.shell.open();
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }

    @Override
    public void updateUI() {
        if (this.shell.isDisposed()) {
            UIUpdaterSWT.getInstance().removeUpdater(this);
            return;
        }
        if (this.tvAvail != null && !this.tvAvail.isDisposed()) {
            this.tvAvail.refreshTable(false);
        }
        if (this.tvChosen != null && !this.tvChosen.isDisposed()) {
            this.tvChosen.refreshTable(false);
        }
    }

    public TableRow getSampleRow() {
        return this.sampleRow;
    }

    public void chooseColumn(TableColumnCore column) {
        this.chooseColumn(column, null, false);
        TableRowCore row = this.tvAvail.getRow(column);
        if (row != null) {
            row.redraw();
        }
    }

    public boolean isColumnAdded(TableColumnCore column) {
        if (this.tvChosen == null) {
            return false;
        }
        TableRowCore row = this.tvChosen.getRow(column);
        return row != null;
    }

    public void chooseColumn(TableColumnCore column, TableRowCore placeAboveRow, boolean ignoreExisting) {
        TableRowCore row = this.tvChosen.getRow(column);
        if (row == null || ignoreExisting) {
            int newPosition = 0;
            TableRowCore tableRowCore = row = placeAboveRow == null && !ignoreExisting ? this.tvChosen.getFocusedRow() : placeAboveRow;
            if (row == null || row.getDataSource() == null) {
                if (this.columnsCurrentOrder.length > 0) {
                    newPosition = this.columnsCurrentOrder.length;
                }
            } else {
                newPosition = ((TableColumn)row.getDataSource()).getPosition();
            }
            column.setPositionNoShift(newPosition);
            TableColumnCore[] tableColumnCoreArray = this.columnsCurrentOrder;
            int n = this.columnsCurrentOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int pos;
                TableColumnCore col = tableColumnCoreArray[n2];
                if (col != column && (pos = col.getPosition()) >= newPosition) {
                    col.setPositionNoShift(pos + 1);
                }
                ++n2;
            }
            Arrays.sort(this.columnsCurrentOrder, TableColumnManager.getTableColumnOrderComparator());
            int i = 0;
            while (i < this.columnsCurrentOrder.length) {
                this.columnsCurrentOrder[i].setPositionNoShift(i);
                ++i;
            }
            this.mapNewVisibility.put(column, Boolean.TRUE);
            TableRowCore existingRow = this.tvChosen.getRow(column);
            if (existingRow == null) {
                this.tvChosen.addDataSource(column);
                this.tvChosen.processDataSourceQueueSync();
                TableRowCore thisRow = this.tvChosen.getRow(column);
                if (thisRow != null) {
                    Utils.execSWTThreadLater(1, () -> {
                        this.tvChosen.setSelectedRows(new TableRowCore[]{thisRow});
                        this.tvChosen.showRow(thisRow);
                    });
                }
            }
            this.tvChosen.tableInvalidate();
            this.tvChosen.refreshTable(true);
            this.setHasChanges(true);
        } else {
            row.setSelected(true);
        }
    }

    private void close() {
        if (this.apply) {
            this.apply();
        } else {
            int i = 0;
            while (i < this.columnsOriginalOrder.length) {
                TableColumnCore column = this.columnsOriginalOrder[i];
                if (column != null) {
                    column.setPositionNoShift(i);
                }
                ++i;
            }
        }
        if (this.tvAvail != null) {
            this.tvAvail.delete();
        }
        if (this.tvChosen != null) {
            this.tvChosen.delete();
        }
    }
}

