/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.columnsetup;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellVisibilityListener;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.FakeTableCell;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ColumnTC_Sample
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final String COLUMN_ID = "TableColumnSample";

    public ColumnTC_Sample(String tableID) {
        super(COLUMN_ID, tableID);
        this.setPosition(-1);
        this.setRefreshInterval(-2);
        this.setWidth(120);
    }

    @Override
    public void cellAdded(final TableCell cell) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (cell.isDisposed()) {
                    return;
                }
                TableColumnCore column = (TableColumnCore)cell.getDataSource();
                TableViewSWT tv = (TableViewSWT)((TableCellCore)cell).getTableRowCore().getView();
                TableColumnSetupWindow tvs = (TableColumnSetupWindow)tv.getParentDataSource();
                TableRowCore sampleRow = (TableRowCore)tvs.getSampleRow();
                cell.addListeners(new Cell(cell, column, tv.getTableComposite(), sampleRow));
            }
        });
    }

    @Override
    public int compare(TableRowCore arg0, TableRowCore arg1) {
        return arg0.getIndex() - arg1.getIndex();
    }

    private static class Cell
    implements TableCellRefreshListener,
    TableCellSWTPaintListener,
    TableCellVisibilityListener,
    TableCellDisposeListener {
        private final TableColumnCore column;
        private FakeTableCell sampleCell;

        public Cell(TableCell parentCell, TableColumnCore column, Composite c, TableRowCore sampleRow) {
            this.column = column;
            if (sampleRow == null) {
                return;
            }
            Object ds = sampleRow.getDataSource(true);
            Object pds = sampleRow.getDataSource(false);
            if (column.handlesDataSourceType(pds.getClass())) {
                this.sampleCell = new FakeTableCell(column, ds);
                Rectangle bounds = ((TableCellSWT)parentCell).getBounds();
                this.sampleCell.setControl(c, bounds, false);
            }
        }

        @Override
        public void dispose(TableCell cell) {
            this.sampleCell = null;
        }

        @Override
        public void cellPaint(GC gc, TableCellSWT cell) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            Rectangle bounds = cell.getBounds();
            sampleCell.setCellArea(bounds);
            try {
                sampleCell.refresh();
                sampleCell.doPaint(gc);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        @Override
        public void cellVisibilityChanged(TableCell cell, int visibility) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            try {
                this.column.invokeCellVisibilityListeners(sampleCell, visibility);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        @Override
        public void refresh(TableCell cell) {
            FakeTableCell sampleCell = this.sampleCell;
            if (sampleCell == null) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            sampleCell.refresh(true, true, true);
            cell.setSortValue(sampleCell.getSortValue());
            cell.invalidate();
            if (cell instanceof TableCellSWT) {
                ((TableCellSWT)cell).redraw();
            }
        }
    }
}

