/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class PeersSuperView
extends PeersViewBase
implements GlobalManagerListener,
DownloadManagerPeerListener {
    public static final String VIEW_ID = "AllPeersView";
    private boolean active_listener = true;

    public PeersSuperView() {
        super(VIEW_ID, true);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        this.initYourTableView("AllPeers");
        return this.tv;
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        super.tableLifeCycleEventOccurred(tv, eventType, data);
        switch (eventType) {
            case 0: {
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        PeersSuperView.this.registerGlobalManagerListener(core);
                    }
                });
                break;
            }
            case 1: {
                this.unregisterListeners();
            }
        }
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.addPeer(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.removePeer(removed);
    }

    private void addExistingDatasources(Core core) {
        if (this.tv.isDisposed()) {
            return;
        }
        ArrayList<PEPeer> sources = new ArrayList<PEPeer>();
        Iterator<DownloadManager> itr = core.getGlobalManager().getDownloadManagers().iterator();
        while (itr.hasNext()) {
            PEPeer[] peers = itr.next().getCurrentPeers();
            if (peers == null) continue;
            sources.addAll(Arrays.asList(peers));
        }
        if (sources.isEmpty()) {
            return;
        }
        this.addPeers(sources.toArray(new PEPeer[sources.size()]));
        this.tv.processDataSourceQueue();
    }

    private void registerGlobalManagerListener(Core core) {
        this.active_listener = false;
        try {
            core.getGlobalManager().addListener(this);
        }
        finally {
            this.active_listener = true;
        }
        this.addExistingDatasources(core);
    }

    private void unregisterListeners() {
        try {
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this);
            for (DownloadManager dm : gm.getDownloadManagers()) {
                this.downloadManagerRemoved(dm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        dm.addPeerListener(this, !this.active_listener);
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePeerListener(this);
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    @Override
    protected void updateSelectedContent() {
    }
}

