/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDownload;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.download.Download;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.util.DataSourceUtils;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class MyTorrentsSubView
extends MyTorrentsView
implements ViewTitleInfo {
    public static final String MSGID_PREFIX = "MyTorrentsSubView";
    private Button btnAnyTags;
    private boolean anyTorrentTags;
    private boolean destroyed;
    private Tag[] tempTags;

    public MyTorrentsSubView() {
        super(MSGID_PREFIX, false);
        this.neverShowCatButtons = true;
        this.neverShowTagButtons = true;
        this.isEmptyListOnNullDS = true;
        Core _core = CoreFactory.getSingleton();
        this.init(_core, MSGID_PREFIX, Download.class, TableColumnCreator.createCompleteDM(MSGID_PREFIX));
    }

    @Override
    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        Composite cTop = new Composite(parent, 0);
        GridData gd = new GridData(4, 1, true, false);
        cTop.setLayoutData((Object)gd);
        cTop.setLayout((Layout)new FormLayout());
        this.btnAnyTags = new Button(cTop, 32);
        Messages.setLanguageText((Widget)this.btnAnyTags, "TorrentTags.Button.Any");
        this.btnAnyTags.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("TorrentTags.Any", !MyTorrentsSubView.this.anyTorrentTags);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.anyTorrentTags = COConfigurationManager.getBooleanParameter("TorrentTags.Any");
        this.btnAnyTags.setSelection(this.anyTorrentTags);
        this.setCurrentTagsAny(this.anyTorrentTags);
        this.updateButtonVisibility(this.getCurrentTags());
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        tableParent.setLayout((Layout)gridLayout);
        parent.setTabList(new Control[]{tableParent, cTop});
        return tableParent;
    }

    @Override
    public TableViewSWT<DownloadManager> initYourTableView() {
        if (this.destroyed) {
            this.destroyed = false;
            Core _core = CoreFactory.getSingleton();
            this.init(_core, MSGID_PREFIX, Download.class, TableColumnCreator.createCompleteDM(MSGID_PREFIX));
        }
        return super.initYourTableView();
    }

    @Override
    public void tableViewInitialized() {
        this.anyTorrentTags = COConfigurationManager.getBooleanParameter("TorrentTags.Any");
        COConfigurationManager.addParameterListener("TorrentTags.Any", (ParameterListener)this);
        super.tableViewInitialized();
    }

    @Override
    public void tableViewDestroyed() {
        COConfigurationManager.removeParameterListener("TorrentTags.Any", this);
        super.tableViewDestroyed();
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        if (event2.getType() == 7) {
            this.destroyed = true;
        }
        return super.eventOccurred(event2);
    }

    @Override
    public void parameterChanged(String parameterName) {
        if ("TorrentTags.Any".equals(parameterName)) {
            this.anyTorrentTags = COConfigurationManager.getBooleanParameter(parameterName);
            if (this.btnAnyTags != null && !this.btnAnyTags.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (MyTorrentsSubView.this.btnAnyTags != null && !MyTorrentsSubView.this.btnAnyTags.isDisposed()) {
                            MyTorrentsSubView.this.btnAnyTags.setSelection(MyTorrentsSubView.this.anyTorrentTags);
                        }
                    }
                });
            }
            this.setCurrentTagsAny(this.anyTorrentTags);
        }
        super.parameterChanged(parameterName);
    }

    @Override
    protected void setCurrentTags(Tag ... tags) {
        super.setCurrentTags(tags);
        ViewTitleInfoManager.refreshTitleInfo(this);
        this.updateButtonVisibility(tags);
    }

    @Override
    public void parentDataSourceChanged(Object newParentDataSource) {
        super.parentDataSourceChanged(newParentDataSource);
        if (this.getTableView() == null) {
            this.tempTags = DataSourceUtils.getTags(newParentDataSource);
            ViewTitleInfoManager.refreshTitleInfo(this);
        } else {
            this.tempTags = null;
        }
    }

    private void updateButtonVisibility(final Tag[] tags) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (MyTorrentsSubView.this.btnAnyTags == null || MyTorrentsSubView.this.btnAnyTags.isDisposed()) {
                    return;
                }
                boolean show = tags != null && tags.length > 1;
                MyTorrentsSubView.this.btnAnyTags.setVisible(show);
                FormData fd = Utils.getFilledFormData();
                fd.height = show ? -1 : 0;
                MyTorrentsSubView.this.btnAnyTags.setLayoutData((Object)fd);
                Composite cTop = MyTorrentsSubView.this.btnAnyTags.getParent();
                cTop.getParent().layout(true, true);
            }
        });
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 0) {
            Tag tag;
            Tag[] tags;
            Tag[] tagArray = tags = this.tempTags == null ? this.getCurrentTags() : this.tempTags;
            if (tags == null || tags.length == 0) {
                return null;
            }
            DownloadManager[] dms = DataSourceUtils.getDMs(tags);
            if (dms.length == 0) {
                return null;
            }
            Set<DownloadManager> minTaggedDownloads = null;
            Tag[] tagArray2 = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag value = tagArray2[n2];
                if (value instanceof TagDownload) {
                    tag = (TagDownload)value;
                    Set<DownloadManager> taggedDownloads = tag.getTaggedDownloads();
                    if (minTaggedDownloads == null || minTaggedDownloads.size() > taggedDownloads.size()) {
                        minTaggedDownloads = taggedDownloads;
                    }
                }
                ++n2;
            }
            int count = 0;
            for (DownloadManager dm : minTaggedDownloads) {
                boolean hasAll = true;
                Tag[] tagArray3 = tags;
                int n3 = tags.length;
                int n4 = 0;
                while (n4 < n3) {
                    tag = tagArray3[n4];
                    if (!tag.hasTaggable(dm)) {
                        hasAll = false;
                        break;
                    }
                    ++n4;
                }
                if (!hasAll) continue;
                ++count;
            }
            return count == dms.length ? "" + count : String.valueOf(dms.length) + " | " + count;
        }
        return null;
    }
}

