/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadManager;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareItem;
import com.biglybt.pif.sharing.ShareManager;
import com.biglybt.pif.sharing.ShareManagerListener;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.sharing.ShareResourceDir;
import com.biglybt.pif.sharing.ShareResourceDirContents;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.tracker.Tracker;
import com.biglybt.pif.tracker.TrackerTorrent;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.torrent.TorrentManagerImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableGroupRowRunner;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRefreshListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionAdapter;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.FixedHTMLTransfer;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.sharing.ShareUtils;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.impl.TableViewTab;
import com.biglybt.ui.swt.views.tableitems.myshares.CategoryItem;
import com.biglybt.ui.swt.views.tableitems.myshares.NameItem;
import com.biglybt.ui.swt.views.tableitems.myshares.PersistentItem;
import com.biglybt.ui.swt.views.tableitems.myshares.TagsItem;
import com.biglybt.ui.swt.views.tableitems.myshares.TypeItem;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MySharesView
extends TableViewTab<ShareResource>
implements ShareManagerListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableSelectionListener,
ViewTitleInfo2,
UIPluginViewToolBarListener,
UISWTViewCoreEventListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem(), new TagsItem(), new PersistentItem()};
    protected static final TorrentAttribute category_attribute;
    private TableViewSWT<ShareResource> tv = TableViewFactory.createTableViewSWT(ShareResource.class, "MyShares", this.getPropertiesPrefix(), basicItems, "name", 268503042);

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("MyShares", basicItems);
        category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    }

    public MySharesView() {
        super("MySharesView");
        this.tv.addSelectionListener(new TableSelectionAdapter(){

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                MySharesView.this.defaultSelected(rows);
            }
        }, false);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        this.tv.addSelectionListener(this, false);
    }

    @Override
    public TableViewSWT initYourTableView() {
        return this.tv;
    }

    private void defaultSelected(TableRowCore[] rows) {
        ShareResource share = (ShareResource)this.tv.getFirstSelectedDataSource();
        if (share == null) {
            return;
        }
        List<com.biglybt.core.download.DownloadManager> dms = CoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        int i = 0;
        while (i < dms.size()) {
            com.biglybt.core.download.DownloadManager dm = dms.get(i);
            try {
                byte[] share_hash = null;
                if (share.getType() == 2) {
                    share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                } else if (share.getType() == 1) {
                    share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                }
                if (Arrays.equals(share_hash, dm.getTorrent().getHash())) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions == null) break;
                    uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                    break;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        switch (eventType) {
            case 0: {
                this.tableViewInitialized();
                break;
            }
            case 1: {
                this.tableViewDestroyed();
            }
        }
    }

    private void tableViewInitialized() {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                MySharesView.this.createRows(core);
            }
        });
        DropTarget dropTarget = this.tv.createDropTarget(31);
        if (dropTarget != null) {
            dropTarget.setTransfer(new Transfer[]{FixedHTMLTransfer.getInstance(), FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void drop(DropTargetEvent event2) {
                    if (!MySharesView.this.share(event2.data)) {
                        TorrentOpener.openDroppedTorrents(event2, true);
                    }
                }
            });
        }
    }

    protected boolean share(Object eventData) {
        boolean shared = false;
        if (eventData instanceof String[] || eventData instanceof String) {
            String[] stringArray;
            if (eventData instanceof String[]) {
                stringArray = (String[])eventData;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)eventData;
            }
            String[] sourceNames = stringArray;
            if (sourceNames == null) {
                return false;
            }
            int i = 0;
            while (i < sourceNames.length) {
                File source = new File(sourceNames[i]);
                String filename = source.getAbsolutePath();
                try {
                    if (source.isFile() && !TorrentUtils.isTorrentFile(filename)) {
                        ShareUtils.shareFile(filename);
                        shared = true;
                    } else if (source.isDirectory()) {
                        ShareUtils.shareDir(filename);
                        shared = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return shared;
    }

    private void tableViewDestroyed() {
        try {
            PluginInitializer.getDefaultInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createRows(Core core) {
        try {
            ShareManager sm = core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            int i = 0;
            while (i < shares.length) {
                this.resourceAdded(shares[i]);
                ++i;
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        Menu menuTags = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemTags = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemTags, "label.tags");
        itemTags.setMenu(menuTags);
        MenuItem itemAddTag = new MenuItem(menuTags, 8);
        Messages.setLanguageText((Widget)itemAddTag, "label.add.tag");
        itemAddTag.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(final Tag[] tags) {
                        if (tags != null) {
                            MySharesView.this.tv.runForSelectedRows(new TableGroupRowRunner(){

                                @Override
                                public void run(TableRowCore row) {
                                    int n;
                                    ShareResource sr = (ShareResource)row.getDataSource(true);
                                    Map<String, String> props = sr.getProperties();
                                    props = props == null ? new HashMap<String, String>() : new HashMap<String, String>(props);
                                    String tag_str = props.get("tags");
                                    HashSet<String> existing = new HashSet<String>();
                                    if (tag_str == null) {
                                        tag_str = "";
                                    } else {
                                        String[] bits;
                                        String[] stringArray = bits = tag_str.split(",");
                                        int n2 = bits.length;
                                        n = 0;
                                        while (n < n2) {
                                            String bit = stringArray[n];
                                            existing.add(bit.trim());
                                            ++n;
                                        }
                                    }
                                    Tag[] tagArray = tags;
                                    n = tags.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        Tag t = tagArray[n3];
                                        String uid = String.valueOf(t.getTagUID());
                                        if (!existing.contains(uid)) {
                                            tag_str = String.valueOf(tag_str) + (tag_str.isEmpty() ? "" : ",") + uid;
                                        }
                                        ++n3;
                                    }
                                    props.put("tags", tag_str);
                                    sr.setProperties(props, false);
                                }
                            });
                        }
                    }
                });
            }
        });
        MenuItem itemTagsSelect = new MenuItem(menuTags, 8);
        itemTagsSelect.setText(String.valueOf(MessageText.getString("label.select.tags")) + "...");
        itemTagsSelect.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                String tags;
                Map<String, String> properties;
                TagManager tagManager = TagManagerFactory.getTagManager();
                TagType tt = tagManager.getTagType(3);
                ArrayList<Tag> all_tags = new ArrayList<Tag>(tt.getTags());
                List<Object> selected = MySharesView.this.tv.getSelectedDataSources();
                ArrayList<Tag> selected_tags = new ArrayList<Tag>();
                if (selected.size() == 1 && selected.get(0) instanceof ShareResource && (properties = ((ShareResource)selected.get(0)).getProperties()) != null && (tags = properties.get("tags")) != null) {
                    String[] bits;
                    String[] stringArray = bits = tags.split(",");
                    int n = bits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bit = stringArray[n2];
                        if (!(bit = bit.trim()).isEmpty()) {
                            try {
                                long uid = Long.parseLong(bit);
                                Tag tag = tagManager.lookupTagByUID(uid);
                                if (tag != null) {
                                    selected_tags.add(tag);
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        ++n2;
                    }
                }
                TagUIUtilsV3.showTagSelectionDialog(all_tags, selected_tags, new TagUIUtilsV3.TagSelectionListener(){

                    @Override
                    public void selected(List<Tag> tags) {
                        String tags_str = "";
                        for (Tag t : tags) {
                            tags_str = String.valueOf(tags_str) + (tags_str.isEmpty() ? "" : ",") + t.getTagUID();
                        }
                        final String f = tags_str;
                        MySharesView.this.tv.runForSelectedRows(new TableGroupRowRunner(){

                            @Override
                            public void run(TableRowCore row) {
                                ShareResource sr = (ShareResource)row.getDataSource(true);
                                Map<String, String> props = sr.getProperties();
                                props = props == null ? new HashMap<String, String>() : new HashMap<String, String>(props);
                                props.put("tags", f);
                                sr.setProperties(props, false);
                            }
                        });
                    }
                });
            }
        });
        Menu menuCategory = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(menuCategory);
        this.addCategorySubMenu(menuCategory);
        new MenuItem(menu, 2);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        itemRemove.setEnabled(shares.length > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void resourceAdded(ShareResource resource) {
        this.tv.addDataSource(resource);
    }

    @Override
    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.tv.removeDataSource(old_resource);
        this.tv.addDataSource(new_resource);
    }

    @Override
    public void resourceDeleted(ShareResource resource) {
        this.tv.removeDataSource(resource);
    }

    @Override
    public void reportProgress(int percent_complete) {
    }

    @Override
    public void reportCurrentTask(String task_description) {
    }

    @Override
    public void tableRefresh() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void addCategorySubMenu(Menu menuCategory) {
        MenuItem[] items = menuCategory.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(menuCategory, 2);
            }
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    itemCategory = new MenuItem(menuCategory, 8);
                    itemCategory.setText(categories[i].getName());
                    itemCategory.setData("Category", categories[i]);
                    TagUIUtils.setMenuIcon(itemCategory, (Tag)categories[i]);
                    itemCategory.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            MenuItem item = (MenuItem)event2.widget;
                            MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                        }
                    });
                }
                ++i;
            }
            new MenuItem(menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MySharesView.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryUIUtils.showCreateCategoryDialog(new UIFunctions.TagReturner(){

            @Override
            public void returnedTags(Tag[] tags) {
                if (tags.length == 1 && tags[0] instanceof Category) {
                    MySharesView.this.assignSelectedToCategory((Category)tags[0]);
                }
            }
        });
    }

    private void assignSelectedToCategory(final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            @Override
            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        boolean start = false;
        boolean stop = false;
        boolean remove = false;
        if (!CoreFactory.isCoreRunning()) {
            return;
        }
        List items = this.getSelectedItems();
        if (items.size() > 0) {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            DownloadManager dm = pi.getDownloadManager();
            remove = true;
            int i = 0;
            while (i < items.size()) {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    Download download = dm.getDownload(t);
                    if (download != null && (dl_state = download.getState()) != 8) {
                        if (dl_state != 7) {
                            stop = true;
                        } else {
                            start = true;
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        list.put("start", start ? 1L : 0L);
        list.put("stop", stop ? 1L : 0L);
        list.put("remove", remove ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return true;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedShares();
            return true;
        }
        if (itemKey.equals("start")) {
            this.startSelectedShares();
            return true;
        }
        return false;
    }

    private List getSelectedItems() {
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        ArrayList<ShareItem> items = new ArrayList<ShareItem>();
        if (shares.length > 0) {
            int i = 0;
            while (i < shares.length) {
                ShareResource sr;
                ShareResource share = (ShareResource)shares[i];
                int type = share.getType();
                if (type == 2) {
                    sr = (ShareResourceDir)share;
                    items.add(sr.getItem());
                } else if (type == 1) {
                    sr = (ShareResourceFile)share;
                    items.add(sr.getItem());
                } else {
                    ShareResourceDirContents cont = (ShareResourceDirContents)share;
                    ArrayList entries = new ArrayList();
                    this.getEntries(entries, cont);
                    int j = 0;
                    while (j < entries.size()) {
                        ShareResource sr2;
                        share = (ShareResource)entries.get(j);
                        type = share.getType();
                        if (type == 2) {
                            sr2 = (ShareResourceDir)share;
                            items.add(sr2.getItem());
                        } else if (type == 1) {
                            sr2 = (ShareResourceFile)share;
                            items.add(sr2.getItem());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return items;
    }

    private void getEntries(List entries, ShareResourceDirContents cont) {
        ShareResource[] kids = cont.getChildren();
        int i = 0;
        while (i < kids.length) {
            ShareResource share = kids[i];
            int type = share.getType();
            if (type == 3) {
                this.getEntries(entries, (ShareResourceDirContents)share);
            } else {
                entries.add(share);
            }
            ++i;
        }
    }

    private void startStopSelectedShares(boolean do_stop) {
        List items = this.getSelectedItems();
        if (items.size() == 0) {
            return;
        }
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        Tracker tracker = pi.getTracker();
        int i = 0;
        while (i < items.size()) {
            block15: {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    TrackerTorrent tracker_torrent = tracker.getTorrent(t);
                    Download download = dm.getDownload(t);
                    if (download == null || (dl_state = download.getState()) == 8) break block15;
                    if (dl_state != 7) {
                        if (!do_stop) break block15;
                        try {
                            download.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (tracker_torrent != null) {
                            try {
                                tracker_torrent.stop();
                            }
                            catch (Throwable throwable) {}
                        }
                        break block15;
                    }
                    if (do_stop) break block15;
                    try {
                        download.restart();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (tracker_torrent != null) {
                        try {
                            tracker_torrent.start();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
    }

    private void startSelectedShares() {
        this.startStopSelectedShares(false);
    }

    private void stopSelectedShares() {
        this.startStopSelectedShares(true);
    }

    private void removeSelectedShares() {
        this.stopSelectedShares();
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        int i = 0;
        while (i < shares.length) {
            try {
                ((ShareResource)shares[i]).delete();
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(shares[i], false, "{globalmanager.download.remove.veto}", e));
            }
            ++i;
        }
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        return null;
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
        mdiEntry.addListener(new MdiEntryDropListener(){

            @Override
            public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                return MySharesView.this.share(droppedObject);
            }
        });
    }
}

