/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pifimpl.UISWTInstanceImpl;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventCancelledException;
import com.biglybt.ui.swt.pifimpl.UISWTViewImpl;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class BarViewParent
extends SkinView {
    private final String view_id;
    private final String view_area;
    private final String so_area_plugins;
    private final String so_area_plugin;
    private final String so_line;
    private final String line_config_id;
    private final boolean is_vertical;
    private SWTSkin skin;
    private Composite cPluginsArea;
    private UISWTInstanceImpl.SWTViewListener swtViewListener;
    private final List<UISWTViewImpl> pluginViews = new ArrayList<UISWTViewImpl>();
    Point dragPosition;
    List<Control> hookedControls = new ArrayList<Control>();
    Map<Control, List<Integer>> modifiedControls = new HashMap<Control, List<Integer>>();
    Point paintDragPosition = null;
    PaintListener dragPainter = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Control c = (Control)e.widget;
            Point controlPosition = c.toControl(BarViewParent.this.paintDragPosition == null ? BarViewParent.this.dragPosition : BarViewParent.this.paintDragPosition);
            BarViewParent.this.paintDragPosition = null;
            int relPosition = Integer.MIN_VALUE;
            if (BarViewParent.this.is_vertical) {
                if (controlPosition.x >= 0 && controlPosition.x <= c.getSize().x) {
                    relPosition = controlPosition.x;
                }
            } else if (controlPosition.y >= 0 && controlPosition.y <= c.getSize().y) {
                relPosition = controlPosition.y;
            }
            if (relPosition != Integer.MIN_VALUE) {
                GC gc = e.gc;
                Color old = gc.getForeground();
                gc.setForeground(Colors.grey);
                if (BarViewParent.this.is_vertical) {
                    gc.drawLine(relPosition, 0, relPosition, c.getBounds().height);
                } else {
                    gc.drawLine(0, relPosition, c.getBounds().width, relPosition);
                }
                gc.setForeground(old);
                List<Integer> list = BarViewParent.this.modifiedControls.get(c);
                if (list == null) {
                    list = new ArrayList<Integer>();
                    BarViewParent.this.modifiedControls.put(c, list);
                }
                list.add(relPosition);
            }
        }
    };
    boolean update_outstanding = false;

    protected BarViewParent(String _view_id, String _view_area, String _so_area_plugins, String _so_area_plugin, String _so_line, String _line_config_id, boolean _is_vertical) {
        this.view_id = _view_id;
        this.view_area = _view_area;
        this.so_area_plugins = _so_area_plugins;
        this.so_area_plugin = _so_area_plugin;
        this.so_line = _so_line;
        this.line_config_id = _line_config_id;
        this.is_vertical = _is_vertical;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.skin.addListener(this.so_area_plugins, new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    BarViewParent.this.skin.removeListener(BarViewParent.this.so_area_plugins, this);
                    CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                        @Override
                        public void coreRunning(Core core) {
                            Utils.execSWTThreadLater(0, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    BarViewParent.this.buildViews();
                                }
                            });
                        }
                    });
                }
                return null;
            }
        });
        this.skin.getSkinObject(this.so_area_plugin).addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType != 0) {
                    // empty if block
                }
                return null;
            }
        });
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.swtViewListener != null) {
            try {
                ViewManagerSWT.getInstance().removeSWTViewListener(this.swtViewListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    protected void buildViews() {
        final SWTSkinObject rbObject = this.skin.getSkinObject(this.view_id);
        SWTSkinObject pluginObject = this.skin.getSkinObject(this.so_area_plugins);
        this.cPluginsArea = (Composite)pluginObject.getControl();
        final Control rbControl = rbObject.getControl();
        SWTSkinObject lineObject = this.skin.getSkinObject(this.so_line);
        final Control lineControl = lineObject.getControl();
        lineControl.addPaintListener(ev -> {
            GC gc = ev.gc;
            Color fg = Colors.getSystemColor((Device)lineControl.getDisplay(), 18);
            boolean dark = Utils.isDarkAppearanceNative();
            if (dark) {
                if (Constants.isWindows) {
                    fg = Colors.getSystemColor((Device)lineControl.getDisplay(), 19);
                } else if (Constants.isLinux) {
                    fg = ColorCache.getColor((Device)lineControl.getDisplay(), 96, 96, 96);
                }
            }
            gc.setForeground(fg);
            if (this.is_vertical) {
                gc.drawLine(2, 0, 2, control.getSize().y);
                if (dark) {
                    gc.drawLine(1, 0, 1, control.getSize().y);
                }
            } else {
                if (dark) {
                    gc.drawLine(0, 1, control.getSize().x, 1);
                }
                gc.drawLine(0, 2, control.getSize().x, 2);
            }
        });
        Listener l = new Listener(){
            private int mouseDownAt = -1;
            boolean hooked;

            public void handleEvent(Event event2) {
                try {
                    if (event2.type == 3) {
                        this.mouseDownAt = BarViewParent.this.is_vertical ? event2.x : event2.y;
                    } else if (event2.type == 4 && this.mouseDownAt >= 0) {
                        if (BarViewParent.this.is_vertical) {
                            int diff = this.mouseDownAt - event2.x;
                            this.mouseDownAt = -1;
                            FormData formData = (FormData)rbControl.getLayoutData();
                            formData.width += diff;
                            if (formData.width < 50) {
                                formData.width = 50;
                            }
                            COConfigurationManager.setParameter(BarViewParent.this.line_config_id, formData.width);
                        } else {
                            int diff = this.mouseDownAt - event2.y;
                            this.mouseDownAt = -1;
                            FormData formData = (FormData)rbControl.getLayoutData();
                            formData.height -= diff;
                            if (formData.height < 50) {
                                formData.height = 50;
                            }
                            COConfigurationManager.setParameter(BarViewParent.this.line_config_id, formData.height);
                        }
                        Utils.relayout(rbControl);
                    } else if (event2.type == 5) {
                        lineControl.setCursor(lineControl.getDisplay().getSystemCursor(BarViewParent.this.is_vertical ? 9 : 7));
                    } else if (event2.type == 7) {
                        lineControl.setCursor(null);
                        this.mouseDownAt = -1;
                    }
                }
                finally {
                    BarViewParent.this.dragPosition = this.mouseDownAt != -1 ? lineControl.toDisplay(new Point(event2.x, event2.y)) : null;
                    if (this.mouseDownAt == -1 && this.hooked) {
                        BarViewParent.this.hookControls(rbControl, false);
                        this.hooked = false;
                    } else if (this.mouseDownAt != -1 && !this.hooked) {
                        BarViewParent.this.hookControls(rbControl, true);
                        this.hooked = true;
                    }
                    if (this.hooked) {
                        BarViewParent.this.updateHookedControls();
                    }
                }
            }
        };
        lineControl.addListener(3, l);
        lineControl.addListener(4, l);
        lineControl.addListener(5, l);
        lineControl.addListener(7, l);
        rbObject.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    int dim = COConfigurationManager.getIntParameter(BarViewParent.this.line_config_id);
                    Control control = rbObject.getControl();
                    FormData formData = (FormData)control.getLayoutData();
                    if (BarViewParent.this.is_vertical) {
                        formData.width = dim;
                    } else {
                        formData.height = dim;
                    }
                    control.setLayoutData((Object)formData);
                    Utils.relayout(control);
                }
                return null;
            }
        });
        this.createBarPluginViews();
        rbControl.getParent().layout(true);
    }

    private void updateHookedControls() {
        if (this.dragPosition == null || this.update_outstanding) {
            return;
        }
        this.update_outstanding = true;
        Utils.execSWTThreadLater(0, () -> {
            this.update_outstanding = false;
            this.paintDragPosition = this.dragPosition;
            for (Control c : this.hookedControls) {
                if (c.isDisposed()) continue;
                List<Integer> list = this.modifiedControls.remove(c);
                Point controlPosition = c.toControl(this.dragPosition);
                int relPosition = Integer.MIN_VALUE;
                if (this.is_vertical) {
                    if (controlPosition.x >= 0 && controlPosition.x <= c.getSize().x) {
                        relPosition = controlPosition.x;
                    }
                } else if (controlPosition.y >= 0 && controlPosition.y <= c.getSize().y) {
                    relPosition = controlPosition.y;
                }
                if (relPosition != Integer.MIN_VALUE) {
                    if (list == null) {
                        list = new ArrayList<Integer>();
                    }
                    list.add(0, relPosition);
                }
                if (list == null) continue;
                for (int pos : list) {
                    if (this.is_vertical) {
                        c.redraw(pos, 0, pos, c.getBounds().height, false);
                        continue;
                    }
                    c.redraw(0, pos, c.getBounds().width, pos, false);
                }
            }
            this.modifiedControls.clear();
        });
    }

    private void hookControls(Control control, boolean do_it) {
        if (do_it) {
            LinkedList<Control[]> controls = new LinkedList<Control[]>();
            controls.add(new Control[]{control.getShell()});
            while (!controls.isEmpty()) {
                Control[] kids;
                Control[] controlArray = kids = (Control[])controls.removeFirst();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    if (c instanceof Composite) {
                        controls.add(((Composite)c).getChildren());
                    }
                    if (c.isVisible() && !(c instanceof Shell)) {
                        c.addPaintListener(this.dragPainter);
                        this.hookedControls.add(c);
                        c.redraw();
                    }
                    ++n2;
                }
            }
        } else {
            for (Control c : this.hookedControls) {
                if (c.isDisposed()) continue;
                c.removePaintListener(this.dragPainter);
                c.redraw();
            }
            this.hookedControls.clear();
            this.modifiedControls.clear();
        }
    }

    private void createBarPluginViews() {
        if (this.cPluginsArea == null) {
            return;
        }
        List<UISWTViewBuilderCore> pluginViewBuilders = ViewManagerSWT.getInstance().getBuilders(this.view_area);
        for (UISWTViewBuilderCore builder : pluginViewBuilders) {
            if (builder == null) continue;
            try {
                UISWTViewImpl view = new UISWTViewImpl(builder, false);
                view.setDestroyOnDeactivate(false);
                this.addBarView(view, this.cPluginsArea);
                this.cPluginsArea.getParent().getParent().layout(true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.swtViewListener = new UISWTInstanceImpl.SWTViewListener(){

            @Override
            public void setViewRegistered(Object forDSTypeOrViewID, UISWTViewBuilderCore builder) {
                if (!BarViewParent.this.view_area.equals(forDSTypeOrViewID)) {
                    return;
                }
                Utils.execSWTThread(() -> {
                    try {
                        UISWTViewImpl view = new UISWTViewImpl(builder, false);
                        view.setDestroyOnDeactivate(false);
                        BarViewParent.this.addBarView(view, BarViewParent.this.cPluginsArea);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }

            @Override
            public void setViewDeregistered(Object forDSTypeOrViewID, UISWTViewBuilderCore builder) {
                if (!BarViewParent.this.view_area.equals(forDSTypeOrViewID)) {
                    return;
                }
                Utils.execSWTThread(() -> {
                    ArrayList views;
                    List list = BarViewParent.this.pluginViews;
                    synchronized (list) {
                        views = new ArrayList(BarViewParent.this.pluginViews);
                    }
                    for (UISWTViewImpl view : views) {
                        if (!builder.equals(view.getEventListenerBuilder())) continue;
                        BarViewParent.this.removeBarView(view);
                    }
                });
            }
        };
        ViewManagerSWT.getInstance().addSWTViewListener(this.swtViewListener);
        this.cPluginsArea.getParent().getParent().layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBarView(UISWTViewImpl view, Composite cPluginsArea) {
        List<UISWTViewImpl> list = this.pluginViews;
        synchronized (list) {
            this.pluginViews.add(view);
            try {
                view.create();
            }
            catch (UISWTViewEventCancelledException e) {
                this.pluginViews.remove(view);
                return;
            }
            if (this.pluginViews.size() > 0) {
                SWTSkinUtils.setVisibility(this.skin, String.valueOf(this.view_id) + ".visible", this.view_id, true, true);
            }
        }
        Utils.disposeComposite(cPluginsArea, false);
        Composite parent = new Composite(cPluginsArea, 0);
        parent.setLayoutData((Object)Utils.getFilledFormData());
        parent.setLayout((Layout)new FormLayout());
        view.initialize(parent);
        cPluginsArea.getParent().layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBarView(UISWTViewImpl view) {
        try {
            view.closeView();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        List<UISWTViewImpl> list = this.pluginViews;
        synchronized (list) {
            this.pluginViews.remove(view);
            if (this.pluginViews.isEmpty()) {
                SWTSkinUtils.setVisibility(this.skin, String.valueOf(this.view_id) + ".visible", this.view_id, false, true);
            }
        }
    }
}

