/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnFilterHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SearchSubsUtils {
    public static boolean addMenu(final SearchSubsResultBase result, Menu menu) {
        MenuItem item;
        final byte[] hash = result.getHash();
        if (hash != null) {
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("searchsubs.menu.google.hash"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String s = ByteFormatter.encodeString(hash);
                    String URL2 = "https://google.com/search?q=" + UrlUtils.encode(s);
                    SearchSubsUtils.launchURL(URL2);
                }
            });
        }
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.gis"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "http://images.google.com/images?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.google"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "https://google.com/search?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("searchsubs.menu.bis"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String s = result.getName();
                s = s.replaceAll("[-_]", " ");
                String URL2 = "http://www.bing.com/images/search?q=" + UrlUtils.encode(s);
                SearchSubsUtils.launchURL(URL2);
            }
        });
        com.biglybt.pif.ui.menus.MenuItem[] items = MenuItemManager.getInstance().getAllAsArray("subscription_result_context");
        if (items.length > 0) {
            MenuFactory.addSeparatorMenuItem(menu);
            MenuBuildUtils.addPluginMenuItems(items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new SearchSubsResultBase[]{result}));
        }
        return true;
    }

    public static void addMenu(final Subscription subs_maybe_null, final SearchSubsResultBase[] results, Menu menu) {
        boolean has_hash = false;
        boolean all_read = true;
        boolean all_unread = true;
        SearchSubsResultBase[] searchSubsResultBaseArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            SearchSubsResultBase result = searchSubsResultBaseArray[n2];
            byte[] hash = result.getHash();
            if (hash != null) {
                has_hash = true;
            }
            if (result.getRead()) {
                all_unread = false;
            } else {
                all_read = false;
            }
            ++n2;
        }
        MenuItem item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("MagnetPlugin.contextmenu.exporturi"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuffer buffer = new StringBuffer(1024);
                SearchSubsResultBase[] searchSubsResultBaseArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    SearchSubsResultBase result = searchSubsResultBaseArray[n2];
                    String torrent_link = result.getTorrentLink();
                    if (torrent_link != null && torrent_link.toLowerCase().startsWith("magnet:")) {
                        if (buffer.length() > 0) {
                            buffer.append("\r\n");
                        }
                        buffer.append(torrent_link);
                    } else {
                        byte[] hash = result.getHash();
                        if (hash != null) {
                            if (buffer.length() > 0) {
                                buffer.append("\r\n");
                            }
                            String str = UrlUtils.getMagnetURI(hash, result.getName(), null);
                            if (torrent_link != null) {
                                str = String.valueOf(str) + "&fl=" + UrlUtils.encode(torrent_link);
                            }
                            buffer.append(str);
                        }
                    }
                    ++n2;
                }
                ClipboardCopy.copyToClipBoard(buffer.toString());
            }
        });
        item.setEnabled(has_hash);
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("menu.mark.read"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (subs_maybe_null == null || results.length == 1) {
                    SearchSubsResultBase[] searchSubsResultBaseArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchSubsResultBase result = searchSubsResultBaseArray[n2];
                        result.setRead(true);
                        ++n2;
                    }
                } else {
                    String[] ids = new String[results.length];
                    boolean[] read = new boolean[ids.length];
                    Arrays.fill(read, true);
                    int i = 0;
                    while (i < ids.length) {
                        ids[i] = results[i].getID();
                        ++i;
                    }
                    subs_maybe_null.getHistory().markResults(ids, read);
                }
            }
        });
        item.setEnabled(!all_read);
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("menu.mark.read.in.all"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (subs_maybe_null == null || results.length == 1) {
                    SearchSubsResultBase[] searchSubsResultBaseArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchSubsResultBase result = searchSubsResultBaseArray[n2];
                        result.setRead(true);
                        ++n2;
                    }
                } else {
                    String[] ids = new String[results.length];
                    boolean[] read = new boolean[ids.length];
                    Arrays.fill(read, true);
                    int i = 0;
                    while (i < ids.length) {
                        ids[i] = results[i].getID();
                        ++i;
                    }
                    subs_maybe_null.getHistory().markResults(ids, read);
                }
                Utils.getOffOfSWTThread(() -> SubscriptionManagerFactory.getSingleton().markReadInAllSubscriptions(results));
            }
        });
        item.setEnabled(!all_read);
        item = new MenuItem(menu, 8);
        item.setText(MessageText.getString("menu.mark.unread"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (subs_maybe_null == null || results.length == 1) {
                    SearchSubsResultBase[] searchSubsResultBaseArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchSubsResultBase result = searchSubsResultBaseArray[n2];
                        result.setRead(false);
                        ++n2;
                    }
                } else {
                    String[] ids = new String[results.length];
                    boolean[] read = new boolean[ids.length];
                    Arrays.fill(read, false);
                    int i = 0;
                    while (i < ids.length) {
                        ids[i] = results[i].getID();
                        ++i;
                    }
                    subs_maybe_null.getHistory().markResults(ids, read);
                }
            }
        });
        item.setEnabled(!all_unread);
    }

    private static void launchURL(String s) {
        Program program = Program.findProgram((String)".html");
        if (program != null && program.getName().contains("Chrome")) {
            try {
                Field field = Program.class.getDeclaredField("command");
                field.setAccessible(true);
                String command = (String)field.get(program);
                command = command.replaceAll("%[1lL]", Matcher.quoteReplacement(s));
                command = command.replace(" --", "");
                PluginInitializer.getDefaultInterface().getUtilities().createProcess(String.valueOf(command) + " -incognito");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Utils.launch(s);
            }
        } else {
            Utils.launch(s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends SearchSubsResultBase> boolean filterCheck(TableColumnFilterHelper<T> filter_helper, T ds, String filter2, boolean regex, boolean confusable) {
        if (filter2 == null || filter2.length() == 0) {
            return true;
        }
        if (confusable) {
            filter2 = GeneralUtils.getConfusableEquivalent(filter2, true);
        }
        try {
            String name;
            String[] names;
            boolean hash_filter = filter2.startsWith("t:");
            if (hash_filter) {
                filter2 = filter2.substring(2);
                byte[] hash = ds.getHash();
                if (hash == null) {
                    return false;
                }
                names = new String[]{ByteFormatter.encodeString(hash), Base32.encode(hash)};
            } else {
                name = ds.getName();
                if (confusable) {
                    name = GeneralUtils.getConfusableEquivalent(name, false);
                }
                names = new String[]{name};
            }
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                name = stringArray[n2];
                if (filter_helper.filterCheck(ds, filter2, regex, name, hash_filter)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return true;
        }
    }
}

