/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.ui.swt.FixedHTMLTransfer;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DragDropUtils {
    public static final String DROPDATA_PREFIX_TAG_UID = "TagUID";
    private static Object lastDraggedObject;

    public static DragSource createDragSource(Control control, int style) {
        return new DragSourceMonitored(control, style);
    }

    public static Object getLastDraggedObject() {
        return lastDraggedObject;
    }

    public static List<DownloadManager> getDownloadsFromDropData(Object dropData, boolean includeFileDrops) {
        ArrayList<DownloadManager> listDMs = new ArrayList<DownloadManager>();
        if (!(dropData instanceof String)) {
            return listDMs;
        }
        String[] split = RegExUtil.PAT_SPLIT_SLASH_N.split((String)dropData);
        if (split.length <= 1) {
            return listDMs;
        }
        String type = split[0];
        if (includeFileDrops ? !type.startsWith("DownloadManager") && !type.startsWith("DiskManagerFileInfo") : !type.startsWith("DownloadManager")) {
            return listDMs;
        }
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        if (gm == null) {
            return listDMs;
        }
        int i = 1;
        while (i < split.length) {
            String hash = split[i];
            int sep = hash.indexOf(";");
            if (sep != -1) {
                hash = hash.substring(0, sep);
            }
            try {
                DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm != null) {
                    listDMs.add(dm);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return listDMs;
    }

    public static List<Tag> getTagsFromDroppedData(Object dropData) {
        ArrayList<Tag> listTags = new ArrayList<Tag>();
        if (!(dropData instanceof String)) {
            return listTags;
        }
        String[] split = RegExUtil.PAT_SPLIT_SLASH_N.split((String)dropData);
        if (split.length <= 1) {
            return listTags;
        }
        String type = split[0];
        if (!type.equals(DROPDATA_PREFIX_TAG_UID)) {
            return listTags;
        }
        TagManager tagManager = TagManagerFactory.getTagManager();
        int i = 1;
        while (i < split.length) {
            String tagUID = split[i];
            try {
                long l = Long.parseLong(tagUID);
                Tag tag = tagManager.lookupTagByUID(l);
                if (tag != null) {
                    listTags.add(tag);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return listTags;
    }

    private static void createDropTarget(Composite composite, DropTargetListener dropTargetListener) {
        Control[] children;
        Transfer[] transferList = new Transfer[]{FixedHTMLTransfer.getInstance(), FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)composite, 31);
        dropTarget.setTransfer(transferList);
        dropTarget.addDropListener(dropTargetListener);
        if (Constants.isWindows) {
            return;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                if (control instanceof Composite) {
                    DragDropUtils.createDropTarget((Composite)control, dropTargetListener);
                } else {
                    DropTarget dropTarget2 = new DropTarget(control, 31);
                    dropTarget2.setTransfer(transferList);
                    dropTarget2.addDropListener(dropTargetListener);
                }
            }
            ++n2;
        }
    }

    public static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url) {
        DragDropUtils.createDropTarget(composite, (DropTargetListener)new URLDropTarget(url, bAllowShareAdd));
    }

    public static void createTorrentDropTarget(Composite composite, boolean bAllowShareAdd) {
        try {
            DragDropUtils.createDropTarget(composite, bAllowShareAdd, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void createURLDropTarget(Composite composite, Text url) {
        try {
            DragDropUtils.createDropTarget(composite, false, url);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static class DragSourceListenerDelegate
    implements DragSourceListener {
        final DragSourceListener delegate;

        public DragSourceListenerDelegate(DragSourceListener delegate) {
            this.delegate = delegate;
        }

        public void dragStart(DragSourceEvent event2) {
            this.delegate.dragStart(event2);
            this.dragSetData(event2);
        }

        public void dragSetData(DragSourceEvent event2) {
            this.delegate.dragSetData(event2);
            lastDraggedObject = event2.data;
        }

        public void dragFinished(DragSourceEvent event2) {
            this.delegate.dragFinished(event2);
            lastDraggedObject = null;
        }
    }

    private static class DragSourceMonitored
    extends DragSource {
        final Map<DragSourceListener, DragSourceListenerDelegate> mapToDelegates = new HashMap<DragSourceListener, DragSourceListenerDelegate>();

        protected void checkSubclass() {
        }

        public DragSourceMonitored(Control control, int style) {
            super(control, style);
        }

        public void addDragListener(DragSourceListener listener) {
            if (this.mapToDelegates.containsKey(listener)) {
                return;
            }
            DragSourceListenerDelegate delegate = new DragSourceListenerDelegate(listener);
            this.mapToDelegates.put(listener, delegate);
            super.addDragListener((DragSourceListener)delegate);
        }

        public void removeDragListener(DragSourceListener listener) {
            DragSourceListenerDelegate remove = this.mapToDelegates.remove(listener);
            super.removeDragListener((DragSourceListener)(remove == null ? listener : remove));
        }

        public void dispose() {
            this.mapToDelegates.clear();
            super.dispose();
        }
    }

    private static class URLDropTarget
    extends DropTargetAdapter {
        private final Text url;
        private final boolean bAllowShareAdd;

        public URLDropTarget(Text url, boolean bAllowShareAdd) {
            this.url = url;
            this.bAllowShareAdd = bAllowShareAdd;
        }

        private static boolean isOurDrag(Object dropData) {
            if (!(dropData instanceof String)) {
                return false;
            }
            String dropText = (String)dropData;
            return dropText.startsWith("DownloadManager\n") || dropText.startsWith("DiskManagerFileInfo\n") || dropText.startsWith(DragDropUtils.DROPDATA_PREFIX_TAG_UID);
        }

        public void dropAccept(DropTargetEvent event2) {
            event2.currentDataType = FixedURLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
        }

        public void dragEnter(DropTargetEvent event2) {
            if (URLDropTarget.isOurDrag(event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data)) {
                event2.detail = 0;
            }
        }

        public void dragOver(DropTargetEvent event2) {
            if (URLDropTarget.isOurDrag(event2.data == null ? DragDropUtils.getLastDraggedObject() : event2.data)) {
                event2.detail = 0;
                return;
            }
            if (event2.detail != 16 && (event2.operations & event2.detail) > 0) {
                return;
            }
            if ((event2.operations & 4) > 0) {
                event2.detail = 4;
            } else if ((event2.operations & 0x10) > 0) {
                event2.detail = 16;
            } else if ((event2.operations & 1) > 0) {
                event2.detail = 1;
            }
        }

        public void drop(DropTargetEvent event2) {
            String sURL;
            if (this.url == null || this.url.isDisposed()) {
                TorrentOpener.openDroppedTorrents(event2, this.bAllowShareAdd);
            } else if (event2.data instanceof FixedURLTransfer.URLType) {
                if (((FixedURLTransfer.URLType)event2.data).linkURL != null) {
                    this.url.setText(((FixedURLTransfer.URLType)event2.data).linkURL);
                }
            } else if (event2.data instanceof String && (sURL = UrlUtils.parseTextForURL((String)event2.data, true)) != null) {
                this.url.setText(sURL);
            }
        }
    }
}

