/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.update;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pif.update.UpdateCheckerListener;
import com.biglybt.pif.update.UpdateManager;
import com.biglybt.pif.update.UpdateManagerDecisionListener;
import com.biglybt.pif.update.UpdateManagerListener;
import com.biglybt.pif.update.UpdateManagerVerificationListener;
import com.biglybt.pif.update.UpdateProgressListener;
import com.biglybt.pif.utils.DelayedTask;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.UtilitiesImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UIFunctionsUserPrompter;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.StringListChooser;
import com.biglybt.ui.swt.progress.IProgressReport;
import com.biglybt.ui.swt.progress.IProgressReportConstants;
import com.biglybt.ui.swt.progress.IProgressReporter;
import com.biglybt.ui.swt.progress.IProgressReporterListener;
import com.biglybt.ui.swt.progress.ProgressReportingManager;
import com.biglybt.ui.swt.update.SilentInstallUI;
import com.biglybt.ui.swt.update.SimpleInstallUI;
import com.biglybt.ui.swt.update.UpdateAutoDownloader;
import com.biglybt.ui.swt.update.UpdateWindow;
import com.biglybt.update.CoreUpdateChecker;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;

public class UpdateMonitor
implements UpdateCheckInstanceListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final long AUTO_UPDATE_CHECK_PERIOD = 82800000L;
    public static final long AUTO_UPDATE_CHECK_PERIOD_BETA = 14400000L;
    private static UpdateMonitor singleton;
    private static final AEMonitor class_mon;
    private final UpdateManagerListener updateManagerListener;
    private final UpdateManagerVerificationListener updateManagerVerificationListener;
    private final TimerEventPeriodic timerAutoCheck;
    private Core azCore;
    private UpdateWindow current_update_window;
    private UpdateCheckInstance current_update_instance;
    private long last_recheck_time;

    static {
        class_mon = new AEMonitor("UpdateMonitor:class");
    }

    public static UpdateMonitor getSingleton(Core core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UpdateMonitor(core);
            }
            UpdateMonitor updateMonitor = singleton;
            return updateMonitor;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void destroySingleton() {
        try {
            class_mon.enter();
            if (singleton != null) {
                singleton.dispose();
                singleton = null;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected UpdateMonitor(Core _core) {
        this.azCore = _core;
        PluginInterface defPI = PluginInitializer.getDefaultInterface();
        UpdateManager um = defPI.getUpdateManager();
        this.updateManagerListener = new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance instance) {
                instance.addListener(UpdateMonitor.this);
                if (!instance.isLowNoise()) {
                    new updateStatusChanger(instance);
                }
            }
        };
        um.addListener(this.updateManagerListener);
        this.updateManagerVerificationListener = new UpdateManagerVerificationListener(){

            @Override
            public boolean acceptUnVerifiedUpdate(Update update) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    String title = MessageText.getString("UpdateMonitor.messagebox.accept.unverified.title");
                    String text = MessageText.getString("UpdateMonitor.messagebox.accept.unverified.text", new String[]{update.getName()});
                    UIFunctionsUserPrompter prompter = uiFunctions.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                    prompter.setRemember("UpdateMonitor.messagebox.accept.unverified", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    return prompter.waitUntilClosed() == 0;
                }
                return false;
            }

            @Override
            public void verificationFailed(Update update, Throwable cause) {
                String cause_str = Debug.getNestedExceptionMessage(cause);
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    String title = MessageText.getString("UpdateMonitor.messagebox.verification.failed.title");
                    String text = MessageText.getString("UpdateMonitor.messagebox.verification.failed.text", new String[]{update.getName(), cause_str});
                    uiFunctions.promptUser(title, text, new String[]{MessageText.getString("Button.ok")}, 0, null, null, false, 0, null);
                }
            }
        };
        um.addVerificationListener(this.updateManagerVerificationListener);
        this.timerAutoCheck = SimpleTimer.addPeriodicEvent("UpdateMon:autocheck", COConfigurationManager.getBooleanParameter("Beta Programme Enabled") ? 14400000L : 82800000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent ev) {
                UpdateMonitor.this.performAutoCheck(false);
            }
        });
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Update Check", new Runnable(){

            @Override
            public void run() {
                UIFunctions uiFunctions;
                String app_str;
                if (!(Constants.isWindowsVistaOrHigher || Constants.isUnix || SystemProperties.isJavaWebStartInstance() || new File(app_str = SystemProperties.getApplicationPath()).canWrite() || (uiFunctions = UIFunctionsManager.getUIFunctions()) == null)) {
                    if (app_str.endsWith(File.separator)) {
                        app_str = app_str.substring(0, app_str.length() - 1);
                    }
                    final String f_app_str = app_str;
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            UIFunctionsUserPrompter prompt = uiFunctions.getUserPrompter(MessageText.getString("updater.cant.write.to.app.title"), MessageText.getString("updater.cant.write.to.app.details", new String[]{f_app_str}), new String[]{MessageText.getString("Button.ok")}, 0);
                            prompt.setIconResource("warning");
                            prompt.setRemember("UpdateMonitor.can.not.write.to.app.dir.2", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                            prompt.open(null);
                        }
                    }, true);
                }
                UpdateMonitor.this.performAutoCheck(true);
            }
        });
        delayed_task.queue();
    }

    private void dispose() {
        PluginInterface defPI = PluginInitializer.getDefaultInterface();
        UpdateManager um = defPI.getUpdateManager();
        if (this.updateManagerListener != null) {
            um.removeListener(this.updateManagerListener);
        }
        if (this.updateManagerVerificationListener != null) {
            um.removeVerificationListener(this.updateManagerVerificationListener);
        }
        if (this.timerAutoCheck != null && !this.timerAutoCheck.isCancelled()) {
            this.timerAutoCheck.cancel();
        }
    }

    private String format(UpdateCheckInstance instance, String str) {
        String name = instance.getName();
        if (MessageText.keyExists(name)) {
            name = MessageText.getString(name);
        }
        return String.valueOf(name) + " - " + str;
    }

    private String format(UpdateChecker checker, String str) {
        return "    " + checker.getComponent().getName() + " - " + str;
    }

    protected void requestRecheck() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "UpdateMonitor: recheck requested"));
        }
        this.performCheck(false, true, true, null);
    }

    protected void performAutoCheck(final boolean start_of_day) {
        boolean bOldSWT;
        boolean check_at_start = false;
        boolean check_periodic = false;
        boolean bl = bOldSWT = SWT.getVersion() < 3139;
        if (!SystemProperties.isJavaWebStartInstance()) {
            check_at_start = COConfigurationManager.getBooleanParameter("update.start") || bOldSWT;
            check_periodic = COConfigurationManager.getBooleanParameter("update.periodic");
        }
        boolean bl2 = check_at_start = check_at_start || check_periodic;
        if (check_at_start && start_of_day || check_periodic && !start_of_day) {
            this.performCheck(bOldSWT, true, false, null);
        } else {
            new DelayedEvent("UpdateMon:wait2", 5000L, new AERunnable(){

                @Override
                public void runSupport() {
                    UIFunctions uiFunctions;
                    if (start_of_day && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                        uiFunctions.setStatusText("");
                    }
                    CoreUpdateChecker.doUsageStats();
                }
            });
        }
    }

    public void performCheck(boolean bForce, boolean automatic, boolean isRecheck, UpdateCheckInstanceListener l) {
        this.performCheck(bForce, automatic, isRecheck, null, l);
    }

    public void performCheck(final boolean bForce, final boolean automatic, boolean isRecheck, final Map<String, Object> explicitResources, final UpdateCheckInstanceListener l) {
        UIFunctions uiFunctions;
        long now = SystemTime.getCurrentTime();
        if (isRecheck) {
            if (this.last_recheck_time > now || now - this.last_recheck_time < 82800000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "skipping recheck as consecutive recheck too soon"));
                }
                return;
            }
            this.last_recheck_time = now;
        } else {
            this.last_recheck_time = 0L;
        }
        if (SystemProperties.isJavaWebStartInstance()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "skipping update check as java web start"));
            }
            return;
        }
        if (this.current_update_window != null && !this.current_update_window.isDisposed()) {
            this.current_update_window.dispose();
        }
        if (this.current_update_instance != null) {
            this.current_update_instance.cancel();
        }
        if (bForce) {
            VersionCheckClient.getSingleton().clearCache();
        }
        if ((uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
            uiFunctions.setStatusText("MainWindow.status.checking");
        }
        AEThread2 t = new AEThread2("UpdateMonitor:kickoff", true){

            @Override
            public void run() {
                UpdateManager um = PluginInitializer.getDefaultInterface().getUpdateManager();
                UpdateMonitor.this.current_update_instance = um.createUpdateCheckInstance(bForce ? 1 : 2, "update.instance.update");
                if (explicitResources != null) {
                    UpdateMonitor.this.current_update_instance.setProperty(7, explicitResources);
                }
                if (!automatic) {
                    UpdateMonitor.this.current_update_instance.setAutomatic(false);
                }
                if (l != null) {
                    UpdateMonitor.this.current_update_instance.addListener(l);
                }
                UpdateMonitor.this.current_update_instance.start();
            }
        };
        t.start();
    }

    @Override
    public void complete(final UpdateCheckInstance instance) {
        if (instance.isLowNoise()) {
            this.handleLowNoise(instance);
            return;
        }
        boolean hasDownloads = false;
        Update[] us = instance.getUpdates();
        int i = 0;
        while (i < us.length) {
            if (us[i].getDownloaders().length > 0) {
                hasDownloads = true;
                break;
            }
            ++i;
        }
        try {
            int ui = (Integer)instance.getProperty(1);
            if (ui == 2) {
                new SimpleInstallUI(this, instance);
                return;
            }
            if (ui == 3) {
                new SilentInstallUI(this, instance);
                return;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        boolean update_action = instance.getType() == 2;
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.setStatusText("");
        }
        if (hasDownloads) {
            UpdateWindow this_window = null;
            boolean autoDownload = COConfigurationManager.getBooleanParameter("update.autodownload");
            if (update_action) {
                if (!autoDownload && (this.current_update_window == null || this.current_update_window.isDisposed())) {
                    this_window = this.current_update_window = new UpdateWindow(this, this.azCore, instance);
                }
            } else {
                this_window = new UpdateWindow(this, this.azCore, instance);
            }
            if (this_window != null) {
                int i2 = 0;
                while (i2 < us.length) {
                    if (us[i2].getDownloaders().length > 0) {
                        this_window.addUpdate(us[i2]);
                    }
                    ++i2;
                }
                this_window.updateAdditionComplete();
            } else if (autoDownload) {
                new UpdateAutoDownloader(us, new UpdateAutoDownloader.cbCompletion(){

                    @Override
                    public void allUpdatesComplete(boolean requiresRestart, boolean bHadMandatoryUpdates) {
                        Boolean b = (Boolean)instance.getProperty(4);
                        if (b != null && b.booleanValue()) {
                            return;
                        }
                        if (requiresRestart) {
                            UpdateMonitor.this.handleRestart();
                        } else if (bHadMandatoryUpdates) {
                            UpdateMonitor.this.requestRecheck();
                        }
                    }
                });
            } else if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "UpdateMonitor: user dialog already in progress, updates skipped"));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "UpdateMonitor: check instance resulted in no user-actionable updates"));
        }
    }

    @Override
    public void cancelled(UpdateCheckInstance instance) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.setStatusText("");
        }
    }

    protected void handleRestart() {
        final UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            int visiblity_state = uiFunctions.getVisibilityState();
            if (visiblity_state == 1 && COConfigurationManager.getBooleanParameter("Low Resource Silent Update Restart Enabled")) {
                uiFunctions.dispose(true);
            } else {
                uiFunctions.performAction(2, Constants.isWindows7OrHigher, new UIFunctions.actionListener(){

                    @Override
                    public void actionComplete(Object result) {
                        if (((Boolean)result).booleanValue()) {
                            uiFunctions.dispose(true);
                        }
                    }
                });
            }
        } else {
            Debug.out("Can't handle restart as no ui functions available");
        }
    }

    protected void addDecisionHandler(UpdateCheckInstance instance) {
        instance.addDecisionListener(new UpdateManagerDecisionListener(){

            @Override
            public Object decide(Update update, int decision_type, String decision_name, String decision_description, Object decision_data) {
                if (decision_type == 0) {
                    String[] options = (String[])decision_data;
                    Shell shell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
                    if (shell == null) {
                        Debug.out("Shell doesn't exist");
                        return null;
                    }
                    StringListChooser chooser = new StringListChooser(shell);
                    chooser.setTitle(decision_name);
                    chooser.setText(decision_description);
                    int i = 0;
                    while (i < options.length) {
                        chooser.addOption(options[i]);
                        ++i;
                    }
                    String result = chooser.open();
                    return result;
                }
                return null;
            }
        });
    }

    protected void handleLowNoise(UpdateCheckInstance instance) {
        this.addDecisionHandler(instance);
        Update[] updates = instance.getUpdates();
        try {
            int i = 0;
            while (i < updates.length) {
                ResourceDownloader[] downloaders = updates[i].getDownloaders();
                int j = 0;
                while (j < downloaders.length) {
                    downloaders[j].download();
                    ++j;
                }
                ++i;
            }
            boolean restart_required = false;
            int i2 = 0;
            while (i2 < updates.length) {
                if (updates[i2].getRestartRequired() == 2) {
                    restart_required = true;
                }
                ++i2;
            }
            if (restart_required) {
                this.handleRestart();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected class updateStatusChanger
    implements IProgressReportConstants {
        UpdateCheckInstance instance;
        int check_num = 0;
        IProgressReporter updateReporter = ProgressReportingManager.getInstance().addReporter(MessageText.getString("UpdateWindow.title"));

        protected updateStatusChanger(UpdateCheckInstance _instance) {
            this.instance = _instance;
            this.updateReporter.setReporterType("reporterType_updater");
            this.updateReporter.setCancelAllowed(true);
            this.updateReporter.setTitle(MessageText.getString("updater.progress.window.title"));
            this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(this.instance, "added"));
            String name = this.instance.getName();
            if (MessageText.keyExists(name)) {
                this.updateReporter.setMessage(MessageText.getString(name));
            } else {
                this.updateReporter.setMessage(name);
            }
            this.updateReporter.setMinimum(0);
            this.updateReporter.setMaximum(this.instance.getCheckers().length);
            this.updateReporter.setSelection(this.check_num, null);
            this.updateReporter.addListener(new IProgressReporterListener(){

                @Override
                public int report(IProgressReport progressReport) {
                    if (progressReport.getReportType() == 2 || progressReport.getReportType() == 4) {
                        return 1;
                    }
                    if (progressReport.getReportType() == 1) {
                        if (updateStatusChanger.this.instance != null) {
                            updateStatusChanger.this.instance.cancel();
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            this.instance.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                    updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(instance, MessageText.getString("Progress.reporting.status.canceled")));
                    updateStatusChanger.this.updateReporter.cancel();
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                    updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(instance, MessageText.getString("Progress.reporting.status.finished")));
                    updateStatusChanger.this.updateReporter.setDone();
                }
            });
            UpdateChecker[] checkers = this.instance.getCheckers();
            int i = 0;
            while (i < checkers.length) {
                final UpdateChecker checker = checkers[i];
                checker.addListener(new UpdateCheckerListener(){

                    @Override
                    public void cancelled(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.status.canceled")));
                    }

                    @Override
                    public void completed(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.status.finished")));
                        updateStatusChanger.this.updateReporter.setSelection(++updateStatusChanger.this.check_num, null);
                    }

                    @Override
                    public void failed(UpdateChecker checker) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, MessageText.getString("Progress.reporting.default.error")));
                        updateStatusChanger.this.updateReporter.setSelection(++updateStatusChanger.this.check_num, null);
                        updateStatusChanger.this.updateReporter.setErrorMessage(null);
                    }
                });
                checker.addProgressListener(new UpdateProgressListener(){

                    @Override
                    public void reportProgress(String str) {
                        updateStatusChanger.this.updateReporter.appendDetailMessage(UpdateMonitor.this.format(checker, "    " + str));
                    }
                });
                ++i;
            }
        }
    }
}

