/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.ui.skin.SkinPropertiesImpl;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTColorWithAlpha;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class SWTSkinPropertiesImpl
extends SkinPropertiesImpl
implements SWTSkinProperties {
    private static Map<String, SWTColorWithAlpha> colorMap = new LightHashMap<String, SWTColorWithAlpha>();

    public SWTSkinPropertiesImpl(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        super(classLoader, skinPath, mainSkinFile);
        this.setEmHeight();
    }

    private void setEmHeight() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinPropertiesImpl.this.setEmHeightPX(FontUtils.getFontHeightInPX(Display.getDefault().getSystemFont()));
            }
        });
    }

    public SWTSkinPropertiesImpl() {
        this.setEmHeight();
    }

    @Override
    public Color getColor(String sID) {
        return this.getColorWithAlpha((String)sID).color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SWTColorWithAlpha getColorWithAlpha(String sID) {
        SWTColorWithAlpha colorInfo;
        Map<String, SWTColorWithAlpha> map = colorMap;
        synchronized (map) {
            colorInfo = colorMap.get(sID);
        }
        if (colorInfo == null) {
            Color color;
            int alpha = 255;
            try {
                int[] rgb = this.getColorValue(sID);
                if (rgb[0] > -1) {
                    color = ColorCache.getSchemedColor((Device)Utils.getDisplay(), rgb[0], rgb[1], rgb[2]);
                    if (rgb.length > 3) {
                        alpha = rgb[3];
                    }
                } else {
                    color = ColorCache.getColor((Device)Utils.getDisplay(), this.getStringValue(sID));
                }
            }
            catch (Exception e) {
                color = null;
            }
            colorInfo = new SWTColorWithAlpha(color, alpha);
            Map<String, SWTColorWithAlpha> map2 = colorMap;
            synchronized (map2) {
                colorMap.put(sID, colorInfo);
            }
        }
        return colorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Map<String, SWTColorWithAlpha> map = colorMap;
        synchronized (map) {
            colorMap.clear();
        }
    }

    @Override
    public Color getColor(String name, Color def) {
        Color color = this.getColor(name);
        if (color == null) {
            return def;
        }
        return color;
    }

    @Override
    public int getPxValue(String name, int def) {
        String value = this.getValue(name, null);
        if (value == null) {
            return def;
        }
        int result = def;
        try {
            if (value.endsWith("rem")) {
                float em = Float.parseFloat(value.substring(0, value.length() - 3));
                result = (int)((float)this.getEmHeightPX() * em);
            } else {
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyStatics() {
        Map<String, SWTColorWithAlpha> map = colorMap;
        synchronized (map) {
            colorMap.clear();
        }
    }
}

