/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.CompositeMinSize;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinObjectContainer
extends SWTSkinObjectBasic {
    boolean bPropogate = false;
    boolean bPropogateDown = false;
    private String[] sTypeParams = null;
    private int minWidth;
    private int minHeight;

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String[] sTypeParams, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "container", parent);
        this.sTypeParams = sTypeParams;
        Composite createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.createComposite(createOn);
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "container", parent);
        Composite createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.createComposite(createOn);
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, type, parent);
        if (control != null) {
            this.triggerListeners(4);
            this.setControl(control);
        }
    }

    protected Composite createComposite(Composite createOn) {
        CompositeMinSize parentComposite;
        int style = 0;
        if (this.properties.getIntValue(String.valueOf(this.sConfigID) + ".border", 0) == 1) {
            style = 2048;
        }
        if (this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".doublebuffer", false)) {
            style |= 0x20000000;
        }
        this.minWidth = this.properties.getPxValue(String.valueOf(this.sConfigID) + ".minwidth", -1);
        this.minHeight = this.properties.getPxValue(String.valueOf(this.sConfigID) + ".minheight", -1);
        if (this.skin.DEBUGLAYOUT) {
            System.out.println("linkIDtoParent: Create Composite " + this.sID + " on " + createOn);
            parentComposite = Utils.createSkinnedGroup(createOn, style);
            ((Group)parentComposite).setText(this.sConfigID == null ? this.sID : this.sConfigID);
            parentComposite.setData("DEBUG", "1");
        } else if (this.sTypeParams == null || this.sTypeParams.length < 2 || !this.sTypeParams[1].equalsIgnoreCase("group")) {
            parentComposite = new CompositeMinSize(createOn, style);
            parentComposite.setMinSize(new Point(this.minWidth, this.minHeight));
        } else {
            parentComposite = Utils.createSkinnedGroup(createOn, style);
        }
        parentComposite.setLayout((Layout)new FormLayout());
        this.control = parentComposite;
        if (this.properties.getBooleanValue(String.valueOf(this.sConfigID) + ".auto.defer.layout", false)) {
            Listener show_hide_listener = new Listener(){

                public void handleEvent(Event event2) {
                    parentComposite.setLayoutDeferred(event2.type == 23);
                }
            };
            parentComposite.addListener(22, show_hide_listener);
            parentComposite.addListener(23, show_hide_listener);
        }
        this.setControl(this.control);
        return parentComposite;
    }

    @Override
    public void setControl(Control control) {
        this.bPropogateDown = this.properties.getIntValue(String.valueOf(this.sConfigID) + ".propogateDown", 1) == 1;
        super.setControl(control);
    }

    @Override
    protected void setViewID(String viewID) {
        super.setViewID(viewID);
        if (this.skin.DEBUGLAYOUT && this.control != null) {
            ((Group)this.control).setText("[" + viewID + "]");
        }
    }

    public SWTSkinObject[] getChildren() {
        if (this.isDisposed()) {
            return new SWTSkinObject[0];
        }
        SWTSkinObject[] so = (SWTSkinObject[])Utils.execSWTThreadWithObject("getChildren", new AERunnableObject(){

            @Override
            public Object runSupport() {
                if (SWTSkinObjectContainer.this.control.isDisposed()) {
                    return new SWTSkinObject[0];
                }
                Control[] swtChildren = ((Composite)SWTSkinObjectContainer.this.control).getChildren();
                ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>(swtChildren.length);
                int i = 0;
                while (i < swtChildren.length) {
                    Control childControl = swtChildren[i];
                    SWTSkinObject so = (SWTSkinObject)childControl.getData("SkinObject");
                    if (so != null) {
                        list.add(so);
                    }
                    ++i;
                }
                return list.toArray(new SWTSkinObject[list.size()]);
            }
        }, 2000L);
        if (so == null) {
            System.err.println("Tell Tux to fix this " + Debug.getCompressedStackTrace());
            return this.oldgetChildren();
        }
        return so;
    }

    public SWTSkinObject[] oldgetChildren() {
        String[] widgets = this.properties.getStringArray(String.valueOf(this.sConfigID) + ".widgets");
        if (widgets == null) {
            return new SWTSkinObject[0];
        }
        ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>();
        int i = 0;
        while (i < widgets.length) {
            String id = widgets[i];
            SWTSkinObject skinObject = this.skin.getSkinObjectByID(id, this);
            if (skinObject != null) {
                list.add(skinObject);
            }
            ++i;
        }
        SWTSkinObject[] objects = new SWTSkinObject[list.size()];
        objects = list.toArray(objects);
        return objects;
    }

    public Composite getComposite() {
        return (Composite)this.control;
    }

    @Override
    public String switchSuffix(final String suffix, final int level, boolean walkUp, boolean walkDown) {
        String sFullsuffix = super.switchSuffix(suffix, level, walkUp, walkDown);
        if (this.bPropogateDown && walkDown && suffix != null && this.control != null && !this.control.isDisposed()) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    SWTSkinObject[] children = SWTSkinObjectContainer.this.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        children[i].switchSuffix(suffix, level, false);
                        ++i;
                    }
                }
            });
        }
        return sFullsuffix;
    }

    public void setPropogation(boolean propogate) {
        this.bPropogate = propogate;
        if (this.skin.DEBUGLAYOUT) {
            ((Group)this.control).setText(String.valueOf(((Group)this.control).getText()) + (this.bPropogate ? ";P" : ""));
        }
    }

    public boolean getPropogation() {
        return this.bPropogate;
    }

    public void setDebugAndChildren(boolean b) {
        this.setDebug(true);
        SWTSkinObject[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof SWTSkinObjectContainer) {
                ((SWTSkinObjectContainer)children[i]).setDebugAndChildren(b);
            } else {
                children[i].setDebug(b);
            }
            ++i;
        }
    }

    protected boolean superSetIsVisible(boolean visible, boolean walkup) {
        boolean changed = super.setIsVisible(visible, walkup);
        return changed;
    }

    @Override
    protected boolean setIsVisible(boolean visible, boolean walkup) {
        if (Utils.isThisThreadSWT() && !this.control.isDisposed() && !this.control.getShell().isVisible()) {
            return false;
        }
        boolean changed = super.setIsVisible(visible, walkup && visible);
        if (!changed) {
            return false;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObject[] children = SWTSkinObjectContainer.this.getChildren();
                if (children.length == 0) {
                    return;
                }
                int i = 0;
                while (i < children.length) {
                    SWTSkinObjectBasic child;
                    Control childControl;
                    if (children[i] instanceof SWTSkinObjectBasic && (childControl = (child = (SWTSkinObjectBasic)children[i]).getControl()) != null && !childControl.isDisposed()) {
                        child.setIsVisible(childControl.isVisible(), false);
                    }
                    ++i;
                }
                SWTSkinObjectContainer.this.getComposite().layout();
            }
        });
        return changed;
    }

    public void childAdded(SWTSkinObject soChild) {
    }

    @Override
    public Image obfuscatedImage(Image image) {
        if (!this.isVisible()) {
            return image;
        }
        if (this.getSkinView() instanceof ObfuscateImage) {
            image = ((ObfuscateImage)((Object)this.getSkinView())).obfuscatedImage(image);
        }
        Control[] swtChildren = ((Composite)this.control).getChildren();
        int i = 0;
        while (i < swtChildren.length) {
            ObfuscateImage oi;
            Control childControl = swtChildren[i];
            SWTSkinObject so = (SWTSkinObject)childControl.getData("SkinObject");
            if (so instanceof ObfuscateImage) {
                oi = (ObfuscateImage)((Object)so);
                oi.obfuscatedImage(image);
            } else if (so == null) {
                oi = (ObfuscateImage)childControl.getData("ObfuscateImage");
                if (oi != null) {
                    oi.obfuscatedImage(image);
                } else if (childControl instanceof Composite) {
                    this.obfuscatedImage((Composite)childControl, image);
                }
            }
            ++i;
        }
        return super.obfuscatedImage(image);
    }

    private void obfuscatedImage(Composite c, Image image) {
        Control[] children;
        if (c == null || c.isDisposed() || !c.isVisible()) {
            return;
        }
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control childControl = controlArray[n2];
            if (childControl.isVisible()) {
                ObfuscateImage oi = (ObfuscateImage)childControl.getData("ObfuscateImage");
                if (oi != null) {
                    oi.obfuscatedImage(image);
                } else if (childControl instanceof Composite) {
                    this.obfuscatedImage((Composite)childControl, image);
                }
            }
            ++n2;
        }
    }
}

