/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTSkinObjectButton
extends SWTSkinObjectBasic {
    private Button button;
    private ArrayList<SWTSkinButtonUtility.ButtonListenerAdapter> buttonListeners = new ArrayList(1);
    private boolean textOverride;
    private String imageID;

    public SWTSkinObjectButton(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "button", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        this.button = new Button(createOn, 8);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] listeners = SWTSkinObjectButton.this.buttonListeners.toArray();
                int i = 0;
                while (i < listeners.length) {
                    SWTSkinButtonUtility.ButtonListenerAdapter l = (SWTSkinButtonUtility.ButtonListenerAdapter)listeners[i];
                    l.pressed(null, SWTSkinObjectButton.this, 1, e.stateMask);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.button);
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        String text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix);
        if (text != null) {
            this.setText(text, true);
        }
        String fSuffix = suffix;
        String oldImageID = this.imageID;
        this.imageID = String.valueOf(this.sConfigID) + ".image" + fSuffix;
        String imageVal = this.properties.getStringValue(this.imageID);
        if (imageVal != null) {
            if (oldImageID != null) {
                ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
                imageLoader.releaseImage(oldImageID);
            }
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (SWTSkinObjectButton.this.button != null && !SWTSkinObjectButton.this.button.isDisposed() && SWTSkinObjectButton.this.imageID != null) {
                        ImageLoader imageLoader = SWTSkinObjectButton.this.skin.getImageLoader(SWTSkinObjectButton.this.properties);
                        Image image = imageLoader.getImage(SWTSkinObjectButton.this.imageID);
                        if (ImageLoader.isRealImage(image)) {
                            SWTSkinObjectButton.this.button.setImage(image);
                        } else {
                            SWTSkinObjectButton.this.button.setImage(null);
                        }
                    }
                }
            });
        }
        return suffix;
    }

    public void addSelectionListener(SWTSkinButtonUtility.ButtonListenerAdapter listener) {
        if (this.buttonListeners.contains(listener)) {
            return;
        }
        this.buttonListeners.add(listener);
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    private void setText(final String text, boolean auto) {
        if (!auto) {
            this.textOverride = true;
        } else if (this.textOverride) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectButton.this.button != null && !SWTSkinObjectButton.this.button.isDisposed()) {
                    int minWidth;
                    SWTSkinObjectButton.this.button.setText(text);
                    int width = SWTSkinObjectButton.this.properties.getIntValue(String.valueOf(SWTSkinObjectButton.this.sConfigID) + ".width", -1);
                    if (width == -1 && (minWidth = SWTSkinObjectButton.this.properties.getIntValue(String.valueOf(SWTSkinObjectButton.this.sConfigID) + ".minwidth", -1)) >= 0) {
                        FormData fd = (FormData)SWTSkinObjectButton.this.button.getLayoutData();
                        if (fd == null) {
                            fd = new FormData();
                        }
                        Point size = SWTSkinObjectButton.this.button.computeSize(-1, -1);
                        fd.width = size.x < minWidth ? minWidth : -1;
                        SWTSkinObjectButton.this.button.setLayoutData((Object)fd);
                        Utils.relayout(SWTSkinObjectButton.this.control);
                    }
                }
            }
        });
    }

    public Button getButton() {
        return this.button;
    }
}

