/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectImage;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinButtonUtility {
    ArrayList<ButtonListenerAdapter> listeners = new ArrayList();
    private final SWTSkinObject skinObject;
    private final String imageViewID;
    private boolean inSetDisabled = false;
    private boolean lastDisabledState = false;

    public SWTSkinButtonUtility(SWTSkinObject skinObject) {
        this(skinObject, null);
    }

    public SWTSkinButtonUtility(SWTSkinObject skinObject, String imageViewID) {
        this.skinObject = skinObject;
        this.imageViewID = imageViewID;
        if (skinObject == null) {
            Debug.out("Can't make button out of null skinObject");
            return;
        }
        if (skinObject.getControl() == null) {
            Debug.out("Can't make button out of null skinObject control");
            return;
        }
        if (skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        Listener l = new Listener(){
            boolean bDownPressed;
            private TimerEvent timerEvent;

            public void handleEvent(Event event2) {
                int et = event2.type;
                if (et == 3 || et == 4) {
                    if (event2.button == 1) {
                        if (event2.type == 3) {
                            if (this.timerEvent == null) {
                                this.timerEvent = SimpleTimer.addEvent("MouseHold", SystemTime.getOffsetTime(1000L), ev -> Utils.execSWTThread(() -> {
                                    this.timerEvent = null;
                                    if (!this.bDownPressed) {
                                        return;
                                    }
                                    this.bDownPressed = false;
                                    boolean stillPressed = true;
                                    if (Utils.getCursorControl() == event2.widget) {
                                        for (ButtonListenerAdapter l : SWTSkinButtonUtility.this.listeners) {
                                            stillPressed &= !l.held(SWTSkinButtonUtility.this);
                                        }
                                    }
                                    this.bDownPressed = stillPressed;
                                }));
                            }
                            this.bDownPressed = true;
                            return;
                        }
                        if (this.timerEvent != null) {
                            this.timerEvent.cancel();
                            this.timerEvent = null;
                        }
                        if (!this.bDownPressed) {
                            return;
                        }
                        this.bDownPressed = false;
                    }
                    if (SWTSkinButtonUtility.this.isDisabled()) {
                        return;
                    }
                    if (et == 4 && Utils.getCursorControl() != event2.widget) {
                        return;
                    }
                    for (ButtonListenerAdapter l : SWTSkinButtonUtility.this.listeners) {
                        l.pressed(SWTSkinButtonUtility.this, SWTSkinButtonUtility.this.skinObject, event2.button, event2.stateMask);
                    }
                } else {
                    for (ButtonListenerAdapter l : SWTSkinButtonUtility.this.listeners) {
                        l.entered(SWTSkinButtonUtility.this, SWTSkinButtonUtility.this.skinObject, event2.stateMask);
                    }
                }
            }
        };
        if (skinObject instanceof SWTSkinObjectContainer) {
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 4, l);
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 3, l);
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 6, l);
        } else {
            skinObject.getControl().addListener(4, l);
            skinObject.getControl().addListener(3, l);
            skinObject.getControl().addListener(6, l);
        }
    }

    public boolean isDisabled() {
        return this.skinObject == null ? true : this.skinObject.getSuffix().contains("-disabled");
    }

    public void setDisabled(boolean disabled) {
        if (this.inSetDisabled || this.skinObject == null) {
            return;
        }
        this.inSetDisabled = true;
        try {
            if (disabled == this.isDisabled()) {
                return;
            }
            if (this.skinObject instanceof SWTSkinObjectButton) {
                this.lastDisabledState = disabled;
                Utils.execSWTThreadLater(100, new AERunnable(){

                    @Override
                    public void runSupport() {
                        ((SWTSkinObjectButton)SWTSkinButtonUtility.this.skinObject).getButton().setEnabled(!SWTSkinButtonUtility.this.lastDisabledState);
                    }
                });
            }
            String suffix = disabled ? "-disabled" : "";
            this.skinObject.switchSuffix(suffix, 1, false);
            for (ButtonListenerAdapter l : this.listeners) {
                l.disabledStateChanged(this, disabled);
            }
        }
        finally {
            this.inSetDisabled = false;
        }
    }

    public void addSelectionListener(ButtonListenerAdapter listener) {
        if (this.skinObject instanceof SWTSkinObjectButton) {
            ((SWTSkinObjectButton)this.skinObject).addSelectionListener(listener);
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setTextID(final String id) {
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            ((SWTSkinObjectButton)this.skinObject).setText(MessageText.getString(id));
            return;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObject[] children;
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)SWTSkinButtonUtility.this.skinObject;
                    skinTextObject.setTextID(id);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)children[0];
                    skinTextObject.setTextID(id);
                }
                Utils.relayout(SWTSkinButtonUtility.this.skinObject.getControl());
            }
        });
    }

    public void setImage(final String id) {
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObject[] children;
                SWTSkinObject skinImageObject;
                if (SWTSkinButtonUtility.this.imageViewID != null && (skinImageObject = SWTSkinButtonUtility.this.skinObject.getSkin().getSkinObject(SWTSkinButtonUtility.this.imageViewID, SWTSkinButtonUtility.this.skinObject)) instanceof SWTSkinObjectImage) {
                    ((SWTSkinObjectImage)skinImageObject).setImageByID(id, null);
                    return;
                }
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectImage) {
                    skinImageObject = (SWTSkinObjectImage)SWTSkinButtonUtility.this.skinObject;
                    ((SWTSkinObjectImage)skinImageObject).setImageByID(id, null);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectImage) {
                    SWTSkinObjectImage skinImageObject2 = (SWTSkinObjectImage)children[0];
                    skinImageObject2.setImageByID(id, null);
                }
            }
        });
    }

    public void setTooltipID(final String id) {
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObject[] children;
                SWTSkinObject skinImageObject;
                if (SWTSkinButtonUtility.this.imageViewID != null && (skinImageObject = SWTSkinButtonUtility.this.skinObject.getSkin().getSkinObject(SWTSkinButtonUtility.this.imageViewID, SWTSkinButtonUtility.this.skinObject)) instanceof SWTSkinObjectImage) {
                    ((SWTSkinObjectBasic)skinImageObject).setTooltipID(id);
                    return;
                }
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectImage) {
                    skinImageObject = (SWTSkinObjectImage)SWTSkinButtonUtility.this.skinObject;
                    ((SWTSkinObjectBasic)skinImageObject).setTooltipID(id);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectImage) {
                    SWTSkinObjectImage skinImageObject2 = (SWTSkinObjectImage)children[0];
                    skinImageObject2.setTooltipID(id);
                }
            }
        });
    }

    public static class ButtonListenerAdapter {
        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
        }

        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int button, int stateMask) {
            this.pressed(buttonUtility, skinObject, stateMask);
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            return false;
        }

        public void disabledStateChanged(SWTSkinButtonUtility buttonUtility, boolean disabled) {
        }

        public void entered(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
        }
    }
}

