/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.opentorrent;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.impl.TorrentOpenFileOptions;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class TableColumnOTOF_Priority
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "priority";

    public TableColumnOTOF_Priority(TableColumn column) {
        column.initialize(1, -2, 50);
        column.addListeners(this);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        String text;
        int priority;
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        if (tfi.isToDownload()) {
            priority = tfi.getPriority();
            if (priority > 0) {
                text = MessageText.getString("FileItem.high");
                if (priority > 1) {
                    text = String.valueOf(text) + " (" + priority + ")";
                }
            } else if (priority < 0) {
                text = MessageText.getString("FileItem.low");
                if (priority < -1) {
                    text = String.valueOf(text) + " (" + priority + ")";
                }
            } else {
                text = MessageText.getString("FileItem.normal");
            }
        } else {
            priority = Integer.MIN_VALUE;
            text = "";
        }
        if (cell.setSortValue(priority)) {
            cell.setText(text);
        }
    }
}

