/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.opentorrent;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.subscriptions.SubscriptionManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.xml.rss.RSSUtils;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIConfigDefaultsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.main.UIFunctionsImpl;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.StandardButtonsArea;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class OpenTorrentWindow
implements TorrentDownloaderCallBackInterface,
UIUpdatable {
    protected static String CONFIG_REFERRER_DEFAULT = "openUrl.referrer.default";
    private Shell shellForChildren;
    private Shell parent;
    private SkinnedDialog dlg;
    private StandardButtonsArea buttonsArea;
    private Button btnBrowseTorrent;
    private Button btnBrowseFolder;
    private Button btnPasteOrClear;
    private boolean btnPasteOrClearIsPaste;
    private SWTSkinObjectTextbox soTextArea;
    private SWTSkinObject soReferArea;
    private Combo referrer_combo;
    private String last_referrer;
    private List<String> referrers;
    private SWTSkinObjectCheckbox soShowAdvanced;
    private String lastCopiedFromClip;

    public OpenTorrentWindow(Shell parent) {
        this.parent = parent;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                OpenTorrentWindow.this.swt_createWindow();
            }
        });
    }

    private void swt_createWindow() {
        SWTSkinObject soButtonArea;
        SWTSkinObject so;
        this.dlg = new SkinnedDialog("skin3_dlg_opentorrent", "shell", 2160);
        this.shellForChildren = this.dlg.getShell();
        SWTSkin skin = this.dlg.getSkin();
        this.soTextArea = (SWTSkinObjectTextbox)skin.getSkinObject("text-area");
        Text tb = (Text)this.soTextArea.getControl();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (sClipText != null && !sClipText.trim().isEmpty() && this.addTorrentsFromTextList(sClipText = sClipText.trim(), true) > 0) {
            tb.setText(sClipText);
            tb.setSelection(0, sClipText.length());
            this.lastCopiedFromClip = sClipText;
        }
        tb.setFocus();
        tb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int userMode = COConfigurationManager.getIntParameter("User Mode");
                if (userMode > 0 && OpenTorrentWindow.this.soReferArea != null) {
                    String text = ((Text)e.widget).getText();
                    boolean hasURL = UrlUtils.parseTextForURL(text, false, true) != null;
                    OpenTorrentWindow.this.soReferArea.setVisible(hasURL);
                }
            }
        });
        tb.addListener(1, ev -> {
            if ((ev.keyCode == 13 || ev.keyCode == 0x1000050) && (ev.stateMask & 0x70000) != 0) {
                this.openTorrent(32);
            }
        });
        SWTSkinObject soTopBar = skin.getSkinObject("add-buttons");
        if (soTopBar instanceof SWTSkinObjectContainer) {
            this.swt_addButtons(((SWTSkinObjectContainer)soTopBar).getComposite());
        }
        if ((so = skin.getSkinObject("show-advanced")) instanceof SWTSkinObjectCheckbox) {
            this.soShowAdvanced = (SWTSkinObjectCheckbox)so;
            this.soShowAdvanced.setChecked(COConfigurationManager.getBooleanParameter("ui.addtorrent.openoptions"));
        }
        this.soReferArea = skin.getSkinObject("refer-area");
        if (this.lastCopiedFromClip != null && UrlUtils.parseTextForURL(this.lastCopiedFromClip, false, true) != null) {
            this.soReferArea.setVisible(true);
        }
        this.last_referrer = COConfigurationManager.getStringParameter(CONFIG_REFERRER_DEFAULT, "");
        if (this.last_referrer == null) {
            this.last_referrer = "";
        }
        if ((so = skin.getSkinObject("refer-combo")) instanceof SWTSkinObjectContainer) {
            this.referrer_combo = new Combo(((SWTSkinObjectContainer)so).getComposite(), 2048);
            this.referrer_combo.setLayoutData((Object)Utils.getFilledFormData());
            this.referrers = COConfigurationManager.getStringListParameter("url_open_referrers");
            if (!this.last_referrer.isEmpty()) {
                this.referrer_combo.add(this.last_referrer);
            }
            for (String referrer : this.referrers) {
                if (referrer.equals(this.last_referrer)) continue;
                this.referrer_combo.add(referrer);
            }
        }
        if ((soButtonArea = skin.getSkinObject("button-area")) instanceof SWTSkinObjectContainer) {
            this.buttonsArea = new StandardButtonsArea(){

                @Override
                protected void clicked(int intValue) {
                    OpenTorrentWindow.this.openTorrent(intValue);
                }
            };
            this.buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.ok"), MessageText.getString("Button.cancel")});
            this.buttonsArea.setButtonVals(new Integer[]{32, 256});
            this.buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        UIUpdaterSWT.getInstance().addUpdater(this);
        this.dlg.open("otw", false);
        this.dlg.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            @Override
            public void skinDialogClosed(SkinnedDialog dialog) {
                OpenTorrentWindow.this.dispose();
            }
        });
    }

    private void openTorrent(int intValue) {
        String referrer = null;
        if (this.referrer_combo != null) {
            referrer = this.referrer_combo.getText().trim();
        }
        if (this.dlg != null) {
            this.dlg.close();
        }
        if (intValue == 32 && this.soTextArea != null && this.soTextArea.getText().length() > 0) {
            this.openTorrent(this.soTextArea.getText(), referrer);
        }
    }

    protected void openTorrent(String text, String newReferrer) {
        if (newReferrer != null && newReferrer.length() > 0) {
            if (!this.referrers.contains(newReferrer)) {
                this.referrers.add(newReferrer);
                COConfigurationManager.setParameter("url_open_referrers", this.referrers);
                COConfigurationManager.save();
            }
            COConfigurationManager.setParameter(CONFIG_REFERRER_DEFAULT, newReferrer);
            COConfigurationManager.save();
        }
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        String[] lines = null;
        int i = 0;
        while (i < splitters.length) {
            if (text.contains(splitters[i])) {
                lines = text.split(splitters[i]);
                break;
            }
            ++i;
        }
        if (lines == null) {
            lines = new String[]{text};
        }
        TorrentOpener.openTorrentsFromStrings(new TorrentOpenOptions(null), this.parent, null, lines, newReferrer, this, false);
    }

    protected void dispose() {
        UIUpdaterSWT.getInstance().removeUpdater(this);
    }

    private void swt_addButtons(Composite parent) {
        Composite cButtons = new Composite(parent, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout((Layout)rLayout);
        cButtons.setLayoutData((Object)Utils.getFilledFormData());
        this.btnBrowseTorrent = new Button(cButtons, 8);
        this.btnBrowseTorrent.setLayoutData((Object)new RowData());
        Messages.setLanguageText((Widget)this.btnBrowseTorrent, "OpenTorrentWindow.addFiles");
        this.btnBrowseTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shellForChildren, 4098);
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String fileName = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (fileName != null) {
                    OpenTorrentWindow.this.addTorrentsToWindow(fDialog.getFilterPath(), fDialog.getFileNames());
                }
            }
        });
        this.btnBrowseFolder = new Button(cButtons, 8);
        this.btnBrowseFolder.setLayoutData((Object)new RowData());
        Messages.setLanguageText((Widget)this.btnBrowseFolder, "OpenTorrentWindow.addFiles.Folder");
        this.btnBrowseFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog fDialog = new DirectoryDialog(OpenTorrentWindow.this.shellForChildren, 0);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.folder"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path != null) {
                    OpenTorrentWindow.this.addTorrentsToWindow(path, null);
                }
            }
        });
        this.btnPasteOrClearIsPaste = this.lastCopiedFromClip == null;
        this.btnPasteOrClear = new Button(cButtons, 8);
        this.btnPasteOrClear.setLayoutData((Object)new RowData());
        Messages.setLanguageText((Widget)this.btnPasteOrClear, this.btnPasteOrClearIsPaste ? "OpenTorrentWindow.addFiles.Clipboard" : "Button.clear");
        this.btnPasteOrClear.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (OpenTorrentWindow.this.btnPasteOrClearIsPaste) {
                    Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shellForChildren.getDisplay());
                    String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (sClipText != null) {
                        sClipText = sClipText.trim();
                        OpenTorrentWindow.this.lastCopiedFromClip = sClipText;
                        OpenTorrentWindow.this.addTorrentsFromTextList(sClipText, false);
                    }
                } else {
                    OpenTorrentWindow.this.soTextArea.setText("");
                }
            }
        });
        this.btnPasteOrClear.setVisible(!this.btnPasteOrClearIsPaste);
        Utils.makeButtonsEqualWidth(Arrays.asList(this.btnBrowseTorrent, this.btnBrowseFolder, this.btnPasteOrClear));
    }

    private String ensureTrailingSeparator(String sPath) {
        if (sPath == null || sPath.length() == 0 || sPath.endsWith(File.separator)) {
            return sPath;
        }
        return String.valueOf(sPath) + File.separator;
    }

    private int addTorrentsToWindow(String sTorrentFilePath, String[] sTorrentFilenames) {
        String text = this.soTextArea.getText();
        if ((sTorrentFilePath = this.ensureTrailingSeparator(sTorrentFilePath)) != null && sTorrentFilenames == null) {
            File dir = new File(sTorrentFilePath);
            if (!dir.isDirectory()) {
                return 0;
            }
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    if (FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".torrent")) {
                        return true;
                    }
                    return FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".tor");
                }
            });
            if (files.length == 0) {
                return 0;
            }
            sTorrentFilenames = new String[files.length];
            int i = 0;
            while (i < files.length) {
                sTorrentFilenames[i] = files[i].getName();
                ++i;
            }
        }
        int numAdded = 0;
        if (sTorrentFilenames != null) {
            int i = 0;
            while (i < sTorrentFilenames.length) {
                if (sTorrentFilenames[i] != null && sTorrentFilenames[i].length() != 0) {
                    String sFileName = String.valueOf(sTorrentFilePath == null ? "" : sTorrentFilePath) + sTorrentFilenames[i];
                    File file = new File(sFileName);
                    try {
                        if (UrlUtils.isURL(sFileName) || file.exists() && TorrentUtils.isTorrentFile(sFileName)) {
                            if (text.length() > 0) {
                                text = String.valueOf(text) + "\n";
                            }
                            text = String.valueOf(text) + sFileName;
                            ++numAdded;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (numAdded > 0) {
                this.soTextArea.setText(text);
            }
        }
        return numAdded;
    }

    private int addTorrentsFromTextList(String sClipText, boolean bVerifyOnly) {
        String[] lines = null;
        int iNumFound = 0;
        int iNoTorrentLines = 0;
        int MAX_CONSECUTIVE_NONTORRENT_LINES = 100;
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        int i = 0;
        while (i < splitters.length) {
            if (sClipText.contains(splitters[i])) {
                lines = sClipText.split(splitters[i]);
                break;
            }
            ++i;
        }
        if (lines == null) {
            lines = new String[]{sClipText};
        }
        i = 0;
        while (i < lines.length) {
            boolean ok;
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (line.length() == 0) {
                ok = false;
            } else if (UrlUtils.isURL(line)) {
                ok = true;
            } else {
                File file = new File(line);
                if (!file.exists()) {
                    ok = false;
                } else if (file.isDirectory()) {
                    if (bVerifyOnly) {
                        ok = true;
                    } else {
                        iNumFound += this.addTorrentsToWindow(lines[i], null);
                        ok = false;
                    }
                } else {
                    ok = true;
                }
            }
            if (!ok) {
                lines[i] = null;
                if (++iNoTorrentLines > 100) {
                    break;
                }
            } else {
                ++iNumFound;
                iNoTorrentLines = 0;
            }
            ++i;
        }
        if (bVerifyOnly) {
            return iNumFound;
        }
        return this.addTorrentsToWindow(null, lines);
    }

    public static void main(String[] args) {
        Core core = CoreFactory.create();
        core.start();
        UIConfigDefaultsSWT.initialize();
        Display display = Display.getDefault();
        Colors.getInstance();
        COConfigurationManager.setParameter("User Mode", 2);
        UIFunctionsImpl uiFunctions = new UIFunctionsImpl(null);
        UIFunctionsManager.setUIFunctions(uiFunctions);
        OpenTorrentWindow window = new OpenTorrentWindow(null);
        while (!window.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        core.stop();
    }

    private boolean isDisposed() {
        if (this.dlg == null) {
            return false;
        }
        return this.dlg.isDisposed();
    }

    @Override
    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (!(inf.getDeleteFileOnCancel() || state != 6 && state != 4 && state != 5 && state != 3)) {
            File file = inf.getFile();
            boolean done = false;
            if (RSSUtils.isRSSFeed(file)) {
                try {
                    String details;
                    long res;
                    URL url = new URL(inf.getURL());
                    UIManager ui_manager = StaticUtilities.getUIManager(10000L);
                    if (ui_manager != null && (res = ui_manager.showMessageBox("subscription.request.add.title", "!" + (details = MessageText.getString("subscription.request.add.message", new String[]{inf.getURL()})) + "!", 12L)) == 4L) {
                        SubscriptionManager sm = PluginInitializer.getDefaultInterface().getUtilities().getSubscriptionManager();
                        sm.requestSubscription(url);
                        done = true;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (!done) {
                TorrentUtil.isFileTorrent(inf.getURL(), file, inf.getURL(), true);
            }
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        if (state != 0) {
            if (state == 3) {
                File file = inf.getFile();
                TorrentOpenOptions torrentOptions = new TorrentOpenOptions(null);
                if (!TorrentOpener.mergeFileIntoTorrentInfo(file.getAbsolutePath(), inf.getURL(), torrentOptions)) {
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    boolean b = uif.addTorrentWithOptions(false, torrentOptions);
                    if (!b && file.exists()) {
                        file.delete();
                    }
                }
            } else if (state != 6 && state != 4 && state != 5) {
                if (state == 2) {
                    byte[] bytes;
                    int count = inf.getLastReadCount();
                    int numRead = inf.getTotalRead();
                    if (!inf.getDeleteFileOnCancel() && numRead >= 16384) {
                        inf.cancel();
                    } else if (numRead == count && count > 0 && (bytes = inf.getLastReadBytes())[0] != 100 && bytes[0] != 60) {
                        inf.setDeleteFileOnCancel(false);
                    }
                } else {
                    return;
                }
            }
        }
    }

    @Override
    public void updateUI() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (sClipText != null) {
            boolean bTorrentInClipboard;
            if (this.lastCopiedFromClip != null && sClipText.equals(this.lastCopiedFromClip)) {
                return;
            }
            boolean bl = bTorrentInClipboard = this.addTorrentsFromTextList(sClipText, true) > 0;
            if (this.btnPasteOrClear != null && !this.btnPasteOrClear.isDisposed()) {
                this.btnPasteOrClear.setVisible(bTorrentInClipboard);
                if (!this.btnPasteOrClearIsPaste) {
                    Messages.setLanguageText((Widget)this.btnPasteOrClear, "OpenTorrentWindow.addFiles.Clipboard");
                    Utils.makeButtonsEqualWidth(Arrays.asList(this.btnBrowseTorrent, this.btnBrowseFolder, this.btnPasteOrClear));
                    this.btnPasteOrClear.getParent().layout(true);
                    this.btnPasteOrClearIsPaste = true;
                }
            }
            if (bTorrentInClipboard) {
                Utils.setTT((Control)this.btnPasteOrClear, sClipText);
            }
        }
        clipboard.dispose();
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }
}

