/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.main;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIException;
import com.biglybt.pif.ui.UIInstanceFactory;
import com.biglybt.pif.ui.toolbar.UIToolBarItem;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableStructureEventDispatcher;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.KeyBindings;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UI;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.IMainMenu;
import com.biglybt.ui.swt.mainwindow.IMenuConstants;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mainwindow.PluginsMenuHelper;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerImpl;
import com.biglybt.ui.swt.shells.main.DebugMenuHelper;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.views.QuickLinksView;
import com.biglybt.ui.swt.views.columnsetup.TableColumnSetupWindow;
import com.biglybt.ui.swt.views.skin.SkinViewManager;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MainMenuV3
implements IMainMenu,
IMenuConstants {
    private static final String PREFIX_V2 = "MainWindow.menu";
    private static final String PREFIX_V3 = "v3.MainWindow.menu";
    private Menu menuBar;

    public MainMenuV3(SWTSkin skin, Shell shell) {
        if (skin == null) {
            System.err.println("MainMenuV3: The parameter [SWTSkin skin] can not be null");
            return;
        }
        this.buildMenu(shell);
    }

    private void buildMenu(Shell parent) {
        this.menuBar = parent.getDisplay().getMenuBar();
        if (this.menuBar == null) {
            this.menuBar = new Menu((Decorations)parent, 2);
            parent.setMenuBar(this.menuBar);
        } else {
            Utils.disposeSWTObjects(this.menuBar.getItems());
        }
        this.addFileMenu();
        this.addSimpleViewMenu();
        this.addCommunityMenu();
        this.addToolsMenu();
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            this.addTorrentMenu();
        }
        if (!Constants.isWindows) {
            this.addWindowMenu();
        }
        if (Constants.isCVSVersion()) {
            final Menu menuDebug = com.biglybt.ui.swt.mainwindow.DebugMenuHelper.createDebugMenuItem(this.menuBar);
            menuDebug.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    Object[] items = menuDebug.getItems();
                    Utils.disposeSWTObjects(items);
                    DebugMenuHelper.createDebugMenuItem(menuDebug);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        this.addV3HelpMenu();
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addFileMenu() {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        final Menu fileMenu = fileItem.getMenu();
        this.builFileMenu(fileMenu);
        fileMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                MenuItem[] menuItems = fileMenu.getItems();
                int i = 0;
                while (i < menuItems.length) {
                    menuItems[i].dispose();
                    ++i;
                }
                MainMenuV3.this.builFileMenu(fileMenu);
            }
        });
    }

    private void builFileMenu(Menu fileMenu) {
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenURIMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 0) {
            Menu shareSubMenu = MenuFactory.createShareMenuItem(fileMenu).getMenu();
            MenuFactory.addShareFileMenuItem(shareSubMenu);
            MenuFactory.addShareFolderMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        }
        MenuFactory.addCreateMenuItem(fileMenu);
        if (!Constants.isOSX) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addCloseWindowMenuItem(fileMenu);
            MenuFactory.addCloseDetailsMenuItem(fileMenu);
            MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        }
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.createTransfersMenuItem(fileMenu);
        if (!Constants.isOSX) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
        }
        if (Constants.isCVSVersion() && !UI.isFirstUI()) {
            MenuItem itemLogout = new MenuItem(fileMenu, 8);
            itemLogout.setText("Shutdown UI (Keep " + Constants.APP_NAME + " running)");
            itemLogout.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UISWTInstance uiSWTInstance;
                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uiFunctions != null && (uiSWTInstance = uiFunctions.getUISWTInstance()) instanceof UIInstanceFactory) {
                        try {
                            PluginInterface pi = PluginInitializer.getDefaultInterface();
                            pi.getUIManager().detachUI((UIInstanceFactory)((Object)uiSWTInstance));
                        }
                        catch (UIException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        if (!Constants.isOSX) {
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addSimpleViewMenu() {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            final Menu viewMenu = viewItem.getMenu();
            viewMenu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.disposeSWTObjects(viewMenu.getItems());
                    MainMenuV3.this.buildSimpleViewMenu(viewMenu, -1);
                }
            });
            final KeyBindings.KeyBindingInfo binding_info = KeyBindings.getKeyBindingInfo("v3.MainWindow.menu.view.pluginbar");
            if (binding_info != null) {
                Display.getDefault().addFilter(1, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.keyCode == binding_info.accelerator && !viewMenu.isDisposed()) {
                            Utils.disposeSWTObjects(viewMenu.getItems());
                            MainMenuV3.this.buildSimpleViewMenu(viewMenu, event2.keyCode);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void buildSimpleViewMenu(final Menu viewMenu, int accelerator) {
        try {
            SWTSkinObject right_bar;
            MenuItem mi;
            SWTSkinObject plugin_bar;
            SWTSkin skin = SWTSkinFactory.getInstance();
            MenuFactory.addMenuItem(viewMenu, 32, "v3.MainWindow.menu.view.sidebar", new Listener(){

                public void handleEvent(Event event2) {
                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sidebar != null) {
                        sidebar.flipSideBarVisibility();
                    }
                }
            });
            if (COConfigurationManager.getIntParameter("User Mode") > 1 && (plugin_bar = skin.getSkinObject("pluginbar")) != null) {
                mi = MainMenuV3.createPluginBarMenuItem(skin, viewMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar");
                if (accelerator != -1 && mi.getAccelerator() == accelerator) {
                    Listener[] listeners;
                    Listener[] listenerArray = listeners = mi.getListeners(13);
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener l = listenerArray[n2];
                        try {
                            l.handleEvent(null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
            }
            if ((right_bar = skin.getSkinObject("rightbar")) != null) {
                mi = MainMenuV3.createPluginBarMenuItem(skin, viewMenu, "v3.MainWindow.menu.view.rightbar", "rightbar.visible", "rightbar");
            }
            MenuFactory.addViewToolbarMenuItem(viewMenu);
            mi = MainMenuV3.createQuickLinksMenuItem(skin, viewMenu, "v3.MainWindow.menu.view.quick-links", "quick-links.visible", "quick-links");
            MenuItem itemStatusBar = MenuFactory.createTopLevelMenuItem(viewMenu, "v3.MainWindow.menu.view.statusbar");
            itemStatusBar.setText(itemStatusBar.getText());
            Menu menuStatusBar = itemStatusBar.getMenu();
            String[] statusAreaLangs = new String[]{"ConfigView.section.style.status.show_sr", "ConfigView.section.style.status.show_nat", "ConfigView.section.style.status.show_ddb", "ConfigView.section.style.status.show_ipf"};
            String[] statusAreaConfig = new String[]{"Status Area Show SR", "Status Area Show NAT", "Status Area Show DDB", "Status Area Show IPF"};
            int i = 0;
            while (i < statusAreaConfig.length) {
                final String configID = statusAreaConfig[i];
                String langID = statusAreaLangs[i];
                final MenuItem item = new MenuItem(menuStatusBar, 32);
                Messages.setLanguageText((Widget)item, langID);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        COConfigurationManager.setParameter(configID, !COConfigurationManager.getBooleanParameter(configID));
                    }
                });
                menuStatusBar.addListener(22, new Listener(){

                    public void handleEvent(Event event2) {
                        item.setSelection(COConfigurationManager.getBooleanParameter(configID));
                    }
                });
                ++i;
            }
            if (Constants.isWindows) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            boolean needsSep = false;
            boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
            if (enabled) {
                MenuFactory.addMenuItem(viewMenu, "MainWindow.menu.view.beta", new Listener(){

                    public void handleEvent(Event event2) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        if (mdi != null) {
                            mdi.showEntryByID("BetaProgramme");
                        }
                    }
                });
                needsSep = true;
            }
            if (needsSep) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            needsSep = PluginsMenuHelper.buildViewMenu(viewMenu);
            if (COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
                if (needsSep) {
                    MenuFactory.addSeparatorMenuItem(viewMenu);
                }
                int simple_advanced_menu_type = Constants.isLinux ? 32 : 16;
                MenuFactory.addMenuItem(viewMenu, simple_advanced_menu_type, "v3.MainWindow.menu.view.asSimpleList", new Listener(){

                    public void handleEvent(Event event2) {
                        UIToolBarItem item;
                        UIToolBarManager tb = UIToolBarManagerImpl.getInstance();
                        if (tb != null && (item = tb.getToolBarItem("modeBig")) != null) {
                            item.triggerToolBarItem(0L, SelectedContentManager.convertSelectedContentToObject(null));
                        }
                    }
                });
                MenuFactory.addMenuItem(viewMenu, simple_advanced_menu_type, "v3.MainWindow.menu.view.asAdvancedList", new Listener(){

                    public void handleEvent(Event event2) {
                        UIToolBarItem item;
                        UIToolBarManager tb = UIToolBarManagerImpl.getInstance();
                        if (tb != null && (item = tb.getToolBarItem("modeSmall")) != null) {
                            item.triggerToolBarItem(0L, SelectedContentManager.convertSelectedContentToObject(null));
                        }
                    }
                });
                needsSep = true;
            }
            if (needsSep) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            MenuFactory.addMenuItem(viewMenu, "MainWindow.menu.view.columnsetup", new Listener(){

                public void handleEvent(Event event2) {
                    TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                    if (tv == null) {
                        return;
                    }
                    TableRowCore focusedRow = tv.getFocusedRow();
                    if (focusedRow == null || focusedRow.isRowDisposed()) {
                        focusedRow = tv.getRow(0);
                    }
                    String tableID = tv.getTableID();
                    new TableColumnSetupWindow(tv.getDataSourceType(), tableID, null, focusedRow, TableStructureEventDispatcher.getInstance(tableID)).open();
                }
            });
            viewMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    MultipleDocumentInterface mdi;
                    MenuItem sidebarMenuItem = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.sidebar");
                    if (sidebarMenuItem != null && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                        sidebarMenuItem.setSelection(mdi.isVisible());
                    }
                    if (COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
                        UIToolBarManager tb;
                        MenuItem itemShowAsAdv;
                        UIToolBarManager tb2;
                        MenuItem itemShowAsSimple = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.asSimpleList");
                        if (itemShowAsSimple != null && (tb2 = UIToolBarManagerImpl.getInstance()) != null) {
                            UIToolBarItem item = tb2.getToolBarItem("modeBig");
                            long state = item == null ? 0L : item.getState();
                            itemShowAsSimple.setEnabled((state & 1L) > 0L);
                            itemShowAsSimple.setSelection((state & 2L) > 0L);
                        }
                        if ((itemShowAsAdv = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.asAdvancedList")) != null && (tb = UIToolBarManagerImpl.getInstance()) != null) {
                            UIToolBarItem item = tb.getToolBarItem("modeSmall");
                            long state = item == null ? 0L : item.getState();
                            itemShowAsAdv.setEnabled((state & 1L) > 0L);
                            itemShowAsAdv.setSelection((state & 2L) > 0L);
                        }
                    }
                    TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                    MenuItem itemColumnSetup = MenuFactory.findMenuItem(viewMenu, "MainWindow.menu.view.columnsetup");
                    itemColumnSetup.setEnabled(tv != null);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addCommunityMenu() {
        MenuFactory.createCommunityMenuItem(this.menuBar);
    }

    private void addToolsMenu() {
        MenuItem toolsItem = MenuFactory.createToolsMenuItem(this.menuBar);
        MenuBuildUtils.addMaintenanceListenerForMenu(toolsItem.getMenu(), (toolsMenu, menuEvent) -> {
            MenuFactory.addMyTrackerMenuItem(toolsMenu);
            MenuFactory.addMySharesMenuItem(toolsMenu);
            MenuFactory.addConsoleMenuItem(toolsMenu);
            MenuFactory.addStatisticsMenuItem(toolsMenu);
            MenuFactory.addSpeedLimitsToMenu(toolsMenu);
            MenuFactory.addTransferBarToMenu(toolsMenu);
            MenuFactory.addClientStatsMenuItem(toolsMenu);
            MenuFactory.addBlockedIPsMenuItem(toolsMenu);
            PluginsMenuHelper.buildToolsMenu(toolsMenu);
            MenuFactory.addSeparatorMenuItem(toolsMenu);
            MenuFactory.createPluginsMenuItem(toolsMenu, false);
            MenuFactory.addPairingMenuItem(toolsMenu);
            MenuFactory.addOptionsMenuItem(toolsMenu);
        }, true);
    }

    private void addV3HelpMenu() {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!Constants.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addMenuItem(helpMenu, "v3.MainWindow.menu.getting_started", new Listener(){

            public void handleEvent(Event event2) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    mdi.showEntryByID("Welcome");
                }
            }
        });
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addSeparatorMenuItem(helpMenu);
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
            MenuFactory.addBetaMenuItem(helpMenu);
        }
        MenuFactory.addDonationMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addConfigWizardMenuItem(helpMenu);
        MenuFactory.addNatTestMenuItem(helpMenu);
        MenuFactory.addNetStatusMenuItem(helpMenu);
        MenuFactory.addSpeedTestMenuItem(helpMenu);
        MenuFactory.addAdvancedHelpMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    private void addWindowMenu() {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addCloseWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addCloseDetailsMenuItem(windowMenu);
        MenuFactory.addCloseDownloadBarsToMenu(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addTorrentMenu() {
        MenuFactory.createTorrentMenuItem(this.menuBar);
    }

    @Override
    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }

    public static MenuItem createPluginBarMenuItem(final SWTSkin skin, Menu viewMenu, String textID, final String configID, final String viewID) {
        if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
            COConfigurationManager.setBooleanDefault(configID, true);
        }
        MenuItem item = MenuFactory.addMenuItem(viewMenu, 32, textID, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObject skinObject = skin.getSkinObject(viewID);
                if (skinObject != null) {
                    boolean newVisibility = !skinObject.isVisible();
                    SWTSkinUtils.setVisibility(skin, configID, viewID, newVisibility, true);
                }
            }
        });
        SWTSkinUtils.setVisibility(skin, configID, viewID, COConfigurationManager.getBooleanParameter(configID), false);
        final MenuItem itemViewPluginBar = item;
        final ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                itemViewPluginBar.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener(configID, listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(configID, listener);
            }
        });
        return item;
    }

    public static MenuItem createQuickLinksMenuItem(final SWTSkin skin, Menu viewMenu, String textID, final String configID, final String viewID) {
        if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
            COConfigurationManager.setBooleanDefault(configID, true);
        }
        final MenuItem item = MenuFactory.addMenuItem(viewMenu, 32, textID, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObject skinObject = skin.getSkinObject(viewID);
                if (skinObject != null) {
                    boolean newVisibility = !skinObject.isVisible();
                    QuickLinksView.setVisible(newVisibility);
                }
            }
        });
        item.setEnabled(COConfigurationManager.getBooleanParameter("IconBar.enabled"));
        final ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                item.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener(configID, listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(configID, listener);
            }
        });
        return item;
    }
}

