/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SimpleBrowserWindow {
    private Shell shell;
    private BrowserWrapper browser;

    public SimpleBrowserWindow(Shell parent, String url, double wPct, double hPct, boolean allowResize, boolean isModal) {
        if (parent == null) {
            this.init(parent, url, 0, 0, allowResize, isModal);
        } else {
            Rectangle clientArea = parent.getClientArea();
            this.init(parent, url, (int)((double)clientArea.width * wPct), (int)((double)clientArea.height * hPct), allowResize, isModal);
        }
    }

    public SimpleBrowserWindow(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        this.init(parent, url, w, h, allowResize, isModal);
    }

    private void init(Shell parent, String url, int w, int h, boolean allowResize, boolean isModal) {
        if (parent == null) {
            parent = Utils.findAnyShell();
        }
        int style = 2144;
        if (allowResize) {
            style |= 0x10;
        }
        if (isModal) {
            style |= 0x10000;
        }
        this.shell = ShellFactory.createShell(parent, style);
        this.shell.setLayout((Layout)new FillLayout());
        Utils.setShellIcon(this.shell);
        this.browser = Utils.createSafeBrowser((Composite)this.shell, 0);
        if (this.browser == null) {
            this.shell.dispose();
            return;
        }
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event2) {
                SimpleBrowserWindow.this.shell.open();
            }

            public void changed(ProgressEvent event2) {
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event2) {
                if (SimpleBrowserWindow.this.shell == null || SimpleBrowserWindow.this.shell.isDisposed()) {
                    return;
                }
                SimpleBrowserWindow.this.shell.dispose();
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                if (SimpleBrowserWindow.this.shell == null || SimpleBrowserWindow.this.shell.isDisposed()) {
                    return;
                }
                SimpleBrowserWindow.this.shell.setText(event2.title);
            }
        });
        if (w > 0 && h > 0) {
            this.shell.setSize(w, h);
        }
        Utils.centerWindowRelativeTo(this.shell, (Control)parent);
        this.browser.setUrl(url);
        this.browser.setData("StartURL", url);
    }

    public void waitUntilClosed() {
        Utils.readAndDispatchLoop((Control)this.shell);
    }
}

