/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.progress;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.progress.IProgressReport;
import com.biglybt.ui.swt.progress.IProgressReportConstants;
import com.biglybt.ui.swt.progress.IProgressReporter;
import com.biglybt.ui.swt.progress.IProgressReportingListener;
import com.biglybt.ui.swt.progress.ProgressReporter;
import com.biglybt.ui.swt.progress.ProgressReporterStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ProgressReportingManager
implements IProgressReportConstants {
    private static ProgressReportingManager INSTANCE = null;
    private final ParameterListener configListenerAutoRemoveInactive;
    private ProgressReporterStack progressReporters = new ProgressReporterStack();
    private int reporterCounter = Integer.MIN_VALUE;
    public static final int COUNT_ALL = 0;
    public static final int COUNT_ACTIVE = 1;
    public static final int COUNT_ERROR = 2;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean isAutoRemove = false;

    private ProgressReportingManager() {
        this.configListenerAutoRemoveInactive = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                ProgressReportingManager.this.isAutoRemove = COConfigurationManager.getBooleanParameter("auto_remove_inactive_items");
            }
        };
        COConfigurationManager.addAndFireParameterListener("auto_remove_inactive_items", this.configListenerAutoRemoveInactive);
    }

    public static final synchronized ProgressReportingManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProgressReportingManager();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    private void dispose() {
        COConfigurationManager.removeParameterListener("auto_remove_inactive_items", this.configListenerAutoRemoveInactive);
    }

    public IProgressReporter addReporter() {
        return new ProgressReporter(this);
    }

    public IProgressReporter addReporter(String name) {
        return new ProgressReporter(this, name);
    }

    public int getReporterCount(int whatToCount) {
        if (whatToCount == 2) {
            return this.progressReporters.getErrorCount();
        }
        if (whatToCount == 1) {
            return this.progressReporters.getActiveCount();
        }
        return this.progressReporters.size();
    }

    public boolean hasMultipleActive() {
        return this.progressReporters.hasMultipleActive();
    }

    public IProgressReporter getNextActiveReporter() {
        return this.progressReporters.getNextActiveReporter();
    }

    public IProgressReporter getCurrentReporter() {
        return this.progressReporters.peek();
    }

    public List getReporters(boolean onlyActive) {
        List reporters = this.progressReporters.getReporters(onlyActive);
        Collections.sort(reporters);
        return reporters;
    }

    public IProgressReporter[] getReportersArray(boolean onlyActive) {
        List rpList = this.progressReporters.getReporters(onlyActive);
        Object[] array = rpList.toArray(new IProgressReporter[rpList.size()]);
        Arrays.sort(array);
        return array;
    }

    public boolean remove(IProgressReporter reporter) {
        boolean value = this.progressReporters.remove(reporter);
        this.notifyListeners(2, reporter);
        return value;
    }

    public void addListener(IProgressReportingListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IProgressReportingListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(int eventType, IProgressReporter reporter) {
        for (IProgressReportingListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                listener.reporting(eventType, reporter);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void notifyManager(IProgressReporter reporter) {
        IProgressReport pReport = reporter.getProgressReport();
        if (this.isAutoRemove && !pReport.isActive() || pReport.isDisposed()) {
            this.progressReporters.remove(reporter);
            this.notifyListeners(2, reporter);
        } else if (this.progressReporters.contains(reporter)) {
            this.progressReporters.push(reporter);
            this.notifyListeners(3, reporter);
        } else {
            this.progressReporters.push(reporter);
            this.notifyListeners(1, reporter);
        }
    }

    protected final synchronized int getNextAvailableID() {
        return this.reporterCounter++;
    }
}

