/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pifimpl;

import com.biglybt.pif.ui.toolbar.UIToolBarActivationListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.swt.Utils;
import java.util.ArrayList;
import java.util.List;

public class UIToolBarItemImpl
implements ToolBarItem {
    private String id;
    private String imageID = "image.toolbar.run";
    private String textID;
    private boolean alwaysAvailable = false;
    private long state;
    private UIToolBarActivationListener defaultActivation;
    private String tooltipID;
    private String groupID = "main";
    private List<ToolBarItem.ToolBarItemListener> toolBarItemListeners = new ArrayList<ToolBarItem.ToolBarItemListener>();
    private String toolTip;

    public UIToolBarItemImpl(String id) {
        this.id = id;
    }

    @Override
    public void addToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        if (!this.toolBarItemListeners.contains(l)) {
            this.toolBarItemListeners.add(l);
        }
    }

    @Override
    public void removeToolBarItemListener(ToolBarItem.ToolBarItemListener l) {
        this.toolBarItemListeners.remove(l);
    }

    private void triggerFieldChange() {
        ToolBarItem.ToolBarItemListener[] array;
        ToolBarItem.ToolBarItemListener[] toolBarItemListenerArray = array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarItem.ToolBarItemListener l = toolBarItemListenerArray[n2];
            l.uiFieldChanged(this);
            ++n2;
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getTextID() {
        return this.textID;
    }

    @Override
    public void setTextID(String id) {
        this.textID = id;
        this.triggerFieldChange();
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public void setImageID(String id) {
        this.imageID = id;
        this.triggerFieldChange();
    }

    @Override
    public boolean isAlwaysAvailable() {
        return this.alwaysAvailable;
    }

    @Override
    public void setAlwaysAvailable(boolean alwaysAvailable) {
        this.alwaysAvailable = alwaysAvailable;
        this.triggerFieldChange();
    }

    @Override
    public long getState() {
        return this.state;
    }

    @Override
    public void setState(long state) {
        if (Utils.isDisplayDisposed()) {
            return;
        }
        this.state = state;
        this.triggerFieldChange();
    }

    @Override
    public boolean triggerToolBarItem(long activationType, Object datasource) {
        ToolBarItem.ToolBarItemListener[] array;
        ToolBarItem.ToolBarItemListener[] toolBarItemListenerArray = array = this.toolBarItemListeners.toArray(new ToolBarItem.ToolBarItemListener[0]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarItem.ToolBarItemListener l = toolBarItemListenerArray[n2];
            if (l.triggerToolBarItem(this, activationType, datasource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setDefaultActivationListener(UIToolBarActivationListener defaultActivation) {
        this.defaultActivation = defaultActivation;
    }

    @Override
    public UIToolBarActivationListener getDefaultActivationListener() {
        return this.defaultActivation;
    }

    @Override
    public String getToolTipID() {
        return this.tooltipID;
    }

    @Override
    public void setToolTipID(String tooltipID) {
        this.tooltipID = tooltipID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    @Override
    public void setToolTip(String text) {
        this.toolTip = text;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }
}

