/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mdi;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.debug.ObfuscateTab;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntryVitalityImageSWT;
import com.biglybt.ui.swt.mdi.TabbedMDI;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventCancelledException;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.widgets.TabFolderRenderer;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TabbedEntry
extends BaseMdiEntry
implements TabFolderRenderer.TabbedEntry {
    private CTabItem swtItem;
    private boolean showonSWTItemSet;
    private boolean buildonSWTItemSet;
    private MdiEntryVitalityImageSWT viPopout;
    private boolean userInitiatedClose;

    public TabbedEntry(TabbedMDI mdi, SWTSkin skin, String id) {
        super(mdi, id);
        this.skin = skin;
    }

    @Override
    public void build() {
        Utils.execSWTThread(this::swt_build);
    }

    public boolean swt_build() {
        if (this.swtItem == null || this.skin == null) {
            this.buildonSWTItemSet = true;
            return true;
        }
        this.buildonSWTItemSet = false;
        Control control = this.swtItem.getControl();
        if (control != null && !control.isDisposed()) {
            return true;
        }
        CTabFolder parent = this.swtItem.getParent();
        if (parent == null || parent.isDisposed()) {
            return false;
        }
        SWTSkinObject soParent = (SWTSkinObject)parent.getData("SkinObject");
        String skinRef = this.getSkinRef();
        if (skinRef != null) {
            Shell shell = parent.getShell();
            Cursor cursor = shell.getCursor();
            try {
                shell.setCursor(shell.getDisplay().getSystemCursor(1));
                SWTSkinObject skinObject = this.skin.createSkinObject(this.id, skinRef, soParent, this.getDatasourceCore());
                control = skinObject.getControl();
                control.setLayoutData((Object)Utils.getFilledFormData());
                control.getParent().layout(true);
                CTabItem oldSelection = this.swtItem.getParent().getSelection();
                this.swtItem.getParent().setSelection(this.swtItem);
                this.swtItem.setControl(control);
                if (oldSelection != null) {
                    this.swtItem.getParent().setSelection(oldSelection);
                }
                this.setPluginSkinObject(skinObject);
                this.setSkinObjectMaster(skinObject);
                this.initialize((Composite)control);
            }
            finally {
                shell.setCursor(cursor);
            }
        }
        try {
            SWTSkinObjectContainer soContents = (SWTSkinObjectContainer)this.skin.createSkinObject("MdiIView." + uniqueNumber++, "mdi.content.item", soParent);
            Composite viewComposite = soContents.getComposite();
            boolean doGridLayout = true;
            if (this.getControlType() == 257) {
                doGridLayout = false;
            }
            if (doGridLayout) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                gridLayout.verticalSpacing = 0;
                gridLayout.horizontalSpacing = 0;
                viewComposite.setLayout((Layout)gridLayout);
                viewComposite.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.setPluginSkinObject(soContents);
            this.initialize(viewComposite);
            Composite iviewComposite = this.getComposite();
            control = iviewComposite;
            if (doGridLayout) {
                Object existingLayoutData = iviewComposite.getLayoutData();
                Object existingParentLayoutData = iviewComposite.getParent().getLayoutData();
                if (existingLayoutData == null || !(existingLayoutData instanceof GridData) && existingParentLayoutData instanceof GridLayout) {
                    GridData gridData = new GridData(1808);
                    iviewComposite.setLayoutData((Object)gridData);
                }
            }
            CTabItem oldSelection = this.swtItem.getParent().getSelection();
            this.swtItem.getParent().setSelection(this.swtItem);
            this.swtItem.setControl((Control)viewComposite);
            if (oldSelection != null) {
                this.swtItem.getParent().setSelection(oldSelection);
            }
            this.setSkinObjectMaster(soContents);
        }
        catch (Exception e) {
            Debug.out("Error creating sidebar content area for " + this.id, e);
            try {
                this.setEventListener(null, null, false);
            }
            catch (UISWTViewEventCancelledException uISWTViewEventCancelledException) {
                // empty catch block
            }
            this.closeView();
        }
        if (control == null || control.isDisposed()) {
            return false;
        }
        control.setData("BaseMDIEntry", (Object)this);
        return true;
    }

    @Override
    public boolean isEntryDisposed() {
        return this.swtItem == null || this.swtItem.isDisposed();
    }

    protected void setUserInitiatedClose() {
        this.userInitiatedClose = true;
    }

    @Override
    public void show() {
        Utils.execSWTThreadLater(0, this::swt_show);
    }

    private void swt_show() {
        if (this.swtItem == null) {
            this.showonSWTItemSet = true;
            return;
        }
        this.showonSWTItemSet = false;
        if (!this.swt_build()) {
            return;
        }
        this.triggerOpenListeners();
        CTabFolder parent = this.swtItem.getParent();
        if (parent != null && parent.getSelection() != this.swtItem) {
            parent.setSelection(this.swtItem);
        }
        super.show();
    }

    @Override
    public MdiEntryVitalityImageSWT addVitalityImage(String imageID) {
        MdiEntryVitalityImageSWT mdiEntryVitalityImage = super.addVitalityImage(imageID);
        Utils.execSWTThreadLater(0, () -> this.getMDI().swt_refreshVitality());
        return mdiEntryVitalityImage;
    }

    @Override
    public boolean isCloseable() {
        return this.getMDI().isMainMDI || super.isCloseable();
    }

    @Override
    public void setCloseable(boolean closeable) {
        if (this.getMDI().isMainMDI) {
            closeable = true;
        }
        super.setCloseable(closeable);
        Utils.execSWTThread(() -> {
            if (this.swtItem == null || this.swtItem.isDisposed()) {
                return;
            }
            this.swtItem.setShowClose(this.isCloseable());
        });
    }

    @Override
    public void setEventListener(UISWTViewEventListener _eventListener, UISWTViewBuilderCore builder, boolean doCreate) throws UISWTViewEventCancelledException {
        super.setEventListener(_eventListener, builder, doCreate);
        this.buildCommonVitalityImages();
    }

    @Override
    public void setSkinRef(String configID, Object params) {
        super.setSkinRef(configID, params);
        this.buildCommonVitalityImages();
    }

    private void buildCommonVitalityImages() {
        boolean canBuildStandalone = this.canBuildStandAlone();
        if (canBuildStandalone && this.viPopout == null) {
            this.viPopout = this.addVitalityImage("popout_window");
            this.viPopout.setToolTip(MessageText.getString("label.pop.out"));
            this.viPopout.setShowOnlyOnSelection(true);
            this.viPopout.setAlwaysLast(true);
            this.viPopout.addListener((int x, int y) -> PopOutManager.popOut(this));
        } else if (this.viPopout != null) {
            this.viPopout.setVisible(canBuildStandalone);
        }
    }

    public void setSwtItem(CTabItem swtItem) {
        this.swtItem = swtItem;
        if (swtItem == null) {
            return;
        }
        swtItem.addDisposeListener(e -> this.closeView(this.userInitiatedClose));
        String title = this.getTitle();
        if (title != null) {
            swtItem.setText(title);
        }
        this.updateLeftImage();
        swtItem.setShowClose(this.isCloseable());
        if (this.buildonSWTItemSet) {
            this.build();
        }
        if (this.showonSWTItemSet) {
            this.show();
        }
    }

    @Override
    protected boolean setTitleSupport(String title) {
        boolean changed = super.setTitleSupport(title);
        if (changed && this.swtItem != null) {
            Utils.execSWTThread(() -> {
                if (this.swtItem == null || this.swtItem.isDisposed()) {
                    return;
                }
                this.swtItem.setText(this.getTitle());
            });
        }
        return changed;
    }

    @Override
    protected boolean setTitleIDSupport(String titleID) {
        boolean changed = super.setTitleIDSupport(titleID);
        if (changed && this.swtItem != null) {
            Utils.execSWTThread(() -> {
                if (this.swtItem == null || this.swtItem.isDisposed()) {
                    return;
                }
                this.swtItem.setText(this.getTitle());
            });
        }
        return changed;
    }

    @Override
    protected void destroyEntry(boolean userInitiated) {
        if (Utils.runIfNotSWTThread(() -> this.destroyEntry(userInitiated))) {
            return;
        }
        if (this.swtItem == null) {
            this.destroyEntryAlways();
            return;
        }
        CTabItem item = this.swtItem;
        this.swtItem = null;
        super.destroyEntry(userInitiated);
        try {
            if (!item.isDisposed()) {
                item.dispose();
            }
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    @Override
    public void redraw() {
        this.getMDI().getRenderer().redraw(this);
    }

    @Override
    public void setImageLeftID(String id) {
        super.setImageLeftID(id);
        this.updateLeftImage();
    }

    @Override
    public void setImageLeft(Image imageLeft) {
        super.setImageLeft(imageLeft);
        this.updateLeftImage();
    }

    private void updateLeftImage() {
        if (this.swtItem == null) {
            return;
        }
        Utils.execSWTThread(() -> {
            if (this.swtItem == null || this.swtItem.isDisposed()) {
                return;
            }
            Image image = this.getImageLeft(null);
            this.swtItem.setImage(image);
        });
    }

    @Override
    public void viewTitleInfoRefresh(ViewTitleInfo titleInfoToRefresh) {
        super.viewTitleInfoRefresh(titleInfoToRefresh);
        if (titleInfoToRefresh == null || this.viewTitleInfo != titleInfoToRefresh) {
            return;
        }
        if (this.isEntryDisposed()) {
            return;
        }
        boolean changed = false;
        String newText = (String)this.viewTitleInfo.getTitleInfoProperty(5);
        if (newText != null) {
            changed = this.setTitleSupport(newText);
        }
        if (!changed) {
            this.redraw();
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void setSelectable(boolean selectable) {
    }

    @Override
    public void setParentEntryID(String parentEntryID) {
    }

    @Override
    public String getParentID() {
        return null;
    }

    @Override
    public Image obfuscatedImage(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = this.swtItem == null ? null : this.swtItem.getBounds();
        if (bounds != null) {
            CTabFolder parent = this.swtItem.getParent();
            if (parent == null || parent.isDisposed()) {
                return image;
            }
            boolean isActive = parent.getSelection() == this.swtItem;
            boolean isHeaderVisible = this.swtItem.isShowing();
            Point location = Utils.getLocationRelativeToShell((Control)parent);
            bounds.x += location.x;
            bounds.y += location.y;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("image", image);
            map.put("obfuscateTitle", false);
            if (isActive) {
                this.triggerEvent(9, map);
                if (this.viewTitleInfo instanceof ObfuscateImage) {
                    ((ObfuscateImage)((Object)this.viewTitleInfo)).obfuscatedImage(image);
                }
            }
            if (isHeaderVisible) {
                String header;
                if (this.viewTitleInfo instanceof ObfuscateTab && (header = ((ObfuscateTab)((Object)this.viewTitleInfo)).getObfuscatedHeader()) != null) {
                    UIDebugGenerator.obfuscateArea(image, bounds, header);
                }
                if (MapUtils.getMapBoolean(map, "obfuscateTitle", false)) {
                    UIDebugGenerator.obfuscateArea(image, bounds);
                }
            }
        }
        return image;
    }

    @Override
    public void redraw(Rectangle hitArea) {
        if (Utils.runIfNotSWTThread(() -> this.redraw(hitArea))) {
            return;
        }
        if (this.swtItem == null || this.swtItem.isDisposed()) {
            return;
        }
        CTabFolder parent = this.swtItem.getParent();
        if (parent == null) {
            return;
        }
        parent.redraw(hitArea.x, hitArea.y, hitArea.width, hitArea.height, true);
    }

    @Override
    public TabbedMDI getMDI() {
        return (TabbedMDI)super.getMDI();
    }

    @Override
    public CTabItem getTabbedEntryItem() {
        return this.swtItem;
    }

    @Override
    public List<TabFolderRenderer.TabbedEntryVitalityImage> getTabbedEntryVitalityImages() {
        return new ArrayList<TabFolderRenderer.TabbedEntryVitalityImage>(this.getVitalityImages());
    }

    @Override
    public ViewTitleInfo getTabbedEntryViewTitleInfo() {
        return this.getViewTitleInfo();
    }

    @Override
    public boolean isTabbedEntryActive() {
        return this.isActive();
    }
}

