/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.maketorrent;

import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.maketorrent.WebSeedsEditorListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WebSeedsEditor {
    WebSeedsEditorListener listener;
    String oldName;
    String currentName;
    boolean anonymous;
    Map webseeds;
    Display display;
    Shell shell;
    Text textName;
    Tree treeGroups;
    TreeEditor editor;
    TreeItem itemEdited;
    Button btnSave;
    Button btnCancel;
    Menu menu;

    public WebSeedsEditor(String name, Map webseeds, WebSeedsEditorListener listener) {
        this(name, webseeds, listener, false);
    }

    public WebSeedsEditor(String name, Map webseeds, WebSeedsEditorListener listener, boolean _anonymous) {
        this.oldName = name;
        this.currentName = name != null ? name : "";
        this.listener = listener;
        this.anonymous = _anonymous;
        this.webseeds = new HashMap(webseeds);
        this.createWindow();
    }

    private void createWindow() {
        GridData gridData;
        this.display = Display.getCurrent();
        this.shell = ShellFactory.createShell(67680);
        Messages.setLanguageText((Widget)this.shell, "wizard.webseedseditor.edit.title");
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        if (!this.anonymous) {
            Label labelName = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)labelName, "wizard.multitracker.edit.name");
            this.textName = new Text((Composite)this.shell, 2048);
            this.textName.setText(this.currentName);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.textName.setLayoutData((Object)gridData);
            this.textName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    WebSeedsEditor.this.currentName = WebSeedsEditor.this.textName.getText();
                    WebSeedsEditor.this.computeSaveEnable();
                }
            });
        }
        this.treeGroups = new Tree((Composite)this.shell, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 150;
        this.treeGroups.setLayoutData((Object)gridData);
        this.treeGroups.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TreeItem treeItem;
                String type;
                if (WebSeedsEditor.this.treeGroups.getSelectionCount() == 1 && (type = (String)(treeItem = WebSeedsEditor.this.treeGroups.getSelection()[0]).getData("type")).equals("tracker")) {
                    WebSeedsEditor.this.editTreeItem(treeItem);
                }
            }
        });
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        Label label = new Label((Composite)this.shell, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite cButtons = new Composite((Composite)this.shell, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        cButtons.setLayoutData((Object)gridData);
        GridLayout layoutButtons = new GridLayout();
        layoutButtons.numColumns = 3;
        cButtons.setLayout((Layout)layoutButtons);
        label = new Label(cButtons, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.btnSave = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.horizontalAlignment = 3;
        this.btnSave.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.btnSave, "wizard.multitracker.edit.save");
        this.btnSave.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                WebSeedsEditor.this.update();
                WebSeedsEditor.this.shell.dispose();
            }
        });
        this.btnCancel = new Button(cButtons, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.widthHint = 70;
        this.btnCancel.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.btnCancel, "Button.cancel");
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                WebSeedsEditor.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(this.btnSave);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    WebSeedsEditor.this.shell.dispose();
                }
            }
        });
        this.computeSaveEnable();
        this.refresh();
        this.constructMenu();
        this.editor = new TreeEditor(this.treeGroups);
        this.treeGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (WebSeedsEditor.this.itemEdited != null && !WebSeedsEditor.this.editor.getEditor().isDisposed()) {
                    WebSeedsEditor.this.itemEdited.setText(((Text)WebSeedsEditor.this.editor.getEditor()).getText());
                }
                WebSeedsEditor.this.removeEditor();
            }
        });
        this.shell.pack();
        Point size = this.shell.computeSize(400, -1);
        this.shell.setSize(size);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    private void update() {
        this.webseeds = new HashMap();
        TreeItem[] groupItems = this.treeGroups.getItems();
        int i = 0;
        while (i < groupItems.length) {
            TreeItem group = groupItems[i];
            TreeItem[] trackerItems = group.getItems();
            ArrayList<String> groupList = new ArrayList<String>(group.getItemCount());
            int j = 0;
            while (j < trackerItems.length) {
                groupList.add(trackerItems[j].getText());
                ++j;
            }
            this.webseeds.put(group.getText(), groupList);
            ++i;
        }
        this.listener.webSeedsChanged(this.oldName, this.currentName, this.webseeds);
        this.oldName = this.currentName;
    }

    private void computeSaveEnable() {
        boolean enabled;
        boolean bl = enabled = this.anonymous || !"".equals(this.currentName);
        if (enabled) {
            TreeItem[] groupItems = this.treeGroups.getItems();
            int i = 0;
            block0: while (i < groupItems.length) {
                TreeItem group = groupItems[i];
                TreeItem[] trackerItems = group.getItems();
                int j = 0;
                while (j < trackerItems.length) {
                    if (!this.validURL(trackerItems[j].getText())) {
                        enabled = false;
                        break block0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (enabled != this.btnSave.getEnabled()) {
            this.btnSave.setEnabled(enabled);
        }
    }

    private void refresh() {
        this.treeGroups.removeAll();
        for (Map.Entry entry : this.webseeds.entrySet()) {
            TreeItem itemRoot = this.newGroup((String)entry.getKey());
            for (String url : (List)entry.getValue()) {
                if (!this.validURL(url)) continue;
                this.newTracker(itemRoot, url);
            }
        }
    }

    private void constructMenu() {
        this.menu = new Menu((Decorations)this.shell, 0);
        this.menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                MenuItem[] items = WebSeedsEditor.this.menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                final TreeItem treeItem = WebSeedsEditor.this.treeGroups.getSelection()[0];
                String type = (String)treeItem.getData("type");
                if (type.equals("tracker")) {
                    MenuItem item = new MenuItem(WebSeedsEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.multitracker.edit.deletetracker");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            treeItem.dispose();
                        }
                    });
                    item = new MenuItem(WebSeedsEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "Button.edit");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            WebSeedsEditor.this.editTreeItem(treeItem);
                        }
                    });
                } else if (type.equals("group")) {
                    MenuItem item = new MenuItem(WebSeedsEditor.this.menu, 0);
                    Messages.setLanguageText((Widget)item, "wizard.webseedseditor.edit.newseed");
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            TreeItem itemTracker = WebSeedsEditor.this.newTracker(treeItem, "http://");
                            WebSeedsEditor.this.editTreeItem(itemTracker);
                        }
                    });
                }
            }
        });
        this.treeGroups.setMenu(this.menu);
    }

    private void editTreeItem(final TreeItem item) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        this.itemEdited = item;
        final Text text = new Text((Composite)this.treeGroups, 2048);
        text.setText(item.getText());
        text.setForeground(item.getForeground());
        text.setSelection(item.getText().length());
        text.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                String url = text.getText();
                if (WebSeedsEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                WebSeedsEditor.this.computeSaveEnable();
                WebSeedsEditor.this.removeEditor();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                String url = text.getText();
                if (WebSeedsEditor.this.validURL(url)) {
                    text.setForeground(null);
                    item.setForeground(null);
                } else {
                    text.setForeground(Colors.colorError);
                    item.setForeground(Colors.colorError);
                }
                item.setText(url);
                WebSeedsEditor.this.computeSaveEnable();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    WebSeedsEditor.this.removeEditor();
                }
            }
        });
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        Rectangle r = text.computeTrim(0, 0, 100, text.getLineHeight());
        this.editor.minimumHeight = r.height;
        this.editor.setEditor((Control)text, item);
        text.setFocus();
    }

    private boolean validURL(String str) {
        try {
            URL url = new URL(str);
            String prot = url.getProtocol().toLowerCase();
            if (prot.startsWith("http")) {
                return true;
            }
        }
        finally {
            return false;
        }
    }

    private void removeEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    private TreeItem newGroup(String name) {
        TreeItem item = new TreeItem(this.treeGroups, 0);
        item.setData("type", (Object)"group");
        item.setText(name);
        return item;
    }

    private TreeItem newTracker(TreeItem root, String url) {
        TreeItem item = new TreeItem(root, 0);
        item.setText(url);
        item.setData("type", (Object)"tracker");
        root.setExpanded(true);
        return item;
    }
}

