/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.extlistener;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.messenger.ClientMessageContext;
import com.biglybt.core.messenger.PlatformMessenger;
import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.BrowserMessageDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.swt.browser.listener.ConfigListener;
import com.biglybt.ui.swt.browser.listener.TorrentListener;
import com.biglybt.ui.swt.donations.DonationWindow;
import com.biglybt.ui.swt.shells.main.MainWindow;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.util.ExternalStimulusHandler;
import com.biglybt.util.ExternalStimulusListener;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.MapUtils;
import com.biglybt.util.UrlFilter;
import java.util.Collections;
import java.util.Map;

public class StimulusRPC {
    private static final String KEY_SOURCE_REF = "source-ref";
    private static MyExternalStimulusListener externalStimulusListener;

    public static void hookListeners(Core core, MainWindow mainWindow) {
        externalStimulusListener = new MyExternalStimulusListener(core, mainWindow);
        ExternalStimulusHandler.addListener(externalStimulusListener);
    }

    public static void unhookListeners() {
        if (externalStimulusListener != null) {
            ExternalStimulusHandler.removeListener(externalStimulusListener);
            externalStimulusListener = null;
        }
    }

    private static class MyExternalStimulusListener
    implements ExternalStimulusListener {
        private final Core core;
        private final MainWindow mainWindow;

        public MyExternalStimulusListener(Core core, MainWindow mainWindow) {
            this.core = core;
            this.mainWindow = mainWindow;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean receive(String name, Map values) {
            try {
                if (values == null) {
                    return false;
                }
                if (!name.equals("AZMSG")) {
                    return false;
                }
                Object valueObj = values.get("value");
                if (!(valueObj instanceof String)) {
                    return false;
                }
                String value = (String)valueObj;
                ClientMessageContext context2 = PlatformMessenger.getClientMessageContext();
                if (context2 == null) {
                    return false;
                }
                String[] splitVal = value.split(";", 5);
                if (splitVal.length != 5) {
                    return false;
                }
                String lId = splitVal[2];
                String opId = splitVal[3];
                Map decodedMap = JSONUtils.decodeJSON(splitVal[4]);
                if (decodedMap == null) {
                    decodedMap = Collections.EMPTY_MAP;
                }
                if (opId.equals("load-torrent")) {
                    if (decodedMap.containsKey("b64")) {
                        String b64 = MapUtils.getMapString(decodedMap, "b64", null);
                        return TorrentListener.loadTorrentByB64(this.core, b64);
                    }
                    if (decodedMap.containsKey("url")) {
                        String url = MapUtils.getMapString(decodedMap, "url", null);
                        boolean blocked = UrlFilter.getInstance().urlIsBlocked(url);
                        if (blocked) {
                            Debug.out("stopped loading torrent URL because it's not in whitelist");
                            return false;
                        }
                        boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
                        boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
                        boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
                        DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                        dlInfo.setReferer(MapUtils.getMapString(decodedMap, "referer", null));
                        TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, playPrepare, bringToFront);
                        return true;
                    }
                } else {
                    if (opId.equals("is-ready")) {
                        return this.mainWindow.isReady();
                    }
                    if (opId.equals("is-version-ge")) {
                        if (!decodedMap.containsKey("version")) return false;
                        String id = MapUtils.getMapString(decodedMap, "id", "client");
                        String version = MapUtils.getMapString(decodedMap, "version", "");
                        if (!id.equals("client")) return false;
                        if (Constants.compareVersions("3.4.0.0", version) < 0) return false;
                        return true;
                    }
                    if (opId.equals("is-active-tab")) {
                        if (!decodedMap.containsKey("tab")) return false;
                        String tabID = MapUtils.getMapString(decodedMap, "tab", "");
                        if (tabID.length() <= 0) return false;
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        MdiEntry entry = mdi.getCurrentEntry();
                        if (entry == null) return false;
                        return entry.getViewID().equals(tabID);
                    }
                    if ("config".equals(lId)) {
                        if ("is-new-install".equals(opId)) {
                            return COConfigurationManager.isNewInstall();
                        }
                        if ("check-for-updates".equals(opId)) {
                            ConfigListener.checkForUpdates();
                            return true;
                        }
                        if ("log-diags".equals(opId)) {
                            ConfigListener.logDiagnostics();
                            return true;
                        }
                    } else if ("show-donation-window".equals(lId)) {
                        DonationWindow.open(true, MapUtils.getMapString(decodedMap, StimulusRPC.KEY_SOURCE_REF, "SRPC"));
                    }
                }
                if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                    BrowserMessageDispatcher dispatcher = context2.getDispatcher();
                    if (dispatcher == null) return false;
                    dispatcher.dispatch(new BrowserMessage(lId, opId, decodedMap));
                    return false;
                }
                System.err.println("Unhandled external stimulus: " + value);
                return false;
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return false;
        }

        @Override
        public int query(String name, Map values) {
            return Integer.MIN_VALUE;
        }
    }
}

