/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.donations;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.stats.transfer.LongTermStats;
import com.biglybt.core.stats.transfer.OverallStats;
import com.biglybt.core.stats.transfer.StatsFactory;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.ui.swt.BrowserWrapper;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.utils.FontUtils;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DonationWindow {
    public static boolean DEBUG = System.getProperty("donations.debug", "0").equals("1");
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final int RE_ASK_EVERY_HOURS = 96;
    private static int INIT_ASK_HOURS = 48;
    private static final int MAX_MIN_DAYS = 60;
    private static final int MAX_MAX_DAYS = 180;
    static boolean pageLoadedOk = false;
    static Shell shell = null;
    static BrowserWrapper.BrowserFunction browserFunction;
    private static int extraHeight;
    private static GridLayout shellLayout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForDonationPopup() {
        Class<DonationWindow> clazz = DonationWindow.class;
        synchronized (DonationWindow.class) {
            boolean alreadyDonated;
            boolean force;
            if (shell != null) {
                if (DEBUG) {
                    new MessageBoxShell(32, "Donations Test", "Already Open").open(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            long now = SystemTime.getCurrentTime();
            long maxDate = COConfigurationManager.getLongParameter("donations.maxDate", 0L);
            if (maxDate - now > 15552000000L) {
                maxDate = now + 15552000000L;
                COConfigurationManager.setParameter("donations.maxDate", maxDate);
            }
            boolean bl = force = maxDate > 0L && now > maxDate;
            if (force) {
                COConfigurationManager.setParameter("donations.maxDate", maxDate + 86400000L);
            }
            if ((alreadyDonated = COConfigurationManager.getBooleanParameter("donations.donated", false)) && !force) {
                if (DEBUG) {
                    new MessageBoxShell(32, "Donations Test", "Already Donated! I like you.").open(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            OverallStats stats2 = StatsFactory.getStats();
            if (stats2 == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            long upTime = stats2.getTotalUpTime();
            int hours = (int)(upTime / 3600L);
            int nextAsk = COConfigurationManager.getIntParameter("donations.nextAskHours", 0);
            if (nextAsk == 0) {
                COConfigurationManager.setParameter("donations.nextAskHours", hours + INIT_ASK_HOURS);
                COConfigurationManager.save();
                if (DEBUG) {
                    new MessageBoxShell(32, "Donations Test", "Newbie. You're active for " + hours + ".").open(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (hours < nextAsk && !force) {
                if (DEBUG) {
                    new MessageBoxShell(32, "Donations Test", "Wait " + (nextAsk - hours) + ".").open(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            long minDate = COConfigurationManager.getLongParameter("donations.minDate", 0L);
            if (minDate - now > 5184000000L) {
                minDate = now + 5184000000L;
                COConfigurationManager.setParameter("donations.minDate", minDate);
            }
            if (minDate > 0L && minDate > now) {
                if (DEBUG) {
                    new MessageBoxShell(32, "Donation Test", "Wait " + (SystemTime.getCurrentTime() - minDate) / 86400000L + " days").open(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (alreadyDonated) {
                DonationWindow.updateMinDate(false);
            }
            COConfigurationManager.setParameter("donations.nextAskHours", hours + 96);
            COConfigurationManager.save();
            // ** MonitorExit[var0] (shouldn't be in output)
            DonationWindow.open(false, "check");
            return;
        }
    }

    public static void open(final boolean showNoLoad, final String sourceRef) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                DonationWindow._open(showNoLoad, sourceRef);
            }
        });
    }

    private static void _open(boolean showNoLoad, String sourceRef) {
        BrowserWrapper browser;
        if (shell != null && !shell.isDisposed()) {
            return;
        }
        extraHeight = 0;
        final Shell parentShell = Utils.findAnyShell();
        shell = ShellFactory.createShell(parentShell, 2160);
        shellLayout = Utils.getSimpleGridLayout(1);
        DonationWindow.shellLayout.marginWidth = 10;
        DonationWindow.shellLayout.marginHeight = 10;
        shell.setLayout((Layout)shellLayout);
        if (parentShell != null) {
            parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.widget.dispose();
                    e.doit = false;
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (parentShell != null) {
                    parentShell.setCursor(e.display.getSystemCursor(0));
                }
                if (browserFunction != null && !browserFunction.isDisposed()) {
                    browserFunction.dispose();
                }
                shell = null;
            }
        });
        final LongTermStats lt_stats = StatsFactory.getLongTermStats();
        if (lt_stats != null) {
            final Label label = new Label((Composite)shell, 0);
            FontUtils.setFontHeight((Control)label, 13, 1);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
            extraHeight = label.computeSize((int)-1, (int)-1).y;
            new AEThread2("YearStats", true){

                @Override
                public void run() {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -2);
                    int year = calendar.get(1);
                    calendar.set(year, 0, 1, 0, 0, 0);
                    calendar.set(14, 0);
                    Date startDate = calendar.getTime();
                    calendar.set(1, year + 1);
                    calendar.add(13, -1);
                    Date endDate = calendar.getTime();
                    long[] stats2 = lt_stats.getTotalUsageInPeriod(startDate, endDate);
                    long ulBytes = stats2[0] + stats2[1] + stats2[4];
                    long dlBytes = stats2[2] + stats2[3] + stats2[5];
                    Utils.execSWTThread(() -> {
                        if (label.isDisposed()) {
                            return;
                        }
                        Messages.setLanguageText((Widget)label, "DonateWindow.YearStats", "" + year, DisplayFormatters.formatByteCountToKiBEtc(dlBytes), DisplayFormatters.formatByteCountToKiBEtc(ulBytes));
                        label.requestLayout();
                    });
                }
            }.start();
        }
        if ((browser = Utils.createSafeBrowser((Composite)shell, 0)) == null) {
            shell.dispose();
            return;
        }
        browser.setLayoutData(new GridData(4, 4, true, true));
        browser.addTitleListener(event2 -> {
            if (shell == null || shell.isDisposed()) {
                return;
            }
            shell.setText(event2.title);
        });
        browserFunction = browser.addBrowserFunction("sendDonationEvent", new BrowserWrapper.BrowserFunction(){

            @Override
            public Object function(Object[] arguments) {
                String[] strings;
                if (shell == null || shell.isDisposed()) {
                    return null;
                }
                if (arguments == null) {
                    Debug.out("Invalid sendDonationEvent null ");
                    return null;
                }
                if (arguments.length < 1) {
                    Debug.out("Invalid sendDonationEvent length " + arguments.length + " not 1");
                    return null;
                }
                if (!(arguments[0] instanceof String)) {
                    Debug.out("Invalid sendDonationEvent " + (arguments[0] == null ? "NULL" : arguments.getClass().getSimpleName()) + " not String");
                    return null;
                }
                String text = (String)arguments[0];
                if (text.contains("page-loaded")) {
                    pageLoadedOk = true;
                    COConfigurationManager.setParameter("donations.count", COConfigurationManager.getLongParameter("donations.count", 1L) + 1L);
                    Utils.centreWindow(shell);
                    if (parentShell != null) {
                        parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                    }
                    shell.open();
                } else if (text.contains("reset-ask-time")) {
                    int time = 96;
                    String[] strings2 = text.split(" ");
                    if (strings2.length > 1) {
                        try {
                            time = Integer.parseInt(strings2[1]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    DonationWindow.resetAskTime(time);
                } else if (text.contains("never-ask-again")) {
                    DonationWindow.neverAskAgain();
                } else if (text.contains("close")) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (shell != null && !shell.isDisposed()) {
                                shell.dispose();
                            }
                        }
                    });
                } else if (text.startsWith("open-url")) {
                    String url = text.substring(9);
                    Utils.launch(url);
                } else if (text.startsWith("set-size") && (strings = text.split(" ")).length > 2) {
                    try {
                        Point dpi = Constants.isWindows ? Utils.getDisplay().getDPI() : new Point(96, 96);
                        int nw = Integer.parseInt(strings[1]);
                        int nh = Integer.parseInt(strings[2]);
                        int w = (int)((double)nw * ((double)dpi.x / 96.0)) + shellLayout.verticalSpacing * 2 + shellLayout.marginWidth * 2;
                        int h = (int)((double)nh * ((double)dpi.y / 96.0)) + extraHeight + shellLayout.verticalSpacing * 2 + shellLayout.marginWidth * 2;
                        Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                        shell.setSize(computeTrim.width, computeTrim.height);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event2) {
            }

            public void changed(LocationEvent event2) {
            }
        });
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int upHours = (int)(upTime / 3600L);
        String url = "https://www.biglybt.com/donation/donate.php?locale=" + MessageText.getCurrentLocale().toString() + "&azv=" + "3.4.0.0" + "&count=" + COConfigurationManager.getLongParameter("donations.count", 1L) + "&uphours=" + upHours + "&sourceref=" + UrlUtils.encode(sourceRef);
        if (!browser.isFake()) {
            SimpleTimer.addEvent("donation.pageload", SystemTime.getOffsetTime(5000L), event2 -> {
                if (pageLoadedOk) {
                    return;
                }
                Utils.execSWTThread(() -> {
                    Debug.out("Page Didn't Load:" + url);
                    shell.dispose();
                    if (showNoLoad) {
                        Utils.launch("https://www.biglybt.com/donation/donate.php");
                    }
                });
            });
        }
        browser.setUrl(url);
        if (browser.isFake()) {
            browser.setUrl("https://www.biglybt.com/donation/donate.php");
            browser.setText("Please follow the link to donate via an external browser");
            shell.setSize(400, 500);
            Utils.centreWindow(shell);
            if (parentShell != null) {
                parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
            }
            shell.open();
        }
    }

    private static void neverAskAgain() {
        COConfigurationManager.setParameter("donations.donated", true);
        DonationWindow.updateMinDate(true);
        COConfigurationManager.save();
    }

    private static void resetAskTime(int askEveryHours) {
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int hours = (int)(upTime / 3600L);
        int nextAsk = hours + askEveryHours;
        COConfigurationManager.setParameter("donations.nextAskHours", nextAsk);
        COConfigurationManager.setParameter("donations.lastVersion", "3.4.0.0");
        DonationWindow.updateMinDate(false);
        COConfigurationManager.save();
    }

    private static void updateMinDate(boolean isNever) {
        long max_days;
        long min_days;
        if (isNever) {
            min_days = 60L;
            max_days = 180L;
        } else {
            min_days = 30L;
            max_days = 120L;
        }
        COConfigurationManager.setParameter("donations.minDate", SystemTime.getOffsetTime(86400000L * min_days));
        COConfigurationManager.setParameter("donations.maxDate", SystemTime.getOffsetTime(86400000L * max_days));
    }

    public static int getInitialAskHours() {
        return INIT_ASK_HOURS;
    }

    public static void setInitialAskHours(int i) {
        INIT_ASK_HOURS = i;
    }
}

