/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices.columns;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnFO_Progress
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellSWTPaintListener,
TableColumnExtraInfoListener {
    private static final int borderWidth = 1;
    public static final String COLUMN_ID = "fileops_progress";
    private static Font fontText;
    String na_text;
    Color textColor;

    public ColumnFO_Progress(final TableColumn column) {
        column.initialize(1, -2, 145);
        column.addListeners(this);
        column.setType(2);
        column.setRefreshInterval(-1);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                ColumnFO_Progress.this.na_text = MessageText.getString("general.na.short");
                column.invalidateCells();
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "progress"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(2);
    }

    @Override
    public void refresh(TableCell cell) {
        CoreOperationTask.ProgressCallback cb;
        CoreOperation op = (CoreOperation)cell.getDataSource();
        int progress = -1;
        if (op != null && (cb = op.getTask().getProgressCallback()) != null) {
            progress = cb.getProgress();
        }
        cell.setSortValue(progress);
    }

    @Override
    public void cellPaint(GC gcImage, TableCellSWT cell) {
        Rectangle imgBounds;
        CoreOperationTask.ProgressCallback cb;
        CoreOperation op = (CoreOperation)cell.getDataSource();
        int progress = 0;
        boolean has_progress = false;
        if (op != null && (cb = op.getTask().getProgressCallback()) != null) {
            progress = cb.getProgress();
            has_progress = true;
        }
        Rectangle bounds = cell.getBounds();
        int yOfs = (bounds.height - 13) / 2;
        int x1 = bounds.width - 1 - 2;
        int y1 = bounds.height - 3 - yOfs;
        if (x1 < 10 || y1 < 3) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgEnd = imageLoader.getImage("tc_bar_end");
        Image img0 = imageLoader.getImage("tc_bar_0");
        Image img1 = imageLoader.getImage("tc_bar_1");
        if (!imgEnd.isDisposed()) {
            gcImage.drawImage(imgEnd, bounds.x, bounds.y + yOfs);
            gcImage.drawImage(imgEnd, bounds.x + x1 + 1, bounds.y + yOfs);
        }
        int limit = x1 * progress / 1000;
        if (!img1.isDisposed() && limit > 0) {
            imgBounds = img1.getBounds();
            gcImage.drawImage(img1, 0, 0, imgBounds.width, imgBounds.height, bounds.x + 1, bounds.y + yOfs, limit, imgBounds.height);
        }
        if (progress < 1000 && !img0.isDisposed()) {
            imgBounds = img0.getBounds();
            gcImage.drawImage(img0, 0, 0, imgBounds.width, imgBounds.height, bounds.x + limit + 1, bounds.y + yOfs, x1 - limit, imgBounds.height);
        }
        imageLoader.releaseImage("tc_bar_end");
        imageLoader.releaseImage("tc_bar_0");
        imageLoader.releaseImage("tc_bar_1");
        if (this.textColor == null) {
            this.textColor = ColorCache.getColor(gcImage.getDevice(), "#006600");
        }
        gcImage.setForeground(this.textColor);
        if (fontText == null) {
            fontText = FontUtils.getFontWithHeight(gcImage.getFont(), 10, -1);
        }
        gcImage.setFont(fontText);
        String sText = !has_progress ? this.na_text : DisplayFormatters.formatPercentFromThousands(progress);
        GCStringPrinter.printString(gcImage, sText, new Rectangle(bounds.x + 4, bounds.y + yOfs, bounds.width - 4, 13), true, false, 0x1000000);
    }
}

