/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.core.pairing;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.biglybt.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.biglybt.core.pairing.impl.PairingManagerImpl;
import com.biglybt.core.security.CryptoManagerPasswordHandler;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.auth.CryptoWindow;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTStatusEntry;
import com.biglybt.ui.swt.pif.UISWTStatusEntryListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class PMSWTImpl
implements PairingManagerImpl.UIAdapter {
    private UISWTStatusEntry status;
    private volatile Set<String> local_addresses = new HashSet<String>();
    private Image icon_idle;
    private Image icon_green;
    private Image icon_red;
    private int last_update_count;
    private Image last_image;
    private String last_tooltip_text = "";
    private long last_image_expiry_mono;
    private long last_image_expiry_uc_min;
    private boolean ui_attached;
    private UIUpdater.UIUpdaterListener uiUpdaterListener;
    private ParameterListener iconEnableListener;
    private final Map<String, RemoteHistory> history_map = new HashMap<String, RemoteHistory>();

    @Override
    public void initialise(final PluginInterface pi, final BooleanParameter icon_enable) {
        final NetworkAdmin na = NetworkAdmin.getSingleton();
        na.addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String property) {
                if (property == "Network Interfaces") {
                    PMSWTImpl.this.updateLocalAddresses(na);
                }
            }
        });
        this.updateLocalAddresses(na);
        pi.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(final UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    PMSWTImpl.this.ui_attached = true;
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        PMSWTImpl.this.uiUpdaterListener = new UIUpdater.UIUpdaterListener(){

                            @Override
                            public void updateComplete(int count) {
                                PMSWTImpl.this.last_update_count = count;
                                PMSWTImpl.this.updateStatus(true);
                            }
                        };
                        uif.getUIUpdater().addListener(PMSWTImpl.this.uiUpdaterListener);
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            PMSWTImpl.this.icon_idle = imageLoader.getImage("pair_sb_idle");
                            PMSWTImpl.this.icon_green = imageLoader.getImage("pair_sb_green");
                            PMSWTImpl.this.icon_red = imageLoader.getImage("pair_sb_red");
                            UISWTInstance ui_instance = (UISWTInstance)instance;
                            PMSWTImpl.this.status = ui_instance.createStatusEntry();
                            PMSWTImpl.this.last_tooltip_text = MessageText.getString("pairing.ui.icon.tip");
                            Utils.setTT(PMSWTImpl.this.status, PMSWTImpl.this.last_tooltip_text);
                            PMSWTImpl.this.status.setImageEnabled(true);
                            PMSWTImpl.this.status.setImage(PMSWTImpl.this.icon_idle);
                            PMSWTImpl.this.last_image = PMSWTImpl.this.icon_idle;
                            boolean is_visible = icon_enable.getValue();
                            PMSWTImpl.this.status.setVisible(is_visible);
                            if (is_visible) {
                                PMSWTImpl.this.updateStatus(false);
                            }
                            final MenuItem mi_show = pi.getUIManager().getMenuManager().addMenuItem(PMSWTImpl.this.status.getMenuContext(), "pairing.ui.icon.show");
                            mi_show.setStyle(2);
                            mi_show.setData(is_visible);
                            mi_show.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    icon_enable.setValue(false);
                                }
                            });
                            PMSWTImpl.this.iconEnableListener = new ParameterListener(){

                                @Override
                                public void parameterChanged(Parameter param) {
                                    boolean is_visible = icon_enable.getValue();
                                    PMSWTImpl.this.status.setVisible(is_visible);
                                    mi_show.setData(is_visible);
                                    if (is_visible) {
                                        PMSWTImpl.this.updateStatus(false);
                                    }
                                }
                            };
                            icon_enable.addListener(PMSWTImpl.this.iconEnableListener);
                            MenuItem mi_pairing = pi.getUIManager().getMenuManager().addMenuItem(PMSWTImpl.this.status.getMenuContext(), "MainWindow.menu.pairing");
                            mi_pairing.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif == null) {
                                        Debug.out("UIFunctions not available, can't open remote pairing window");
                                    } else {
                                        uif.openRemotePairingWindow();
                                    }
                                }
                            });
                            MenuItem mi_sep = pi.getUIManager().getMenuManager().addMenuItem(PMSWTImpl.this.status.getMenuContext(), "");
                            mi_sep.setStyle(4);
                            MenuItem mi_options = pi.getUIManager().getMenuManager().addMenuItem(PMSWTImpl.this.status.getMenuContext(), "MainWindow.menu.view.configuration");
                            mi_options.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "Pairing");
                                    }
                                }
                            });
                            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                                @Override
                                public void entryClicked(UISWTStatusEntry entry) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "Pairing");
                                    }
                                }
                            };
                            PMSWTImpl.this.status.setListener(click_listener);
                        }
                    });
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    PMSWTImpl.this.ui_attached = false;
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null && PMSWTImpl.this.uiUpdaterListener != null) {
                        uif.getUIUpdater().removeListener(PMSWTImpl.this.uiUpdaterListener);
                        PMSWTImpl.this.uiUpdaterListener = null;
                    }
                    if (PMSWTImpl.this.status != null) {
                        PMSWTImpl.this.status.destroy();
                        PMSWTImpl.this.status = null;
                    }
                    if (icon_enable != null && PMSWTImpl.this.iconEnableListener != null) {
                        icon_enable.removeListener(PMSWTImpl.this.iconEnableListener);
                        PMSWTImpl.this.iconEnableListener = null;
                    }
                }
            }
        });
    }

    private void updateLocalAddresses(NetworkAdmin network_admin) {
        NetworkAdminNetworkInterface[] interfaces = network_admin.getInterfaces();
        HashSet<String> ias = new HashSet<String>();
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkAdminNetworkInterfaceAddress[] addresses;
            NetworkAdminNetworkInterface intf = networkAdminNetworkInterfaceArray[n2];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = addresses = intf.getAddresses();
            int n3 = addresses.length;
            int n4 = 0;
            while (n4 < n3) {
                NetworkAdminNetworkInterfaceAddress address = networkAdminNetworkInterfaceAddressArray[n4];
                InetAddress ia = address.getAddress();
                ias.add(ia.getHostAddress());
                ++n4;
            }
            ++n2;
        }
        this.local_addresses = ias;
    }

    @Override
    public void recordRequest(final String name, final String ip, final boolean good) {
        if (this.ui_attached) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    RemoteHistory entry = (RemoteHistory)PMSWTImpl.this.history_map.get(name);
                    if (entry == null) {
                        entry = new RemoteHistory();
                        PMSWTImpl.this.history_map.put(name, entry);
                    }
                    entry.addRequest(ip, good);
                    PMSWTImpl.this.updateStatus(false);
                }
            });
        }
    }

    private void updateStatus(boolean update_completed) {
        String tooltip_text_str;
        int RECORD_EXPIRY = 3600000;
        int GOOD_EXPIRY = 1000;
        int BAD_EXPIRY = 300000;
        int MAX_IPS_PER_TYPE = 10;
        int MAX_TYPES = 10;
        if (this.status == null) {
            return;
        }
        long now_mono = SystemTime.getMonotonousTime();
        if (update_completed && this.last_image != this.icon_idle && (long)this.last_update_count >= this.last_image_expiry_uc_min && now_mono >= this.last_image_expiry_mono) {
            this.last_image = this.icon_idle;
            this.status.setImage(this.icon_idle);
        }
        StringBuilder tooltip_text = new StringBuilder(256);
        tooltip_text.append(MessageText.getString("pairing.ui.icon.tip"));
        long newest_bad_mono = -1L;
        long newest_good_mono = -1L;
        Iterator<Map.Entry<String, RemoteHistory>> it = this.history_map.entrySet().iterator();
        String oldest_type = null;
        long oldest_type_mono = Long.MAX_VALUE;
        int records_added = 0;
        while (it.hasNext()) {
            Map.Entry<String, RemoteHistory> entry = it.next();
            String name = entry.getKey();
            RemoteHistory history = entry.getValue();
            String oldest_ip = null;
            long oldest_ip_mono = Long.MAX_VALUE;
            Map records = history.getEntries();
            Iterator record_it = records.entrySet().iterator();
            StringBuilder tt_ip_details = new StringBuilder(256);
            while (record_it.hasNext()) {
                long age;
                Map.Entry record = record_it.next();
                String ip = (String)record.getKey();
                RemoteHistoryEntry e = (RemoteHistoryEntry)record.getValue();
                long e_mono = e.getLastReceivedMono();
                if (e_mono < oldest_ip_mono) {
                    oldest_ip_mono = e_mono;
                    oldest_ip = ip;
                }
                if ((age = now_mono - e_mono) > 3600000L) {
                    record_it.remove();
                    continue;
                }
                String age_str = TimeFormatter.format(age / 1000L);
                tt_ip_details.append("\n        ");
                if (this.local_addresses.contains(ip)) {
                    tt_ip_details.append(MessageText.getString("DHTView.db.local")).append(" (").append(ip).append(")");
                } else {
                    tt_ip_details.append(ip);
                }
                if (e.wasLastGood()) {
                    tt_ip_details.append(" OK");
                    newest_good_mono = Math.max(newest_good_mono, e_mono);
                } else {
                    tt_ip_details.append(" ").append(MessageText.getString("label.access.denied"));
                    newest_bad_mono = Math.max(newest_bad_mono, e_mono);
                }
                tt_ip_details.append(" - ").append(age_str).append(" ago");
            }
            if (records.size() == 0) {
                it.remove();
                continue;
            }
            if (oldest_ip_mono < oldest_type_mono) {
                oldest_type_mono = oldest_ip_mono;
                oldest_type = name;
            }
            if (records.size() >= 10) {
                records.remove(oldest_ip);
                continue;
            }
            tooltip_text.append("\n    ").append(name);
            tooltip_text.append((CharSequence)tt_ip_details);
            ++records_added;
        }
        if (this.history_map.size() > 10) {
            this.history_map.remove(oldest_type);
        }
        if (records_added == 0) {
            tooltip_text.append("\n    ").append(MessageText.getString("pairing.ui.icon.tip.no.recent"));
        }
        if (!(tooltip_text_str = tooltip_text.toString()).equals(this.last_tooltip_text)) {
            this.last_tooltip_text = tooltip_text_str;
            Utils.setTT(this.status, this.last_tooltip_text);
        }
        Image target_image = null;
        long age_newest_bad = now_mono - newest_bad_mono;
        if (newest_bad_mono >= 0L && age_newest_bad <= 300000L) {
            target_image = this.icon_red;
            this.last_image_expiry_mono = newest_bad_mono + 300000L;
        } else {
            long age_newest_good = now_mono - newest_good_mono;
            if (newest_good_mono >= 0L && age_newest_good <= 1000L) {
                target_image = this.icon_green;
                this.last_image_expiry_mono = age_newest_good + 1000L;
            }
        }
        if (target_image != null && target_image != this.last_image) {
            this.last_image = target_image;
            this.last_image_expiry_uc_min = this.last_update_count + 2;
            this.status.setImage(target_image);
        }
    }

    @Override
    public char[] getSRPPassword() {
        CryptoWindow pw_win = new CryptoWindow(true);
        CryptoManagerPasswordHandler.passwordDetails result = pw_win.getPassword(-1, 3, true, "Change SRP Password");
        if (result != null) {
            return result.getPassword();
        }
        return null;
    }

    private static class RemoteHistory {
        private final Map<String, RemoteHistoryEntry> map = new HashMap<String, RemoteHistoryEntry>();

        private RemoteHistory() {
        }

        private void addRequest(String ip, boolean good) {
            RemoteHistoryEntry entry = this.map.get(ip);
            if (entry == null) {
                entry = new RemoteHistoryEntry();
                this.map.put(ip, entry);
            }
            entry.update(good);
        }

        private Map<String, RemoteHistoryEntry> getEntries() {
            return this.map;
        }
    }

    private static class RemoteHistoryEntry {
        private long last_received_mono;
        private long last_received_rtc;
        private int request_count;
        private boolean last_was_good;

        private RemoteHistoryEntry() {
        }

        private long getLastReceivedMono() {
            return this.last_received_mono;
        }

        private long getLastReceivedRTC() {
            return this.last_received_rtc;
        }

        private int getRequestCount() {
            return this.request_count;
        }

        private boolean wasLastGood() {
            return this.last_was_good;
        }

        private void update(boolean good) {
            this.last_received_mono = SystemTime.getMonotonousTime();
            this.last_received_rtc = SystemTime.getCurrentTime();
            ++this.request_count;
            this.last_was_good = good;
        }
    }
}

