/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config.wizard;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.config.wizard.ConfigureWizard;
import com.biglybt.ui.swt.config.wizard.FilePanel;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.nat.NATTestHelpers;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NatPanel
extends AbstractWizardPanel<ConfigureWizard> {
    StyledText textResults;
    Button bTestTCP;
    Button bTestUDP;

    public NatPanel(ConfigureWizard wizard, IWizardPanel<ConfigureWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((ConfigureWizard)this.wizard).setTitle(MessageText.getString("configureWizard.nat.title"));
        Composite rootPanel = ((ConfigureWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 80;
        textServerTCPListen.setLayoutData((Object)gridData);
        textServerTCPListen.setText("" + ((ConfigureWizard)this.wizard).serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int TCPListenPort;
                    ((ConfigureWizard)((NatPanel)NatPanel.this).wizard).serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.bTestTCP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestTCP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestTCP.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.udp_listen_port");
        final Text textServerUDPListen = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 80;
        textServerUDPListen.setLayoutData((Object)gridData);
        textServerUDPListen.setText("" + ((ConfigureWizard)this.wizard).serverUDPListenPort);
        textServerUDPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        textServerUDPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int UDPListenPort;
                    ((ConfigureWizard)((NatPanel)NatPanel.this).wizard).serverUDPListenPort = UDPListenPort = Integer.parseInt(textServerUDPListen.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.bTestUDP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestUDP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestUDP.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        this.textResults = new StyledText(panel, 2626);
        gridData = new GridData(1808);
        gridData.heightHint = 70;
        gridData.horizontalSpan = 4;
        this.textResults.setLayoutData((Object)gridData);
        this.textResults.setBackground(Colors.getSystemColor((Device)panel.getDisplay(), 1));
        this.bTestTCP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((ConfigureWizard)NatPanel.this.wizard).setNextEnabled(false);
                NatPanel.this.bTestTCP.setEnabled(false);
                NatPanel.this.bTestUDP.setEnabled(false);
                NatPanel.this.textResults.setText("");
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        ConfigureWizard cw = (ConfigureWizard)NatPanel.this.wizard;
                        int TCPListenPort = cw.serverTCPListenPort;
                        CheckerTCP checker = new CheckerTCP(TCPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bTestUDP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ((ConfigureWizard)NatPanel.this.wizard).setNextEnabled(false);
                NatPanel.this.bTestTCP.setEnabled(false);
                NatPanel.this.bTestUDP.setEnabled(false);
                NatPanel.this.textResults.setText("");
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        ConfigureWizard cw = (ConfigureWizard)NatPanel.this.wizard;
                        int UDPListenPort = cw.serverUDPListenPort;
                        CheckerUDP checker = new CheckerUDP(core, UDPListenPort);
                        checker.start();
                    }
                });
            }
        });
    }

    public void printMessage(final String message) {
        Display display = ((ConfigureWizard)this.wizard).getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (NatPanel.this.textResults == null || NatPanel.this.textResults.isDisposed()) {
                    return;
                }
                NatPanel.this.textResults.append(message);
            }
        });
    }

    private void enableNext() {
        Display display = ((ConfigureWizard)this.wizard).getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (NatPanel.this.bTestTCP == null || NatPanel.this.bTestTCP.isDisposed()) {
                    return;
                }
                if (NatPanel.this.bTestUDP == null || NatPanel.this.bTestUDP.isDisposed()) {
                    return;
                }
                ((ConfigureWizard)NatPanel.this.wizard).setNextEnabled(true);
                NatPanel.this.bTestTCP.setEnabled(true);
                NatPanel.this.bTestUDP.setEnabled(true);
            }
        });
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public IWizardPanel<ConfigureWizard> getNextPanel() {
        return new FilePanel((ConfigureWizard)this.wizard, this);
    }

    public class CheckerTCP
    extends AEThread2 {
        private int TCPListenPort;

        public CheckerTCP(int tcp_listen_port) {
            super("NAT Checker TCP");
            this.TCPListenPort = tcp_listen_port;
        }

        @Override
        public void run() {
            try {
                NATTestHelpers.runTCP(this.TCPListenPort, NatPanel.this::printMessage);
            }
            finally {
                NatPanel.this.enableNext();
            }
        }
    }

    public class CheckerUDP
    extends AEThread2 {
        private Core core;
        private int udp_port;

        public CheckerUDP(Core _core, int _udp_port) {
            super("NAT Checker UDP");
            this.core = _core;
            this.udp_port = _udp_port;
        }

        @Override
        public void run() {
            try {
                NATTestHelpers.runUDP(this.core, this.udp_port, NatPanel.this::printMessage);
            }
            finally {
                NatPanel.this.enableNext();
            }
        }
    }
}

