/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.pifimpl.local.ui.config.PasswordParameterImpl;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.utils.FontUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PasswordSwtParameter
extends BaseSwtParameter<PasswordSwtParameter, byte[]> {
    Text inputField;
    private final int encoding;

    public PasswordSwtParameter(Composite composite, String configID, String labelKey) {
        this(composite, configID, labelKey, 2);
    }

    public PasswordSwtParameter(Composite parent, String configID, String labelKey, int encoding) {
        super(configID);
        GridData gridData;
        if (configID != null) {
            this.setConfigValueProcessor(byte[].class);
        }
        this.encoding = encoding;
        this.createStandardLabel(parent, labelKey);
        this.inputField = new Text(parent, 2048);
        this.setMainControl((Control)this.inputField);
        this.inputField.setEchoChar('*');
        byte[] value = this.getByteArrayValue();
        this.inputField.setMessage(value.length > 0 ? MessageText.getString("ConfigView.password.isset") : "");
        if (this.doGridData(parent)) {
            gridData = new GridData();
            gridData.widthHint = 150;
            this.inputField.setLayoutData((Object)gridData);
        }
        this.inputField.addListener(24, event2 -> {
            try {
                byte[] encoded;
                String password_string = this.inputField.getText();
                byte[] password = password_string.getBytes();
                if (password.length > 0) {
                    switch (encoding) {
                        case 1: {
                            encoded = password;
                            break;
                        }
                        case 2: {
                            SHA1Hasher hasher = new SHA1Hasher();
                            encoded = hasher.calculateHash(password);
                            break;
                        }
                        default: {
                            encoded = MessageDigest.getInstance("md5").digest(password_string.getBytes("UTF-8"));
                            break;
                        }
                    }
                } else {
                    encoded = password;
                }
                this.setValue(encoded);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        });
        if (this.doGridData(parent)) {
            gridData = new GridData(768);
            gridData.widthHint = 150;
            this.inputField.setLayoutData((Object)gridData);
        }
    }

    public PasswordSwtParameter(Composite parent, PasswordParameterImpl param) {
        this(parent, param.getConfigKeyName(), param.getLabelKey(), param.getEncodingType());
        this.setPluginParameter(param);
        int characters = param.getWidthInCharacters();
        if (characters > 0) {
            this.setWidthInCharacters(characters);
        }
    }

    private byte[] getByteArrayValue() {
        if (this.valueProcessor == null) {
            return "".getBytes();
        }
        byte[] value = (byte[])this.valueProcessor.getValue(this);
        return value == null ? "".getBytes() : value;
    }

    private void setUiValue(String value) {
        Utils.execSWTThread(() -> {
            if (this.inputField.isDisposed()) {
                return;
            }
            this.inputField.setMessage(value.length() > 0 ? MessageText.getString("ConfigView.password.isset") : "");
            if (!this.inputField.getText().equals(value)) {
                this.inputField.setText(value);
            }
        });
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        if (this.encoding == 1) {
            byte[] value = this.getValue();
            if (value == null) {
                return;
            }
            try {
                this.setUiValue(new String(value, "utf8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte[] getValue() {
        if (this.encoding == 1 && this.valueProcessor != null) {
            return (byte[])this.valueProcessor.getValue(this);
        }
        return null;
    }

    public void setWidthInCharacters(int i) {
        Object data = this.inputField.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).widthHint = (int)Math.ceil((double)i * FontUtils.getCharacterWidth(this.inputField.getFont()));
            this.inputField.setLayoutData(data);
        }
    }
}

