/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.Core;
import com.biglybt.core.ipfilter.IpRange;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IpFilterEditor {
    Core core;
    boolean done = false;

    public IpFilterEditor(Core _core, Shell parent, final IpRange existing_range, Runnable run_when_done) {
        this.core = _core;
        String existing_desc = existing_range == null ? null : existing_range.getDescription();
        String existing_start = existing_range == null ? null : existing_range.getStartIp();
        String existing_end = existing_range == null ? null : existing_range.getEndIp();
        final IpRange new_v4 = this.core.getIpFilterManager().getIPFilter().createRange(1, false);
        final IpRange new_v6 = this.core.getIpFilterManager().getIPFilter().createRange(2, false);
        final Shell shell = ShellFactory.createShell(parent, 67680);
        Messages.setLanguageText((Widget)shell, "ConfigView.section.ipfilter.editFilter");
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "label.description");
        final Text textDescription = new Text((Composite)shell, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        textDescription.setLayoutData((Object)gridData);
        label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.ipfilter.start");
        final Text textStartIp = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 120;
        textStartIp.setLayoutData((Object)gridData);
        label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.ipfilter.end");
        final Text textEndIp = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 120;
        textEndIp.setLayoutData((Object)gridData);
        final Button ok = new Button((Composite)shell, 8);
        Messages.setLanguageText((Widget)ok, "Button.ok");
        shell.setDefaultButton(ok);
        ok.setEnabled(existing_range != null);
        gridData = new GridData(896);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 100;
        ok.setLayoutData((Object)gridData);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (existing_range == null) {
                    new_v4.setDescription(textDescription.getText());
                    new_v4.setStartIp(textStartIp.getText());
                    new_v4.setEndIp(textEndIp.getText());
                    new_v4.checkValid();
                    if (new_v4.isValid()) {
                        IpFilterEditor.this.core.getIpFilterManager().getIPFilter().addRange(new_v4);
                    } else {
                        new_v6.setDescription(textDescription.getText());
                        new_v6.setStartIp(textStartIp.getText());
                        new_v6.setEndIp(textEndIp.getText());
                        new_v6.checkValid();
                        IpFilterEditor.this.core.getIpFilterManager().getIPFilter().addRange(new_v6);
                    }
                } else {
                    existing_range.setDescription(textDescription.getText());
                    existing_range.setStartIp(textStartIp.getText());
                    existing_range.setEndIp(textEndIp.getText());
                    existing_range.checkValid();
                }
                IpFilterEditor.this.done = true;
                shell.dispose();
            }
        });
        textStartIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event2) {
                boolean valid = false;
                if (existing_range == null) {
                    new_v4.setStartIp(textStartIp.getText());
                    new_v4.checkValid();
                    valid = new_v4.isValid();
                    if (!valid) {
                        new_v6.setStartIp(textStartIp.getText());
                        new_v6.checkValid();
                        valid = new_v6.isValid();
                    }
                } else {
                    existing_range.setStartIp(textStartIp.getText());
                    existing_range.checkValid();
                    valid = existing_range.isValid();
                }
                ok.setEnabled(valid);
            }
        });
        textEndIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event2) {
                boolean valid = false;
                if (existing_range == null) {
                    new_v4.setEndIp(textEndIp.getText());
                    new_v4.checkValid();
                    valid = new_v4.isValid();
                    if (!valid) {
                        new_v6.setEndIp(textEndIp.getText());
                        new_v6.checkValid();
                        valid = new_v6.isValid();
                    }
                } else {
                    existing_range.setEndIp(textEndIp.getText());
                    existing_range.checkValid();
                    valid = existing_range.isValid();
                }
                ok.setEnabled(valid);
            }
        });
        if (existing_range != null) {
            textDescription.setText(existing_range.getDescription());
            textStartIp.setText(existing_range.getStartIp());
            textEndIp.setText(existing_range.getEndIp());
        }
        shell.addListener(12, ev -> {
            if (!this.done && existing_range != null) {
                existing_range.setDescription(existing_desc);
                existing_range.setStartIp(existing_start);
                existing_range.setEndIp(existing_end);
                existing_range.checkValid();
            }
            if (run_when_done != null) {
                run_when_done.run();
            }
        });
        shell.pack();
        Utils.centerWindowRelativeTo(shell, (Control)parent);
        shell.open();
    }
}

