/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class IntRadioListSwtParameter
extends BaseSwtParameter<IntRadioListSwtParameter, Integer> {
    private final Composite cHolder;
    private final Button[] radios;
    private final int[] values;

    public IntRadioListSwtParameter(Composite composite, IntListParameterImpl param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), param.getValues(), param.getLabels(), param.getListType() == 1, null);
        this.setPluginParameter(param);
    }

    public IntRadioListSwtParameter(Composite composite, String paramID, String labelKey, int[] values, String[] displayStrings, boolean compact, SwtParameterValueProcessor<IntRadioListSwtParameter, Integer> valueProcessor) {
        super(paramID);
        this.values = values;
        boolean doGridData = this.doGridData(composite);
        this.createStandardLabel(composite, labelKey);
        this.cHolder = new Composite(composite, 0);
        this.setMainControl((Control)this.cHolder);
        RowLayout rowLayout = Utils.getSimpleRowLayout(false);
        rowLayout.type = compact ? 256 : 512;
        this.cHolder.setLayout((Layout)rowLayout);
        if (doGridData) {
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.cHolder.setLayoutData((Object)gridData);
        }
        this.radios = new Button[displayStrings.length];
        if (displayStrings.length != values.length) {
            return;
        }
        Listener listener = event2 -> {
            Button button = (Button)event2.widget;
            if (button == null || button.isDisposed()) {
                return;
            }
            if (button.getSelection()) {
                int val = ((Number)button.getData("value")).intValue();
                this.setValue(val);
            }
        };
        int i = 0;
        while (i < displayStrings.length) {
            this.radios[i] = new Button(this.cHolder, 16);
            this.radios[i].setText(displayStrings[i]);
            this.radios[i].setData("value", (Object)values[i]);
            this.radios[i].addListener(13, listener);
            this.radios[i].setLayoutData((Object)new RowData());
            ++i;
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (this.paramID != null) {
            this.setConfigValueProcessor(Integer.class);
        }
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.cHolder.isDisposed()) {
                return;
            }
            Integer val = (Integer)this.getValue();
            int index = -1;
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i] == val) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index >= 0) {
                this.radios[index].setSelection(true);
            }
        });
    }

    @Override
    public Control[] getControls() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.cHolder);
        Control relatedControl = this.getRelatedControl();
        if (relatedControl != null) {
            list.add(relatedControl);
        }
        Collections.addAll(list, this.radios);
        return list.toArray(new Control[0]);
    }
}

