/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.util.Debug;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class IntListSwtParameter
extends BaseSwtParameter<IntListSwtParameter, Integer> {
    private final Combo list;
    private Label lblSuffix;
    private final int[] values;

    public IntListSwtParameter(Composite composite, IntListParameterImpl param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), param.getSuffixLabelKey(), param.getValues(), param.getLabels(), null);
        this.setPluginParameter(param);
    }

    public IntListSwtParameter(Composite composite, String configID, String labelKey, String suffixLabelKey, int[] values, String[] displayStrings, SwtParameterValueProcessor<IntListSwtParameter, Integer> valueProcessor) {
        super(configID);
        Composite parent;
        this.values = values;
        boolean doGridData = this.doGridData(composite);
        this.createStandardLabel(composite, labelKey);
        if (suffixLabelKey == null) {
            parent = composite;
        } else {
            parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        this.list = new Combo(parent, 12);
        this.setMainControl((Control)this.list);
        if (doGridData) {
            GridData gridData = new GridData();
            this.list.setLayoutData((Object)gridData);
        }
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (displayStrings.length != values.length) {
            Debug.out("displayStrings.length != values.length");
            return;
        }
        String[] stringArray = displayStrings;
        int n = displayStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String displayString = stringArray[n2];
            if (Utils.isGTK) {
                displayString = String.valueOf(displayString) + " ";
            }
            this.list.add(displayString);
            ++n2;
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (this.paramID != null) {
            this.setConfigValueProcessor(Integer.class);
        }
        this.list.addListener(13, e -> this.setValue(values[this.list.getSelectionIndex()]));
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            if (this.list.isDisposed()) {
                return;
            }
            this.refreshSuffixControl((Control)this.lblSuffix);
            int index = IntListSwtParameter.findIndex((Integer)this.getValue(), this.values);
            if (this.list.getSelectionIndex() != index) {
                this.list.select(index);
            }
        });
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        return list.toArray(new Control[0]);
    }

    private static int findIndex(Integer value, int[] values) {
        if (value == null) {
            return 0;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static interface ValueProcessor
    extends SwtParameterValueProcessor<IntListSwtParameter, Integer> {
    }
}

