/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components;

import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class LinkLabel {
    private static final String MOUSE_LISTENER_KEY = "LinkLabel.ml";
    private final Label linkLabel;

    public LinkLabel(Composite composite, String resource, String link) {
        this(composite, new GridData(), resource, link);
    }

    public LinkLabel(Composite composite, GridData gridData, String resource, String link) {
        this.linkLabel = new Label(composite, 0);
        Messages.setLanguageText((Widget)this.linkLabel, resource);
        this.linkLabel.setLayoutData((Object)gridData);
        LinkLabel.makeLinkedLabel(this.linkLabel, link);
    }

    public LinkLabel(Composite composite, String resource, Runnable runnable) {
        this(composite, new GridData(), resource, runnable);
    }

    public LinkLabel(Composite composite, GridData gridData, String resource, Runnable runnable) {
        this.linkLabel = new Label(composite, 0);
        Messages.setLanguageText((Widget)this.linkLabel, resource);
        this.linkLabel.setLayoutData((Object)gridData);
        LinkLabel.makeLinkedLabel(this.linkLabel, runnable);
    }

    public Label getlabel() {
        return this.linkLabel;
    }

    public static void makeLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        String tooltip = label.getToolTipText();
        if (tooltip == null && !hyperlink.equals(label.getText())) {
            Utils.setTT((Control)label, hyperlink.replaceAll("&", "&&"));
        }
        Display display = label.getDisplay();
        label.setCursor(display.getSystemCursor(21));
        Utils.setLinkForeground((Control)label);
        MouseAdapter ml = (MouseAdapter)label.getData(MOUSE_LISTENER_KEY);
        if (ml != null) {
            label.removeMouseListener((MouseListener)ml);
        }
        ml = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                this.launch(arg0);
            }

            public void mouseUp(MouseEvent arg0) {
                if (arg0.button == 1) {
                    this.launch(arg0);
                }
            }

            private void launch(MouseEvent arg0) {
                String url = (String)((Label)arg0.widget).getData();
                if (url != null) {
                    Utils.launch(url);
                }
            }
        };
        label.setData(MOUSE_LISTENER_KEY, (Object)ml);
        label.addMouseListener((MouseListener)ml);
        ClipboardCopy.addCopyToClipMenu((Control)label);
    }

    public static void updateLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        Utils.setTT((Control)label, hyperlink);
    }

    public static void removeLinkedLabel(Label label) {
        label.setCursor(null);
        label.setForeground(null);
        label.setData(null);
        MouseAdapter ml = (MouseAdapter)label.getData(MOUSE_LISTENER_KEY);
        if (ml != null) {
            label.removeMouseListener((MouseListener)ml);
        }
        ClipboardCopy.removeCopyToClipMenu((Control)label);
    }

    public static void makeLinkedLabel(Label label, final Runnable runnable) {
        label.setCursor(label.getDisplay().getSystemCursor(21));
        Utils.setLinkForeground((Control)label);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                runnable.run();
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    runnable.run();
                }
            }
        });
    }
}

