/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.vuzeactivity;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnActivityType
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "activityType";
    private static final int WIDTH = 42;
    private static SimpleDateFormat timeFormat = new SimpleDateFormat("h:mm:ss a, EEEE, MMMM d, yyyy");

    public ColumnActivityType(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(42);
    }

    @Override
    public void cellPaint(GC gc, final TableCellSWT cell) {
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        String iconID = entry.getIconID();
        if (iconID != null) {
            Image imgIcon;
            ImageLoader imageLoader = ImageLoader.getInstance();
            if (iconID.startsWith("http")) {
                imgIcon = imageLoader.getUrlImage(iconID, new ImageLoader.ImageDownloaderListener(){

                    @Override
                    public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                        if (returnedImmediately) {
                            return;
                        }
                        cell.invalidate();
                    }
                });
                if (imgIcon == null) {
                    return;
                }
            } else {
                imgIcon = imageLoader.getImage(iconID);
            }
            if (ImageLoader.isRealImage(imgIcon)) {
                Rectangle cellBounds = cell.getBounds();
                Rectangle imgBounds = imgIcon.getBounds();
                gc.drawImage(imgIcon, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
            }
            imageLoader.releaseImage(iconID);
        }
    }

    @Override
    public void refresh(TableCell cell) {
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        String sort = String.valueOf(entry.getTypeID()) + entry.getIconID();
        if (cell.setSortValue((Comparable)((Object)sort)) || !cell.isValid()) {
            String ts = timeFormat.format(new Date(entry.getTimestamp()));
            cell.setToolTip("Activity occurred on " + ts);
        }
    }
}

