/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.FilesViewMenuUtil;
import java.util.Collections;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ColumnTorrentFileProgress {
    private Image imgArrowButton;
    private Image imgPriHi;
    private Image imgPriNormal;
    private Image imgPriStopped;
    private Image imgBGfile;
    private Font progressFont;
    private Display display;
    private Color cBGdl;
    private Color cBGcd;
    private Color cBGskipped;

    public ColumnTorrentFileProgress(Display display) {
        this.display = display;
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgArrowButton = imageLoader.getImage("image.fileprogress.arrowbtn");
        this.imgPriHi = imageLoader.getImage("image.fileprogress.pri.hi");
        this.imgPriNormal = imageLoader.getImage("image.fileprogress.pri.normal");
        this.imgPriStopped = imageLoader.getImage("image.fileprogress.pri.stopped");
        this.imgBGfile = imageLoader.getImage("image.progress.bg.file");
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.cBGdl = skinProperties.getColor("color.progress.bg.dl");
        if (this.cBGdl == null) {
            this.cBGdl = Colors.blues[9];
        }
        this.cBGcd = skinProperties.getColor("color.progress.bg.cd");
        if (this.cBGcd == null) {
            this.cBGcd = Colors.green;
        }
        this.cBGskipped = skinProperties.getColor("color.progress.bg.cd");
    }

    void fillInfoProgressETA(TableRowCore row, GC gc, DiskManagerFileInfo fileInfo2, Rectangle cellArea) {
        long percent = 0L;
        long bytesDownloaded = fileInfo2.getDownloaded();
        long length = fileInfo2.getLength();
        if (this.cBGskipped == null) {
            this.cBGskipped = ColorCache.getSchemedColor((Device)this.display, "#a6bdce");
        }
        if (bytesDownloaded < 0L) {
            return;
        }
        if (length == 0L) {
            percent = 1000L;
        } else if (fileInfo2.getLength() != 0L) {
            percent = 1000L * bytesDownloaded / length;
        }
        gc.setAdvanced(true);
        gc.setTextAntialias(1);
        int BUTTON_WIDTH = this.imgArrowButton.getBounds().width;
        int HILOW_WIDTH = this.imgPriHi.getBounds().width;
        int BUTTON_HEIGHT = this.imgArrowButton.getBounds().height;
        int HILOW_HEIGHT = this.imgPriHi.getBounds().height;
        int PADDING_X = 12;
        int PADDING_TEXT = 5;
        int PROGRESS_HEIGHT = this.imgBGfile.getBounds().height;
        int PROGRESS_TO_HILOW_GAP = 3;
        int HILOW_TO_BUTTON_GAP = 3;
        cellArea.width -= 3;
        int ofsX = 12;
        int ofsY = cellArea.height / 2 - PROGRESS_HEIGHT / 2 - 1;
        int progressWidth = cellArea.width - ofsX * 2 - 3 - HILOW_WIDTH - 3 - BUTTON_WIDTH;
        if (progressWidth > 0) {
            if (this.progressFont == null) {
                this.progressFont = FontUtils.getFontWithHeight(gc.getFont(), PROGRESS_HEIGHT - 2, -1);
            }
            gc.setFont(this.progressFont);
            gc.setForeground(ColorCache.getSchemedColor((Device)this.display, fileInfo2.isSkipped() ? "#95a6b2" : "#88acc1"));
            gc.drawRectangle(cellArea.x + ofsX, cellArea.y + ofsY - 1, progressWidth, PROGRESS_HEIGHT + 1);
            int pctWidth = (int)(percent * (long)(progressWidth - 1) / 1000L);
            gc.setBackground(fileInfo2.isSkipped() ? this.cBGskipped : (percent == 1000L || fileInfo2.getDownloadManager().isDownloadComplete(false) ? this.cBGcd : this.cBGdl));
            gc.fillRectangle(cellArea.x + ofsX + 1, cellArea.y + ofsY, pctWidth, PROGRESS_HEIGHT);
            gc.setBackground(Colors.white);
            gc.fillRectangle(cellArea.x + ofsX + pctWidth + 1, cellArea.y + ofsY, progressWidth - pctWidth - 1, PROGRESS_HEIGHT);
            Rectangle boundsImgBG = this.imgBGfile.getBounds();
            gc.drawImage(this.imgBGfile, boundsImgBG.x, boundsImgBG.y, boundsImgBG.width, boundsImgBG.height, cellArea.x + ofsX + 1, cellArea.y + ofsY, progressWidth - 1, PROGRESS_HEIGHT);
        }
        Color colorText = ColorCache.getSchemedColor((Device)this.display, fileInfo2.isSkipped() ? "#556875" : "#2678b1");
        Rectangle printBounds = new Rectangle(cellArea.x + 12 + 5, cellArea.y, progressWidth - 10, cellArea.height);
        ofsY = cellArea.height / 2 - BUTTON_HEIGHT / 2 - 1;
        Rectangle buttonBounds = new Rectangle(cellArea.x + cellArea.width - BUTTON_WIDTH - 12, cellArea.y + ofsY, BUTTON_WIDTH, BUTTON_HEIGHT);
        row.setData("buttonBounds", buttonBounds);
        ofsY = cellArea.height / 2 - HILOW_HEIGHT / 2 - 1;
        Rectangle hilowBounds = new Rectangle(buttonBounds.x - 3 - HILOW_WIDTH, cellArea.y + ofsY, HILOW_WIDTH, HILOW_HEIGHT);
        row.setData("hilowBounds", hilowBounds);
        gc.setForeground(colorText);
        String s = DisplayFormatters.formatPercentFromThousands((int)percent);
        GCStringPrinter.printString(gc, s, printBounds, true, false, 16384);
        String tmp = null;
        if (fileInfo2.getDownloadManager().getState() == 70) {
            tmp = MessageText.getString("FileProgress.stopped");
        } else {
            int pri;
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileProgress.deleted");
            } else if (fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileProgress.stopped");
            } else if (fileInfo2.getPriority() > 0 && (pri = fileInfo2.getPriority()) > 1) {
                tmp = MessageText.getString("FileItem.high");
                tmp = String.valueOf(tmp) + " (" + pri + ")";
            }
        }
        if (tmp != null) {
            GCStringPrinter.printString(gc, tmp.toUpperCase(), printBounds, false, false, 131072);
        }
        gc.drawImage(this.imgArrowButton, buttonBounds.x, buttonBounds.y);
        Image imgPriority = fileInfo2.isSkipped() ? this.imgPriStopped : (fileInfo2.getPriority() > 0 ? this.imgPriHi : this.imgPriNormal);
        gc.drawImage(imgPriority, hilowBounds.x, hilowBounds.y);
        hilowBounds.y -= cellArea.y;
        hilowBounds.x -= cellArea.x;
        buttonBounds.x -= cellArea.x;
        buttonBounds.y -= cellArea.y;
    }

    public void fileInfoMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType != 0) {
            return;
        }
        final Object dataSource = ((TableRowCore)event2.row).getDataSource(true);
        if (dataSource instanceof DiskManagerFileInfo) {
            Rectangle buttonBounds;
            final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)dataSource;
            Rectangle hilowBounds = (Rectangle)event2.row.getData("hilowBounds");
            if (event2.button == 1 && hilowBounds != null && hilowBounds.contains(event2.x, event2.y)) {
                if (fileInfo2.getPriority() > 0) {
                    fileInfo2.setPriority(0);
                } else {
                    fileInfo2.setPriority(1);
                }
                ((TableRowCore)event2.row).redraw();
            }
            if ((buttonBounds = (Rectangle)event2.row.getData("buttonBounds")) != null && buttonBounds.contains(event2.x, event2.y)) {
                Menu menu = new Menu((Decorations)Display.getDefault().getActiveShell(), 8);
                MenuItem itemHigh = new MenuItem(menu, 16);
                Messages.setLanguageText((Widget)itemHigh, "priority.high");
                itemHigh.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_HIGH, Collections.singletonList(fileInfo2));
                    }
                });
                itemHigh.setSelection(fileInfo2.getPriority() != 0);
                MenuItem itemNormal = new MenuItem(menu, 16);
                Messages.setLanguageText((Widget)itemNormal, "priority.normal");
                itemNormal.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, Collections.singletonList(fileInfo2));
                    }
                });
                itemNormal.setSelection(fileInfo2.getPriority() == 0);
                new MenuItem(menu, 2);
                boolean canStart = fileInfo2.isSkipped() || fileInfo2.getDownloadManager().getState() == 70;
                MenuItem itemStop = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemStop, "v3.MainWindow.button.stop");
                itemStop.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_SKIPPED, Collections.singletonList(fileInfo2));
                    }
                });
                itemStop.setEnabled(!canStart);
                MenuItem itemStart = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemStart, "v3.MainWindow.button.start");
                itemStart.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (fileInfo2.getDownloadManager().getState() == 70) {
                            TorrentUtil.queueDataSources(new Object[]{dataSource}, false);
                        }
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, Collections.singletonList(fileInfo2));
                    }
                });
                itemStart.setEnabled(canStart);
                new MenuItem(menu, 2);
                MenuItem itemDelete = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemDelete, "v3.MainWindow.button.delete");
                itemDelete.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_DELETE, Collections.singletonList(fileInfo2));
                    }
                });
                menu.setVisible(true);
                event2.skipCoreFunctionality = true;
            }
        }
    }
}

