/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ColumnTagDependsOn
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.dependson";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagDependsOn(TableColumn column) {
        column.setWidth(160);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Tag tag = (Tag)cell.getDataSource();
        String str = null;
        if (tag != null) {
            List<Tag> tags = tag.dependsOnTags();
            if (tags != null) {
                StringBuilder sb = new StringBuilder(256);
                HashSet<Tag> path = new HashSet<Tag>();
                path.add(tag);
                this.explode(sb, path, tags);
                str = sb.toString();
            } else {
                str = "";
            }
        }
        if (!cell.setSortValue((Comparable)((Object)str)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(str);
    }

    private void explode(StringBuilder sb, Set<Tag> path, List<Tag> tags) {
        String sep = "";
        for (Tag t : tags) {
            if (sep.isEmpty()) {
                sep = ", ";
            } else {
                sb.append(sep);
            }
            if (path.contains(t)) {
                sb.append("Recursive on " + t.getTagName(true));
                continue;
            }
            sb.append(t.getTagName(true));
            List<Tag> kids = t.dependsOnTags();
            if (kids == null || kids.isEmpty()) continue;
            sb.append(" ( ");
            path.add(t);
            this.explode(sb, path, kids);
            path.remove(t);
            sb.append(" )");
        }
    }
}

