/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.Subscription;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSubscriptionName
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellMouseListener,
TableCellMouseMoveListener {
    public static String COLUMN_ID = "name";
    int imageWidth = -1;
    int imageHeight = -1;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnSubscriptionName(String sTableID) {
        super(COLUMN_ID, -2, 350, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidth(300);
    }

    @Override
    public void refresh(TableCell cell) {
        String name = null;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            name = sub.getName();
        }
        if (name == null) {
            name = "";
        }
        if (!cell.setSortValue((Comparable)((Object)name)) && cell.isValid()) {
            return;
        }
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image viewImage = imageLoader.getImage("ic_view");
        if (this.imageWidth == -1 || this.imageHeight == -1) {
            this.imageWidth = viewImage.getBounds().width;
            this.imageHeight = viewImage.getBounds().height;
        }
        bounds.width -= this.imageWidth + 5;
        GCStringPrinter.printString(gc, cell.getSortValue().toString(), bounds, true, false, 16384);
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null && !sub.isSearchTemplate()) {
            gc.drawImage(viewImage, bounds.x + bounds.width, bounds.y + bounds.height / 2 - this.imageHeight / 2);
        }
        imageLoader.releaseImage("ic_view");
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Subscription sub;
        TableCell cell;
        int cellWidth;
        int type = event2.eventType;
        if (type == 3 && event2.cell instanceof TableCellSWT) {
            Subscription sub2;
            int cid = 0;
            TableCellSWT cell2 = (TableCellSWT)event2.cell;
            int cellWidth2 = cell2.getWidth();
            if (event2.x > cellWidth2 - this.imageWidth - 5 && event2.x < cellWidth2 - 5 && (sub2 = (Subscription)cell2.getDataSource()) != null && !sub2.isSearchTemplate()) {
                cid = 21;
            }
            cell2.setCursorID(cid);
        } else if (type == 1 && event2.button == 1 && event2.x > (cellWidth = (cell = event2.cell).getWidth()) - this.imageWidth - 5 && event2.x < cellWidth - 5 && (sub = (Subscription)cell.getDataSource()) != null && !sub.isSearchTemplate()) {
            String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                mdi.showEntryByID(key);
            }
        }
    }
}

